/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.listeners.typing.InlineCompletionTypingSessionTracker;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionService;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandler;
import com.intellij.terminal.frontend.view.impl.TerminalInput;
import com.intellij.terminal.frontend.view.impl.TerminalKeyEncodingManager;
import com.intellij.terminal.frontend.view.impl.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.view.impl.TerminalTypeAhead;
import com.intellij.terminal.frontend.view.impl.TerminalVfsSynchronizer;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.terminal.frontend.view.impl.TimedKeyEvent;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.reworked.TerminalCommandCompletion;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.session.ShellName;
import org.jetbrains.plugins.terminal.session.TerminalStartupOptions;
import org.jetbrains.plugins.terminal.session.TerminalStartupOptionsKt;
import org.jetbrains.plugins.terminal.session.impl.TerminalState;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalOutputStatus;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 S2\u00020\u0001:\u0001SBk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u0012\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010'\u001a\u00020-H\u0002J \u00104\u001a\u00020&2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u000208H\u0016J \u00109\u001a\u00020&2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u000208H\u0016J \u0010:\u001a\u00020&2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u000208H\u0016J \u0010;\u001a\u00020&2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u000208H\u0016J \u0010<\u001a\u00020&2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u00020=H\u0016J!\u0010>\u001a\u00020\u001a2\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020AH\u0002\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u0002012\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010D\u001a\u0002012\u0006\u0010E\u001a\u000201H\u0002J\u0018\u0010F\u001a\u0002012\u0006\u00107\u001a\u0002082\u0006\u0010G\u001a\u000201H\u0002J \u0010H\u001a\u00020I2\u0006\u0010J\u001a\u0002012\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u000201H\u0002J\b\u0010K\u001a\u00020&H\u0002J\u0010\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u000203H\u0002J\u0010\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u000203H\u0002J\u0011\u0010P\u001a\u00070Q\u00a2\u0006\u0002\bR*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006T"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandlerImpl;", "Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "encodingManager", "Lcom/intellij/terminal/frontend/view/impl/TerminalKeyEncodingManager;", "terminalInput", "Lcom/intellij/terminal/frontend/view/impl/TerminalInput;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "scrollingModel", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "shellIntegrationDeferred", "Lkotlinx/coroutines/Deferred;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;", "startupOptionsDeferred", "Lorg/jetbrains/plugins/terminal/session/TerminalStartupOptions;", "typeAhead", "Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAhead;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/terminal/frontend/view/impl/TerminalKeyEncodingManager;Lcom/intellij/terminal/frontend/view/impl/TerminalInput;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModel;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lkotlinx/coroutines/Deferred;Lkotlinx/coroutines/Deferred;Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAhead;)V", "ignoreNextKeyTypedEvent", "", "lastMotionReport", "Ljava/awt/Point;", "terminalState", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalState;", "getTerminalState", "()Lorg/jetbrains/plugins/terminal/session/impl/TerminalState;", "vfsSynchronizer", "Lcom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer;", "getVfsSynchronizer", "()Lcom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer;", "keyTyped", "", "e", "Lcom/intellij/terminal/frontend/view/impl/TimedKeyEvent;", "keyPressed", "processTerminalKeyPressed", "processCharacter", "isNoModifiers", "Ljava/awt/event/KeyEvent;", "isAltPressedOnly", "isCodeThatScrolls", "keycode", "", "simpleMapKeyCodeToChar", "", "mousePressed", "x", "y", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseMoved", "mouseDragged", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "shouldSendMouseData", "eligibleModes", "", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "([Lcom/jediterm/terminal/emulator/mouse/MouseMode;)Z", "createButtonCode", "wheelRotationToButtonCode", "wheelRotation", "applyModifierKeys", "cb", "mouseReport", "", "button", "syncEditorCaretWithModel", "scheduleCompletionPopupIfNeeded", "charTyped", "canTriggerCompletion", "char", "getTextAfterCursor", "", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalEventsHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEventsHandlerImpl.kt\ncom/intellij/terminal/frontend/view/impl/TerminalEventsHandlerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,439:1\n67#2,4:440\n67#2,4:444\n67#2,4:448\n67#2,4:452\n67#2,4:456\n67#2,4:460\n67#2,4:464\n67#2,4:468\n*S KotlinDebug\n*F\n+ 1 TerminalEventsHandlerImpl.kt\ncom/intellij/terminal/frontend/view/impl/TerminalEventsHandlerImpl\n*L\n66#1:440,4\n76#1:444,4\n83#1:448,4\n96#1:452,4\n101#1:456,4\n124#1:460,4\n166#1:464,4\n172#1:468,4\n*E\n"})
public class TerminalEventsHandlerImpl
implements TerminalEventsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalKeyEncodingManager encodingManager;
    @NotNull
    private final TerminalInput terminalInput;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @Nullable
    private final TerminalOutputScrollingModel scrollingModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @Nullable
    private final Deferred<TerminalShellIntegration> shellIntegrationDeferred;
    @Nullable
    private final Deferred<TerminalStartupOptions> startupOptionsDeferred;
    @Nullable
    private final TerminalTypeAhead typeAhead;
    private boolean ignoreNextKeyTypedEvent;
    @Nullable
    private Point lastMotionReport;
    @NotNull
    private static final Logger LOG;

    public TerminalEventsHandlerImpl(@NotNull TerminalSessionModel sessionModel, @NotNull EditorEx editor, @NotNull TerminalKeyEncodingManager encodingManager, @NotNull TerminalInput terminalInput, @NotNull JBTerminalSystemSettingsProviderBase settings, @Nullable TerminalOutputScrollingModel scrollingModel, @NotNull TerminalOutputModel outputModel, @Nullable Deferred<? extends TerminalShellIntegration> shellIntegrationDeferred, @Nullable Deferred<? extends TerminalStartupOptions> startupOptionsDeferred, @Nullable TerminalTypeAhead typeAhead) {
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)encodingManager, (String)"encodingManager");
        Intrinsics.checkNotNullParameter((Object)terminalInput, (String)"terminalInput");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.sessionModel = sessionModel;
        this.editor = editor;
        this.encodingManager = encodingManager;
        this.terminalInput = terminalInput;
        this.settings = settings;
        this.scrollingModel = scrollingModel;
        this.outputModel = outputModel;
        this.shellIntegrationDeferred = shellIntegrationDeferred;
        this.startupOptionsDeferred = startupOptionsDeferred;
        this.typeAhead = typeAhead;
    }

    private final TerminalState getTerminalState() {
        return (TerminalState)this.sessionModel.getTerminalState().getValue();
    }

    private final TerminalVfsSynchronizer getVfsSynchronizer() {
        return (TerminalVfsSynchronizer)this.editor.getUserData(TerminalVfsSynchronizer.Companion.getKEY());
    }

    @Override
    public void keyTyped(@NotNull TimedKeyEvent e) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Key typed event received: " + e.getOriginal());
        }
        char charTyped = e.getOriginal().getKeyChar();
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            selectionModel2.removeSelection();
        }
        if (this.ignoreNextKeyTypedEvent) {
            e.getOriginal().consume();
            Logger $this$trace$iv2 = LOG;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Key event ignored: " + e.getOriginal());
            }
            return;
        }
        if (!Character.isISOControl(charTyped)) {
            try {
                if (this.processCharacter(e)) {
                    e.getOriginal().consume();
                    Logger $this$trace$iv3 = LOG;
                    boolean $i$f$trace3 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        logger = $this$trace$iv3;
                        boolean bl = false;
                        logger.trace("Key event consumed: " + e.getOriginal());
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Error sending typed key to emulator", (Throwable)ex);
            }
        }
        this.syncEditorCaretWithModel();
        this.scheduleCompletionPopupIfNeeded(charTyped);
    }

    @Override
    public void keyPressed(@NotNull TimedKeyEvent e) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Key pressed event received: " + e.getOriginal());
        }
        this.ignoreNextKeyTypedEvent = false;
        if (this.processTerminalKeyPressed(e)) {
            e.getOriginal().consume();
            this.ignoreNextKeyTypedEvent = true;
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Key event consumed: " + e.getOriginal());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processTerminalKeyPressed(TimedKeyEvent e) {
        try {
            InlineCompletionTypingSessionTracker inlineCompletionTypingSession;
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull((Editor)this.editor);
            InlineCompletionTypingSessionTracker inlineCompletionTypingSessionTracker = inlineCompletionTypingSession = inlineCompletionHandler != null ? inlineCompletionHandler.getTypingSessionTracker() : null;
            if (inlineCompletionTypingSessionTracker != null) {
                inlineCompletionTypingSessionTracker.endTypingSession((Editor)this.editor);
            }
            InlineCompletionTypingSessionTracker inlineCompletionTypingSessionTracker2 = inlineCompletionTypingSession;
            if (inlineCompletionTypingSessionTracker2 != null) {
                inlineCompletionTypingSessionTracker2.setIgnoreDocumentChanges(false);
            }
            TerminalVfsSynchronizer terminalVfsSynchronizer = this.getVfsSynchronizer();
            if (terminalVfsSynchronizer != null) {
                terminalVfsSynchronizer.handleKeyPressed(e.getOriginal());
            }
            int keyCode = e.getOriginal().getKeyCode();
            char keyChar = e.getOriginal().getKeyChar();
            if (this.isNoModifiers(e.getOriginal()) && keyCode == 8) {
                TerminalTypeAhead terminalTypeAhead = this.typeAhead;
                if (terminalTypeAhead != null) {
                    terminalTypeAhead.backspace();
                }
            }
            if (keyCode == 127 && keyChar == '.') {
                byte[] byArray = new byte[]{46};
                this.terminalInput.sendBytes(byArray);
                Logger $this$trace$iv322 = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv322.isTraceEnabled()) {
                    Logger logger = $this$trace$iv322;
                    boolean bl = false;
                    logger.trace("Key event skipped (numLock on): " + e.getOriginal());
                }
                boolean $this$trace$iv322 = true;
                return $this$trace$iv322;
            }
            if (keyChar == ' ' && (e.getOriginal().getModifiersEx() & 0x80) != 0) {
                byte[] $this$trace$iv322 = new byte[]{0};
                this.terminalInput.sendBytes($this$trace$iv322);
                boolean $this$trace$iv322 = true;
                return $this$trace$iv322;
            }
            byte[] code = this.encodingManager.getCode(keyCode, e.getOriginal().getModifiers());
            if (code != null) {
                this.terminalInput.sendBytes(code);
                if (this.isCodeThatScrolls(keyCode)) {
                    TerminalOutputScrollingModel terminalOutputScrollingModel = this.scrollingModel;
                    if (terminalOutputScrollingModel != null) {
                        terminalOutputScrollingModel.scrollToCursor(true);
                    }
                }
                if (keyCode == 10) {
                    TerminalUsageLocalStorage.Companion.getInstance().recordEnterKeyPressed();
                }
                boolean $i$f$trace = true;
                return $i$f$trace;
            }
            if (this.isAltPressedOnly(e.getOriginal()) && Character.isDefined(keyChar) && this.settings.altSendsEscape()) {
                char[] cArray = new char[]{'\u001b', this.simpleMapKeyCodeToChar(e.getOriginal())};
                String string = new String(cArray);
                this.terminalInput.sendString(string);
                boolean bl = true;
                return bl;
            }
            if (Character.isISOControl(keyChar)) {
                boolean bl = this.processCharacter(e);
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Error sending pressed key to emulator", (Throwable)ex);
        }
        finally {
            this.syncEditorCaretWithModel();
        }
        return false;
    }

    private final boolean processCharacter(TimedKeyEvent e) {
        block8: {
            if (this.isAltPressedOnly(e.getOriginal()) && this.settings.altSendsEscape()) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Key event skipped (alt pressed only): " + e.getOriginal());
                }
                return false;
            }
            char keyChar = e.getOriginal().getKeyChar();
            if (keyChar == '`' && (e.getOriginal().getModifiersEx() & 0x100) != 0) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Key event skipped (command + backtick): " + e.getOriginal());
                }
                return false;
            }
            String typedString = String.valueOf(keyChar);
            if (e.getOriginal().getID() == 400) {
                InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull((Editor)this.editor);
                InlineCompletionTypingSessionTracker inlineCompletionTypingSession = inlineCompletionHandler != null ? inlineCompletionHandler.getTypingSessionTracker() : null;
                this.editor.getCaretModel().moveToOffset(TerminalViewImplKt.toRelative(this.outputModel.getCursorOffset(), this.outputModel));
                InlineCompletionTypingSessionTracker inlineCompletionTypingSessionTracker = inlineCompletionTypingSession;
                if (inlineCompletionTypingSessionTracker != null) {
                    inlineCompletionTypingSessionTracker.startTypingSession((Editor)this.editor);
                }
                TerminalTypeAhead terminalTypeAhead = this.typeAhead;
                if (terminalTypeAhead != null) {
                    terminalTypeAhead.type(typedString);
                }
                this.terminalInput.sendTrackedString(typedString, e.getInitTime());
            } else {
                this.terminalInput.sendString(typedString);
            }
            TerminalOutputScrollingModel terminalOutputScrollingModel = this.scrollingModel;
            if (terminalOutputScrollingModel == null) break block8;
            terminalOutputScrollingModel.scrollToCursor(true);
        }
        return true;
    }

    private final boolean isNoModifiers(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) == 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private final boolean isAltPressedOnly(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) != 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private final boolean isCodeThatScrolls(int keycode) {
        return keycode == 38 || keycode == 40 || keycode == 37 || keycode == 39 || keycode == 8 || keycode == 155 || keycode == 127 || keycode == 10 || keycode == 36 || keycode == 35 || keycode == 33 || keycode == 34;
    }

    private final char simpleMapKeyCodeToChar(KeyEvent e) {
        char keyChar = (char)e.getKeyCode();
        return (e.getModifiersEx() & 0x40) != 0 ? Character.toUpperCase(keyChar) : Character.toLowerCase(keyChar);
    }

    @Override
    public void mousePressed(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            switch (code) {
                case 4: 
                case 5: {
                    int offset = 4;
                    code -= offset;
                    code |= 0x40;
                }
            }
            code = this.applyModifierKeys(event, code);
            this.terminalInput.sendBytes(this.mouseReport(code, x + 1, y + 1));
        }
    }

    @Override
    public void mouseReleased(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code = this.getTerminalState().getMouseFormat() == MouseFormat.MOUSE_FORMAT_SGR ? code | 0x80 : 3;
            code = this.applyModifierKeys(event, code);
            this.terminalInput.sendBytes(this.mouseReport(code, x + 1, y + 1));
        }
        this.lastMotionReport = null;
    }

    @Override
    public void mouseMoved(int x, int y, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_ALL_MOTION};
        if (this.shouldSendMouseData(mouseModeArray)) {
            this.terminalInput.sendBytes(this.mouseReport(3, x + 1, y + 1));
        }
        this.lastMotionReport = new Point(x, y);
    }

    @Override
    public void mouseDragged(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code |= 0x20;
            code = this.applyModifierKeys(event, code);
            this.terminalInput.sendBytes(this.mouseReport(code, x + 1, y + 1));
        }
        this.lastMotionReport = new Point(x, y);
    }

    @Override
    public void mouseWheelMoved(int x, int y, @NotNull MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.settings.enableMouseReporting() && this.getTerminalState().getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !event.isShiftDown()) {
            this.editor.getSelectionModel().removeSelection();
            this.mousePressed(x, y, event);
        } else if (this.getTerminalState().isAlternateScreenBuffer() && this.settings.simulateMouseScrollWithArrowKeysInAlternativeScreen() && !event.isShiftDown()) {
            byte[] arrowKeys;
            byte[] byArray = event.getWheelRotation() < 0 ? this.encodingManager.getCode(38, 0) : (arrowKeys = event.getWheelRotation() > 0 ? this.encodingManager.getCode(40, 0) : null);
            if (arrowKeys != null) {
                int n = Math.abs(event.getUnitsToScroll());
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    this.terminalInput.sendBytes(arrowKeys);
                }
                event.consume();
            }
        }
    }

    private final boolean shouldSendMouseData(MouseMode ... eligibleModes) {
        MouseMode mode = this.getTerminalState().getMouseMode();
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> ArraysKt.contains((Object[])eligibleModes, (Object)mode);
        };
    }

    private final int createButtonCode(MouseEvent event) {
        int n;
        if (SwingUtilities.isLeftMouseButton(event)) {
            n = 0;
        } else if (SwingUtilities.isMiddleMouseButton(event)) {
            n = 1;
        } else if (SwingUtilities.isRightMouseButton(event)) {
            n = -1;
        } else if (event instanceof MouseWheelEvent) {
            n = this.wheelRotationToButtonCode(((MouseWheelEvent)event).getWheelRotation());
        } else {
            return -1;
        }
        return n;
    }

    private final int wheelRotationToButtonCode(int wheelRotation) {
        return wheelRotation > 0 ? 5 : (wheelRotation < 0 ? 4 : -1);
    }

    private final int applyModifierKeys(MouseEvent event, int cb) {
        int code = cb;
        if (event.isControlDown()) {
            code |= 0x10;
        }
        if (event.isShiftDown()) {
            code |= 4;
        }
        if ((event.getModifiersEx() & 4) != 0) {
            code |= 8;
        }
        return code;
    }

    private final byte[] mouseReport(int button2, int x, int y) {
        String string;
        String charset = "UTF-8";
        MouseFormat mouseFormat = this.getTerminalState().getMouseFormat();
        switch (WhenMappings.$EnumSwitchMapping$1[mouseFormat.ordinal()]) {
            case 1: {
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button2)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                break;
            }
            case 2: {
                String string2 = "\u001b[%d;%d;%dM";
                Object[] objectArray = new Object[]{32 + button2, x, y};
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                break;
            }
            case 3: {
                Object[] objectArray;
                String string2;
                if ((button2 & 0x80) != 0) {
                    string2 = "\u001b[<%d;%d;%dm";
                    objectArray = new Object[]{button2 ^ 0x80, x, y};
                    String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                    break;
                }
                string2 = "\u001b[<%d;%d;%dM";
                objectArray = new Object[]{button2, x, y};
                String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                break;
            }
            default: {
                charset = "ISO-8859-1";
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button2)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
            }
        }
        String command2 = string;
        LOG.debug(mouseFormat + " (" + charset + ") report : " + button2 + ", " + x + "x" + y + " = " + command2);
        String string8 = command2;
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
        byte[] byArray = string8.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    private final void syncEditorCaretWithModel() {
        int expectedCaretOffset = TerminalViewImplKt.toRelative(this.outputModel.getCursorOffset(), this.outputModel);
        Function0 moveCaretAction = () -> TerminalEventsHandlerImpl.syncEditorCaretWithModel$lambda$0(this, expectedCaretOffset);
        if (this.editor.getCaretModel().getOffset() != expectedCaretOffset) {
            LookupEx lookup = LookupManager.getActiveLookup((Editor)((Editor)this.editor));
            if (lookup != null) {
                lookup.performGuardedChange(() -> TerminalEventsHandlerImpl.syncEditorCaretWithModel$lambda$1(moveCaretAction));
            } else {
                moveCaretAction.invoke();
            }
        }
    }

    private final void scheduleCompletionPopupIfNeeded(char charTyped) {
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = this.startupOptionsDeferred;
        if (object == null || (object = TerminalCoroutineKt.getNow(object)) == null || (object = TerminalStartupOptionsKt.guessShellName(object)) == null) {
            return;
        }
        Object shellName = object;
        Object object2 = this.shellIntegrationDeferred;
        if (object2 == null || (object2 = TerminalCoroutineKt.getNow(object2)) == null) {
            return;
        }
        Object shellIntegration = object2;
        if (TerminalDataContextUtils.INSTANCE.isOutputModelEditor((Editor)this.editor) && TerminalCommandCompletion.INSTANCE.isEnabled(project2) && TerminalCommandCompletion.INSTANCE.isSupportedForShell((ShellName)shellName) && TerminalOptionsProvider.Companion.getInstance().getShowCompletionPopupAutomatically() && Intrinsics.areEqual((Object)shellIntegration.getOutputStatus().getValue(), (Object)TerminalOutputStatus.TypingCommand.INSTANCE) && this.canTriggerCompletion(charTyped) && LookupManager.getActiveLookup((Editor)((Editor)this.editor)) == null && StringsKt.isBlank((CharSequence)this.getTextAfterCursor(this.outputModel))) {
            TerminalCommandCompletionService.Companion.getInstance(project2).invokeCompletion((Editor)this.editor, this.outputModel, (TerminalShellIntegration)shellIntegration, true);
        }
    }

    private final boolean canTriggerCompletion(char c) {
        return Character.isLetterOrDigit(c);
    }

    private final CharSequence getTextAfterCursor(TerminalOutputModel $this$getTextAfterCursor) {
        return $this$getTextAfterCursor.getText($this$getTextAfterCursor.getCursorOffset(), $this$getTextAfterCursor.getEndOffset());
    }

    private static final Unit syncEditorCaretWithModel$lambda$0(TerminalEventsHandlerImpl this$0, int $expectedCaretOffset) {
        this$0.editor.getCaretModel().moveToOffset($expectedCaretOffset);
        return Unit.INSTANCE;
    }

    private static final void syncEditorCaretWithModel$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    static {
        Logger logger = Logger.getInstance(TerminalEventsHandlerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandlerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MouseMode.values().length];
            try {
                nArray[MouseMode.MOUSE_REPORTING_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseMode.MOUSE_REPORTING_ALL_MOTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MouseFormat.values().length];
            try {
                nArray[MouseFormat.MOUSE_FORMAT_XTERM_EXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_URXVT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_SGR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

