/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.impl.livePreview.LivePreview;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.LivePreviewPresentation;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.terminal.frontend.view.impl.DataContextWrapper;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u000245B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020\fH\u0002J\b\u0010%\u001a\u00020\fH\u0002J\b\u0010&\u001a\u00020\fH\u0002J\r\u0010'\u001a\u00070(\u00a2\u0006\u0002\b)H\u0002J\u0017\u0010*\u001a\t\u0018\u00010(\u00a2\u0006\u0002\b)2\u0006\u0010+\u001a\u00020(H\u0002J\u0006\u0010,\u001a\u00020\fJ\b\u0010-\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\u0013H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\fH\u0016J\b\u00102\u001a\u00020\fH\u0016J\b\u00103\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchResultsListener;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "model", "Lcom/intellij/find/FindModel;", "closeCallback", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/find/FindModel;Lkotlin/jvm/functions/Function0;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "component", "Lcom/intellij/find/SearchReplaceComponent;", "wrapper", "Ljavax/swing/JComponent;", "getWrapper", "()Ljavax/swing/JComponent;", "searchResults", "Lcom/intellij/find/impl/livePreview/SearchResults;", "livePreviewController", "Lcom/intellij/find/impl/livePreview/LivePreviewController;", "createSearchComponent", "wrappSearchComponent", "findModelChanged", "searchFieldDocumentChanged", "searchResultsUpdated", "sr", "cursorMoved", "updateResults", "updateMultiLineStateIfNeeded", "updateUiWithFindModel", "updateEmptyText", "getEmptyText", "", "Lorg/jetbrains/annotations/Nls;", "checkRegex", "text", "activate", "getFindModel", "getComponent", "hasMatches", "", "searchForward", "searchBackward", "close", "TerminalSearchPresentation", "TerminalSearchResults", "intellij.terminal.frontend"})
public final class TerminalSearchSession
implements SearchSession,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final FindModel model;
    @NotNull
    private final Function0<Unit> closeCallback;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final SearchReplaceComponent component;
    @NotNull
    private final JComponent wrapper;
    @NotNull
    private final SearchResults searchResults;
    @NotNull
    private final LivePreviewController livePreviewController;

    public TerminalSearchSession(@NotNull Project project, @NotNull Editor editor, @NotNull FindModel model, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        this.project = project;
        this.editor = editor;
        this.model = model;
        this.closeCallback = closeCallback;
        Disposable disposable = Disposer.newDisposable((String)TerminalSearchSession.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.component = this.createSearchComponent();
        this.wrapper = (JComponent)((Object)new DataContextWrapper(this.wrappSearchComponent()));
        this.searchResults = new TerminalSearchResults();
        this.livePreviewController = new LivePreviewController(this.searchResults, (SearchSession)this, this.disposable);
        this.searchResults.setMatchesLimit(10000);
        this.livePreviewController.on();
        this.livePreviewController.setLivePreview(new LivePreview(this.searchResults, (LivePreviewPresentation)new TerminalSearchPresentation(this.editor)));
        this.component.addListener((SearchReplaceComponent.Listener)this);
        this.searchResults.addListener((SearchResults.SearchResultsListener)this);
        this.model.addObserver(new FindModel.FindModelObserver(){
            private boolean preventRecursion;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void findModelChanged(FindModel findModel) {
                Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
                if (!this.preventRecursion) {
                    try {
                        this.preventRecursion = true;
                        this.findModelChanged();
                    }
                    finally {
                        this.preventRecursion = false;
                    }
                }
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getEditor() == editor) {
                    Disposer.dispose((Disposable)disposable);
                    livePreviewController.dispose();
                }
            }
        }, this.disposable);
        Object[] objectArray = new Object[]{0, 0};
        this.component.setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
        this.updateUiWithFindModel();
        this.updateMultiLineStateIfNeeded();
        ActionsKt.invokeLater$default(null, () -> TerminalSearchSession._init_$lambda$0(this), (int)1, null);
    }

    @NotNull
    public final JComponent getWrapper() {
        return this.wrapper;
    }

    private final SearchReplaceComponent createSearchComponent() {
        AnAction[] anActionArray = new SearchReplaceComponent[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.editor.getContentComponent(), (SearchSession)this).addPrimarySearchActions(anActionArray);
        anActionArray = new AnAction[]{new ToggleMatchCase(), new ToggleRegex()};
        AnAction[] it = anActionArray = builder.addExtraSearchActions(anActionArray).withNewLineButton(false).withCloseAction(this::close).build();
        boolean bl = false;
        JTextComponent jTextComponent = it.getSearchTextComponent();
        JTextArea jTextArea = jTextComponent instanceof JTextArea ? (JTextArea)jTextComponent : null;
        if (jTextArea != null) {
            jTextArea.setColumns(14);
        }
        it.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)0, (int)1, (int)1, (int)0));
        AnAction[] anActionArray2 = anActionArray;
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray2, (String)"also(...)");
        return anActionArray2;
    }

    private final JComponent wrappSearchComponent() {
        Object object = InternalUICustomization.Companion.getInstance();
        if (object == null || (object = object.configureTerminalSearchReplaceComponent((EditorHeaderComponent)this.component)) == null) {
            object = (JComponent)this.component;
        }
        return object;
    }

    private final void findModelChanged() {
        FindModel findModel;
        this.updateUiWithFindModel();
        this.searchResults.clear();
        this.updateResults();
        FindModel $this$findModelChanged_u24lambda_u240 = findModel = FindManager.getInstance((Project)this.project).getFindInFileModel();
        boolean bl = false;
        $this$findModelChanged_u24lambda_u240.setStringToFind(this.model.getStringToFind());
        $this$findModelChanged_u24lambda_u240.setCaseSensitive(this.model.isCaseSensitive());
        $this$findModelChanged_u24lambda_u240.setRegularExpressions(this.model.isRegularExpressions());
    }

    public void searchFieldDocumentChanged() {
        if (this.editor.isDisposed()) {
            return;
        }
        String string = this.component.getSearchTextComponent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.model.setStringToFind(string);
        this.updateResults();
        this.updateMultiLineStateIfNeeded();
    }

    public void searchResultsUpdated(@NotNull SearchResults sr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sr, (String)"sr");
        if (sr.getFindModel() == null) {
            return;
        }
        int matchesCount = sr.getMatchesCount();
        int cursorIndex = sr.getCursorVisualIndex();
        if (matchesCount > this.searchResults.getMatchesLimit()) {
            var6_4 = new Object[]{this.searchResults.getMatchesLimit()};
            string = ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])var6_4);
        } else if (cursorIndex != -1) {
            var6_4 = new Object[]{cursorIndex, matchesCount};
            string = ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var6_4);
        } else {
            var6_4 = new Object[]{0, matchesCount};
            string = ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var6_4);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String status = string2;
        if (matchesCount == 0) {
            this.component.setNotFoundBackground();
        } else {
            this.component.setRegularBackground();
        }
        this.component.setStatusText(status);
        this.component.updateActions();
    }

    public void cursorMoved() {
        this.component.updateActions();
    }

    private final void updateResults() {
        String text = this.model.getStringToFind();
        if (((CharSequence)text).length() > 0) {
            String string;
            if (this.model.isRegularExpressions() && (string = this.checkRegex(text)) != null) {
                String warning = string;
                boolean bl = false;
                this.searchResults.clear();
                this.component.setStatusText(warning);
                return;
            }
            this.livePreviewController.updateInBackground(this.model, true);
        } else {
            Object[] objectArray = new Object[]{0, 0};
            this.component.setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
            this.searchResults.clear();
        }
    }

    private final void updateMultiLineStateIfNeeded() {
        String string = this.component.getSearchTextComponent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.model.setMultiline(StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null));
    }

    private final void updateUiWithFindModel() {
        this.component.update(this.model.getStringToFind(), this.model.getStringToReplace(), this.model.isReplaceState(), this.model.isMultiline());
        this.updateEmptyText();
    }

    private final void updateEmptyText() {
        JTextComponent jTextComponent = this.component.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        JTextComponent searchComponent = jTextComponent;
        if (searchComponent instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)searchComponent).getEmptyText().setText(this.getEmptyText());
        }
    }

    private final String getEmptyText() {
        List options = (List)new SmartList();
        if (this.model.isCaseSensitive()) {
            String string = TerminalSearchSession.getEmptyText$getOptionText("find.case.sensitive");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmptyText$getOptionText(...)");
            options.add(string);
        }
        if (this.model.isRegularExpressions()) {
            String string = TerminalSearchSession.getEmptyText$getOptionText("find.regex");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmptyText$getOptionText(...)");
            options.add(string);
        }
        String string = switch (options.size()) {
            case 0 -> ApplicationBundle.message((String)"editorsearch.search.hint", (Object[])new Object[0]);
            case 1 -> {
                Object[] var4_2 = new Object[]{options.get(0)};
                yield FindBundle.message((String)"emptyText.used.option", (Object[])var4_2);
            }
            default -> {
                Object[] var4_2 = new Object[]{options.get(0), options.get(1)};
                yield FindBundle.message((String)"emptyText.used.options", (Object[])var4_2);
            }
        };
        Intrinsics.checkNotNull((Object)string);
        String text = string;
        String string2 = StringUtil.capitalize((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
        return string2;
    }

    private final String checkRegex(String text) {
        try {
            new Regex(text);
        }
        catch (PatternSyntaxException e) {
            return FindBundle.message((String)"find.incorrect.regexp", (Object[])new Object[0]);
        }
        CharSequence charSequence = text;
        return new Regex("\\|+").matches(charSequence) ? ApplicationBundle.message((String)"editorsearch.empty.string.matches", (Object[])new Object[0]) : null;
    }

    public final void activate() {
        this.component.requestFocusInTheSearchFieldAndSelectContent(this.project);
        FindUtil.configureFindModel((boolean)false, (Editor)this.editor, (FindModel)this.getFindModel(), (boolean)false);
        this.getFindModel().setGlobal(false);
    }

    @NotNull
    public FindModel getFindModel() {
        return this.model;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.component;
    }

    public boolean hasMatches() {
        return this.searchResults.hasMatches();
    }

    public void searchForward() {
        this.livePreviewController.moveCursor(SearchResults.Direction.DOWN);
    }

    public void searchBackward() {
        this.livePreviewController.moveCursor(SearchResults.Direction.UP);
    }

    public void close() {
        Disposer.dispose((Disposable)this.disposable);
        this.livePreviewController.dispose();
        this.closeCallback.invoke();
        if (this.editor.getContentComponent().isShowing()) {
            this.editor.getContentComponent().requestFocusInWindow();
        }
    }

    private static final Unit _init_$lambda$0(TerminalSearchSession this$0) {
        this$0.component.updateActions();
        return Unit.INSTANCE;
    }

    private static final String getEmptyText$getOptionText(String key) {
        String string = FindBundle.message((String)key, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return StringUtil.toLowerCase((String)StringsKt.replace$default((String)string, (String)"\u001b", (String)"", (boolean)false, (int)4, null));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalSearchSession$TerminalSearchPresentation;", "Lcom/intellij/find/impl/livePreview/LivePreviewPresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "defaultAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getDefaultAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "cursorAttributes", "getCursorAttributes", "defaultLayer", "", "getDefaultLayer", "()I", "cursorLayer", "getCursorLayer", "intellij.terminal.frontend"})
    private static final class TerminalSearchPresentation
    implements LivePreviewPresentation {
        @NotNull
        private final Editor editor;
        private final int defaultLayer;
        private final int cursorLayer;

        public TerminalSearchPresentation(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.defaultLayer = 6001;
            this.cursorLayer = 6002;
        }

        @NotNull
        public TextAttributes getDefaultAttributes() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(BlockTerminalColors.SEARCH_ENTRY);
            if (textAttributes == null) {
                textAttributes = new TextAttributes();
            }
            return textAttributes;
        }

        @NotNull
        public TextAttributes getCursorAttributes() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(BlockTerminalColors.CURRENT_SEARCH_ENTRY);
            if (textAttributes == null) {
                textAttributes = new TextAttributes();
            }
            return textAttributes;
        }

        public int getDefaultLayer() {
            return this.defaultLayer;
        }

        public int getCursorLayer() {
            return this.cursorLayer;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalSearchSession$TerminalSearchResults;", "Lcom/intellij/find/impl/livePreview/SearchResults;", "<init>", "(Lcom/intellij/terminal/frontend/view/impl/TerminalSearchSession;)V", "getLocalSearchArea", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchArea;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findModel", "Lcom/intellij/find/FindModel;", "firstOccurrenceAtOrAfterCaret", "Lcom/intellij/find/FindResult;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSearchSession.kt\ncom/intellij/terminal/frontend/view/impl/TerminalSearchSession$TerminalSearchResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,294:1\n363#2,7:295\n*S KotlinDebug\n*F\n+ 1 TerminalSearchSession.kt\ncom/intellij/terminal/frontend/view/impl/TerminalSearchSession$TerminalSearchResults\n*L\n272#1:295,7\n*E\n"})
    private final class TerminalSearchResults
    extends SearchResults {
        public TerminalSearchResults() {
            super(TerminalSearchSession.this.editor, TerminalSearchSession.this.project);
        }

        @NotNull
        protected SearchResults.SearchArea getLocalSearchArea(@NotNull Editor editor, @NotNull FindModel findModel) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
            int[] nArray = new int[]{0};
            int[] nArray2 = nArray;
            nArray = new int[]{Integer.MAX_VALUE};
            SearchResults.SearchArea searchArea = SearchResults.SearchArea.create((int[])nArray2, (int[])nArray);
            Intrinsics.checkNotNullExpressionValue((Object)searchArea, (String)"create(...)");
            return searchArea;
        }

        @Nullable
        protected FindResult firstOccurrenceAtOrAfterCaret() {
            FindResult findResult;
            int index;
            block4: {
                int n;
                int topY = this.getEditor().getScrollingModel().getVisibleArea().y + 3 * this.getEditor().getLineHeight();
                LogicalPosition logicalPosition = this.getEditor().xyToLogicalPosition(new Point(0, topY));
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                LogicalPosition topLogicalPosition = logicalPosition;
                int topOffset = this.getEditor().logicalPositionToOffset(topLogicalPosition);
                List list = this.getOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOccurrences(...)");
                List $this$indexOfFirst$iv = list;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FindResult it = (FindResult)item$iv;
                    boolean bl = false;
                    if (it.getStartOffset() >= topOffset) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index > 0) {
                findResult = (FindResult)this.getOccurrences().get(index);
            } else {
                List list = this.getOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOccurrences(...)");
                findResult = (FindResult)CollectionsKt.lastOrNull((List)list);
            }
            return findResult;
        }
    }
}

