/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.frontend.view.impl.TerminalOutputModelController;
import com.intellij.terminal.frontend.view.impl.TerminalTypeAhead;
import com.intellij.terminal.frontend.view.impl.TerminalTypeAheadOutputModelControllerKt;
import com.jediterm.terminal.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.session.impl.TerminalContentUpdatedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalCursorPositionChangedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalOutputEvent;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.impl.MutableTerminalOutputModel;
import org.jetbrains.plugins.terminal.view.impl.MutableTerminalOutputModelKt;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockBase;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalOutputStatus;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020\u0013H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180'H\u0002J\u0016\u0010)\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180'H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController;", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputModelController;", "Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAhead;", "project", "Lcom/intellij/openapi/project/Project;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModel;", "shellIntegrationDeferred", "Lkotlinx/coroutines/Deferred;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModel;Lkotlinx/coroutines/Deferred;Lkotlinx/coroutines/CoroutineScope;)V", "model", "getModel", "()Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModel;", "delayedUpdateRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "backendEventsDelayed", "", "delayedEvents", "", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalOutputEvent;", "isTypeAheadEnabled", "type", "string", "", "backspace", "updateContent", "event", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalContentUpdatedEvent;", "updateCursorPosition", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalCursorPositionChangedEvent;", "applyPendingUpdates", "handleBackendEvent", "delayUpdatesFromBackend", "mergeOutputEvents", "", "events", "doApplyDelayedEvents", "applyOutputEvent", "updateOutputModel", "update", "Ljava/lang/Runnable;", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalTypeAheadOutputModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTypeAheadOutputModelController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n67#2,4:284\n67#2,4:288\n13#2:310\n546#3,6:292\n812#3,12:298\n*S KotlinDebug\n*F\n+ 1 TerminalTypeAheadOutputModelController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController\n*L\n84#1:284,4\n104#1:288,4\n209#1:310\n153#1:292,6\n155#1:298,12\n*E\n"})
public final class TerminalTypeAheadOutputModelController
implements TerminalOutputModelController,
TerminalTypeAhead {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableTerminalOutputModel outputModel;
    @NotNull
    private final Deferred<TerminalShellIntegration> shellIntegrationDeferred;
    @NotNull
    private final MutableTerminalOutputModel model;
    @NotNull
    private final MutableSharedFlow<Unit> delayedUpdateRequests;
    private boolean backendEventsDelayed;
    @NotNull
    private List<TerminalOutputEvent> delayedEvents;
    @NotNull
    private static final Logger LOG;
    private static final long BACKEND_EVENTS_DELAY_MILLIS;

    public TerminalTypeAheadOutputModelController(@NotNull Project project, @NotNull MutableTerminalOutputModel outputModel, @NotNull Deferred<? extends TerminalShellIntegration> shellIntegrationDeferred, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter(shellIntegrationDeferred, (String)"shellIntegrationDeferred");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.outputModel = outputModel;
        this.shellIntegrationDeferred = shellIntegrationDeferred;
        this.model = this.outputModel;
        this.delayedUpdateRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.delayedEvents = new ArrayList();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalTypeAheadOutputModelController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.debounce((Flow)((Flow)this.this$0.delayedUpdateRequests), (long)BACKEND_EVENTS_DELAY_MILLIS).collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this$0.applyPendingUpdates();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public MutableTerminalOutputModel getModel() {
        return this.model;
    }

    private final boolean isTypeAheadEnabled() {
        if (!Registry.Companion.is("terminal.type.ahead", false)) {
            return false;
        }
        TerminalShellIntegration terminalShellIntegration = TerminalCoroutineKt.getNow(this.shellIntegrationDeferred);
        if (terminalShellIntegration == null) {
            return false;
        }
        TerminalShellIntegration shellIntegration = terminalShellIntegration;
        TerminalBlockBase terminalBlockBase = shellIntegration.getBlocksModel().getActiveBlock();
        TerminalCommandBlock terminalCommandBlock = terminalBlockBase instanceof TerminalCommandBlock ? (TerminalCommandBlock)terminalBlockBase : null;
        if (terminalCommandBlock == null) {
            return false;
        }
        TerminalCommandBlock activeBlock = terminalCommandBlock;
        boolean isActiveBlockValid = activeBlock.getCommandStartOffset() != null && activeBlock.getOutputStartOffset() == null;
        return Intrinsics.areEqual((Object)shellIntegration.getOutputStatus().getValue(), (Object)TerminalOutputStatus.TypingCommand.INSTANCE) && isActiveBlockValid;
    }

    @Override
    public void type(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!this.isTypeAheadEnabled()) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)TerminalTypeAheadOutputModelControllerKt.access$getTextAfterCursor(this.outputModel))) {
            TextStyle textStyle = TerminalTypeAheadOutputModelControllerKt.access$predictTextStyleForTypingAt(this.outputModel, this.outputModel.getCursorOffset());
            this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.type$lambda$0(this, string, textStyle));
            this.delayUpdatesFromBackend();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("String typed prediction inserted: '" + string + "'");
            }
        }
    }

    @Override
    public void backspace() {
        TerminalOffset commandStartOffset;
        if (!this.isTypeAheadEnabled()) {
            return;
        }
        TerminalShellIntegration shellIntegration = (TerminalShellIntegration)this.shellIntegrationDeferred.getCompleted();
        TerminalBlockBase terminalBlockBase = shellIntegration.getBlocksModel().getActiveBlock();
        TerminalCommandBlock commandBlock = terminalBlockBase instanceof TerminalCommandBlock ? (TerminalCommandBlock)terminalBlockBase : null;
        TerminalOffset cursorOffset = this.outputModel.getCursorOffset();
        TerminalCommandBlock terminalCommandBlock = commandBlock;
        TerminalOffset terminalOffset = commandStartOffset = terminalCommandBlock != null ? terminalCommandBlock.getCommandStartOffset() : null;
        if (commandBlock == null || commandStartOffset != null && cursorOffset.compareTo(commandStartOffset) <= 0 || Intrinsics.areEqual((Object)cursorOffset, (Object)this.outputModel.getStartOffset())) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)TerminalTypeAheadOutputModelControllerKt.access$getTextAfterCursor(this.outputModel))) {
            this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.backspace$lambda$0(this));
            this.delayUpdatesFromBackend();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Backspace prediction applied");
            }
        }
    }

    @Override
    public void updateContent(@NotNull TerminalContentUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.handleBackendEvent(event);
    }

    @Override
    public void updateCursorPosition(@NotNull TerminalCursorPositionChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.handleBackendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyPendingUpdates() {
        if (!this.backendEventsDelayed) {
            return;
        }
        try {
            List<TerminalOutputEvent> merged = this.mergeOutputEvents(this.delayedEvents);
            this.doApplyDelayedEvents(merged);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error applying delayed events", (Throwable)e);
        }
        finally {
            this.delayedEvents.clear();
            this.backendEventsDelayed = false;
        }
    }

    private final void handleBackendEvent(TerminalOutputEvent event) {
        if (this.backendEventsDelayed) {
            this.delayedEvents.add(event);
        } else {
            this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.handleBackendEvent$lambda$0(this, event));
        }
    }

    private final void delayUpdatesFromBackend() {
        this.backendEventsDelayed = true;
        if (!this.delayedUpdateRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TerminalOutputEvent> mergeOutputEvents(List<? extends TerminalOutputEvent> events) {
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        Object element$iv;
        block5: {
            List<? extends TerminalOutputEvent> $this$lastOrNull$iv = events;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends TerminalOutputEvent> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                TerminalOutputEvent it = element$iv;
                boolean bl = false;
                if (!(it instanceof TerminalCursorPositionChangedEvent)) continue;
                object = element$iv;
                break block5;
            }
            object = null;
        }
        TerminalOutputEvent lastCursorUpdate = (TerminalOutputEvent)object;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        element$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TerminalContentUpdatedEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contentEvents = (List)destination$iv$iv;
        if (contentEvents.isEmpty()) {
            return CollectionsKt.listOfNotNull((Object)lastCursorUpdate);
        }
        List result2 = new ArrayList();
        int curIndex = 0;
        while (curIndex < contentEvents.size()) {
            long curLine = ((TerminalContentUpdatedEvent)contentEvents.get(curIndex)).getStartLineLogicalIndex();
            while (curIndex < contentEvents.size() && ((TerminalContentUpdatedEvent)contentEvents.get(curIndex)).getStartLineLogicalIndex() == curLine) {
                ++curIndex;
            }
            result2.add(contentEvents.get(curIndex - 1));
        }
        return lastCursorUpdate != null ? CollectionsKt.plus((Collection)result2, (Object)lastCursorUpdate) : result2;
    }

    private final void doApplyDelayedEvents(List<? extends TerminalOutputEvent> events) {
        this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.doApplyDelayedEvents$lambda$0(events, this));
    }

    private final void applyOutputEvent(TerminalOutputEvent event) {
        TerminalOutputEvent terminalOutputEvent = event;
        if (terminalOutputEvent instanceof TerminalContentUpdatedEvent) {
            MutableTerminalOutputModelKt.updateContent(this.outputModel, (TerminalContentUpdatedEvent)event);
        } else if (terminalOutputEvent instanceof TerminalCursorPositionChangedEvent) {
            this.outputModel.updateCursorPosition(((TerminalCursorPositionChangedEvent)event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)event).getColumnIndex());
        } else {
            throw new IllegalStateException(("Unexpected event type: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName()).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateOutputModel(Runnable update) {
        LookupEx lookup = LookupManager.getInstance((Project)this.project).getActiveLookup();
        if (lookup != null) {
            Editor editor = lookup.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor)) {
                lookup.performGuardedChange(update);
                return;
            }
        }
        update.run();
    }

    private static final void type$lambda$0(TerminalTypeAheadOutputModelController this$0, String $string, TextStyle $textStyle) {
        TerminalTypeAheadOutputModelControllerKt.access$insertAtCursor(this$0.outputModel, $string, $textStyle);
    }

    private static final void backspace$lambda$0(TerminalTypeAheadOutputModelController this$0) {
        TerminalTypeAheadOutputModelControllerKt.access$backspace(this$0.outputModel);
    }

    private static final void handleBackendEvent$lambda$0(TerminalTypeAheadOutputModelController this$0, TerminalOutputEvent $event) {
        this$0.applyOutputEvent($event);
    }

    private static final void doApplyDelayedEvents$lambda$0(List $events, TerminalTypeAheadOutputModelController this$0) {
        for (TerminalOutputEvent event : $events) {
            this$0.applyOutputEvent(event);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalTypeAheadOutputModelController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        BACKEND_EVENTS_DELAY_MILLIS = AppModeAssertions.isMonolith() ? 100L : 500L;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "BACKEND_EVENTS_DELAY_MILLIS", "", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

