/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.ui.UISettingsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.util.TerminalSettingsFloatValueImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH&J\u0006\u0010\u000e\u001a\u00020\u0000R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0001\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "", "<init>", "()V", "floatValue", "", "getFloatValue", "()F", "intValue", "", "getIntValue", "()I", "toFormattedString", "", "scale", "Companion", "TerminalFontSizeImpl", "Lorg/jetbrains/plugins/terminal/TerminalFontSize$TerminalFontSizeImpl;", "intellij.terminal"})
public abstract sealed class TerminalFontSize {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private TerminalFontSize() {
    }

    public abstract float getFloatValue();

    public abstract int getIntValue();

    @NotNull
    public abstract String toFormattedString();

    @NotNull
    public final TerminalFontSize scale() {
        return Companion.ofFloat(UISettingsUtils.Companion.getInstance().scaleFontSize(this.getFloatValue()));
    }

    public /* synthetic */ TerminalFontSize(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSize$Companion;", "", "<init>", "()V", "validRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "getValidRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "ofFloat", "Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "value", "parse", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        private final ClosedFloatingPointRange<Float> getValidRange() {
            return RangesKt.rangeTo((float)EditorFontsConstants.getMinEditorFontSize(), (float)EditorFontsConstants.getMaxEditorFontSize());
        }

        @NotNull
        public final TerminalFontSize ofFloat(float value) {
            return new TerminalFontSizeImpl(TerminalSettingsFloatValueImpl.Companion.ofFloat(value, 1).coerceIn(this.getValidRange()));
        }

        @NotNull
        public final TerminalFontSize parse(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new TerminalFontSizeImpl(TerminalSettingsFloatValueImpl.Companion.parse(value, EditorFontsConstants.getDefaultEditorFontSize(), 1).coerceIn(this.getValidRange()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u000bH\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u000fH\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSize$TerminalFontSizeImpl;", "Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "impl", "Lorg/jetbrains/plugins/terminal/util/TerminalSettingsFloatValueImpl;", "<init>", "(Lorg/jetbrains/plugins/terminal/util/TerminalSettingsFloatValueImpl;)V", "floatValue", "", "getFloatValue", "()F", "intValue", "", "getIntValue", "()I", "toFormattedString", "", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.terminal"})
    private static final class TerminalFontSizeImpl
    extends TerminalFontSize {
        @NotNull
        private final TerminalSettingsFloatValueImpl impl;

        public TerminalFontSizeImpl(@NotNull TerminalSettingsFloatValueImpl impl) {
            Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
            super(null);
            this.impl = impl;
        }

        @Override
        public float getFloatValue() {
            return this.impl.toFloat();
        }

        @Override
        public int getIntValue() {
            return MathKt.roundToInt((float)this.getFloatValue());
        }

        @Override
        @NotNull
        public String toFormattedString() {
            return this.impl.toFormattedString();
        }

        private final TerminalSettingsFloatValueImpl component1() {
            return this.impl;
        }

        @NotNull
        public final TerminalFontSizeImpl copy(@NotNull TerminalSettingsFloatValueImpl impl) {
            Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
            return new TerminalFontSizeImpl(impl);
        }

        public static /* synthetic */ TerminalFontSizeImpl copy$default(TerminalFontSizeImpl terminalFontSizeImpl, TerminalSettingsFloatValueImpl terminalSettingsFloatValueImpl, int n, Object object) {
            if ((n & 1) != 0) {
                terminalSettingsFloatValueImpl = terminalFontSizeImpl.impl;
            }
            return terminalFontSizeImpl.copy(terminalSettingsFloatValueImpl);
        }

        @NotNull
        public String toString() {
            return "TerminalFontSizeImpl(impl=" + this.impl + ")";
        }

        public int hashCode() {
            return this.impl.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminalFontSizeImpl)) {
                return false;
            }
            TerminalFontSizeImpl terminalFontSizeImpl = (TerminalFontSizeImpl)other;
            return Intrinsics.areEqual((Object)this.impl, (Object)terminalFontSizeImpl.impl);
        }
    }
}

