/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.ImageBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.ui.RoundedIcon;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.block.completion.feedback.TerminalUsageData;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u0002H\u0094@\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/feedback/TerminalCompletionFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lorg/jetbrains/plugins/terminal/block/completion/feedback/TerminalUsageData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myFeedbackReportId", "", "getMyFeedbackReportId", "()Ljava/lang/String;", "myTitle", "getMyTitle", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "imageBlock", "Lcom/intellij/platform/feedback/dialog/uiBlocks/ImageBlock;", "computeSystemInfoData", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showFeedbackSystemInfoDialog", "", "systemInfoData", "intellij.terminal"})
public final class TerminalCompletionFeedbackDialog
extends BlockBasedFeedbackDialog<TerminalUsageData> {
    @NotNull
    private final Project project;
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public TerminalCompletionFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        this.project = project;
        this.myFeedbackReportId = "terminal_command_completion";
        String string = TerminalBundle.message("feedback.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myTitle = string;
        Object[] objectArray = new FeedbackBlock[5];
        String string2 = TerminalBundle.message("completion.feedback.dialog.header", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[0] = new TopLabelBlock(string2);
        String string3 = TerminalBundle.message("completion.feedback.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[1] = new DescriptionBlock(string3);
        objectArray[2] = this.imageBlock();
        String string4 = TerminalBundle.message("completion.feedback.dialog.rating", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[3] = new RatingBlock(string4, "rating").doNotRequireAnswer();
        String string5 = TerminalBundle.message("completion.feedback.dialog.experience.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        TextAreaBlock textAreaBlock = new TextAreaBlock(string5, "feedback");
        String string6 = TerminalBundle.message("completion.feedback.dialog.experience.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        objectArray[4] = textAreaBlock.setPlaceholder(string6);
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    private final ImageBlock imageBlock() {
        ClassLoader classLoader = TerminalCompletionFeedbackDialog.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        Icon icon = IconLoader.getIcon((String)"icons/completion_illustration.png", (ClassLoader)classLoader);
        int arc = JBUIScale.scale((int)16);
        double arcRatio = (double)arc / (double)Math.min(icon.getIconWidth(), icon.getIconHeight());
        RoundedIcon roundedIcon = new RoundedIcon(icon, arcRatio);
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"separatorForeground(...)");
        Color borderColor = color;
        RoundedLineBorder border = new RoundedLineBorder(borderColor, arc, 0, 4, null);
        return new ImageBlock((Icon)roundedIcon).withBorder((Border)border);
    }

    @Nullable
    protected Object computeSystemInfoData(@NotNull Continuation<? super TerminalUsageData> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TerminalUsageData>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalCompletionFeedbackDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return new TerminalUsageData(TerminalShellInfoStatistics.INSTANCE.getShellNameForStat(TerminalProjectOptionsProvider.Companion.getInstance(TerminalCompletionFeedbackDialog.access$getProject$p(this.this$0)).getShellPath()), CommonFeedbackSystemData.Companion.getCurrentData());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super TerminalUsageData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    protected void showFeedbackSystemInfoDialog(@NotNull TerminalUsageData systemInfoData) {
        Intrinsics.checkNotNullParameter((Object)systemInfoData, (String)"systemInfoData");
        BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)this.project, (CommonFeedbackSystemData)systemInfoData.getSystemInfo(), arg_0 -> TerminalCompletionFeedbackDialog.showFeedbackSystemInfoDialog$lambda$0(systemInfoData, arg_0));
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$0(TerminalUsageData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($systemInfoData.getSelectedShell());
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0(TerminalUsageData $systemInfoData, Panel $this$showFeedbackSystemInfoDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
        String string = TerminalBundle.message("feedback.system.info.shell", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string, arg_0 -> TerminalCompletionFeedbackDialog.showFeedbackSystemInfoDialog$lambda$0$0($systemInfoData, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(TerminalCompletionFeedbackDialog $this) {
        return $this.project;
    }
}

