/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.view.shellIntegration.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.session.impl.TerminalBlocksModelState;
import org.jetbrains.plugins.terminal.session.impl.TerminalState;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;
import org.jetbrains.plugins.terminal.view.TerminalContentChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockAddedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockBase;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockId;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockIdImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockRemovedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksModelEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksModelListener;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksReplacedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalBlockAddedEventImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalBlockRemovedEventImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalBlocksReplacedEventImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 <2\u00020\u0001:\u0001<B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u001dH\u0016J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020\u001f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&H\u0086\b\u00f8\u0001\u0000J\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020*J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002J\u0016\u00102\u001a\u00020\u001f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001204H\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020#H\u0002J\u0010\u00107\u001a\u00020(2\u0006\u00106\u001a\u00020#H\u0002J\u0010\u00108\u001a\u00020\u001f2\u0006\u00100\u001a\u000209H\u0002J\n\u0010:\u001a\u00020;H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006="}, d2={"Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlocksModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lcom/intellij/openapi/Disposable;)V", "blockIdCounter", "", "getBlockIdCounter", "()I", "setBlockIdCounter", "(I)V", "blocks", "", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockBase;", "getBlocks", "()Ljava/util/List;", "value", "activeBlock", "getActiveBlock", "()Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockBase;", "setActiveBlock", "(Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockBase;)V", "listeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlocksModelListener;", "addListener", "", "listener", "startNewBlock", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "updateActiveCommandBlock", "doUpdate", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalCommandBlockImpl;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalCommandBlock;", "dumpState", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalBlocksModelState;", "restoreFromState", "state", "trimBlocksBefore", "trimBlocksAfter", "adjustActiveBlockOffsets", "event", "Lorg/jetbrains/plugins/terminal/view/TerminalContentChangeEvent;", "replaceBlocks", "newBlocks", "", "addNewBlock", "startOffset", "createNewBlock", "fireListeners", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlocksModelEvent;", "toString", "", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalBlocksModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,212:1\n1#2:213\n363#3,7:214\n363#3,7:221\n13#4:228\n*S KotlinDebug\n*F\n+ 1 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl\n*L\n92#1:214,7\n110#1:221,7\n194#1:228\n*E\n"})
public final class TerminalBlocksModelImpl
implements TerminalBlocksModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @VisibleForTesting
    private int blockIdCounter;
    @NotNull
    private final List<TerminalBlockBase> blocks;
    @NotNull
    private final DisposableWrapperList<TerminalBlocksModelListener> listeners;
    @NotNull
    private static final Logger LOG;

    public TerminalBlocksModelImpl(@NotNull TerminalOutputModel outputModel, @NotNull TerminalSessionModel sessionModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.outputModel = outputModel;
        this.sessionModel = sessionModel;
        this.blocks = new ArrayList();
        this.listeners = new DisposableWrapperList();
        this.outputModel.addListener(parentDisposable, new TerminalOutputModelListener(){

            @Override
            public void afterContentChanged(TerminalContentChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.trimBlocksBefore(outputModel.getStartOffset());
                this.trimBlocksAfter(outputModel.getEndOffset());
                if (!event.isTrimming()) {
                    this.trimBlocksAfter(event.getOffset());
                    this.adjustActiveBlockOffsets(event);
                }
            }
        });
        this.addNewBlock(this.outputModel.getStartOffset());
    }

    public final int getBlockIdCounter() {
        return this.blockIdCounter;
    }

    public final void setBlockIdCounter(int n) {
        this.blockIdCounter = n;
    }

    @Override
    @NotNull
    public List<TerminalBlockBase> getBlocks() {
        return this.blocks;
    }

    @Override
    @NotNull
    public TerminalBlockBase getActiveBlock() {
        return (TerminalBlockBase)CollectionsKt.last(this.getBlocks());
    }

    public void setActiveBlock(@NotNull TerminalBlockBase value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), value);
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalBlocksModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add((Object)listener2, parentDisposable);
    }

    public final void startNewBlock(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        TerminalBlockBase terminalBlockBase = this.getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl");
        TerminalCommandBlockImpl active = (TerminalCommandBlockImpl)terminalBlockBase;
        if (Intrinsics.areEqual((Object)offset, (Object)active.getStartOffset())) {
            this.getBlocks().removeLast();
            this.fireListeners(new TerminalBlockRemovedEventImpl(this, active));
        } else {
            this.setActiveBlock(TerminalCommandBlockImpl.copy$default(active, null, null, offset, null, null, null, null, null, 251, null));
        }
        this.addNewBlock(offset);
    }

    public final void updateActiveCommandBlock(@NotNull Function1<? super TerminalCommandBlockImpl, ? extends TerminalCommandBlock> doUpdate) {
        Intrinsics.checkNotNullParameter(doUpdate, (String)"doUpdate");
        boolean $i$f$updateActiveCommandBlock = false;
        TerminalBlockBase terminalBlockBase = this.getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl");
        this.setActiveBlock((TerminalBlockBase)doUpdate.invoke((Object)((TerminalCommandBlockImpl)terminalBlockBase)));
    }

    @NotNull
    public final TerminalBlocksModelState dumpState() {
        return new TerminalBlocksModelState(CollectionsKt.toList((Iterable)this.getBlocks()), this.blockIdCounter);
    }

    public final void restoreFromState(@NotNull TerminalBlocksModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(!((Collection)state.getBlocks()).isEmpty())) {
            boolean bl = false;
            String string = "There should be always at least one block in the blocks model state";
            throw new IllegalStateException(string.toString());
        }
        this.blockIdCounter = state.getBlockIdCounter();
        this.replaceBlocks(state.getBlocks());
    }

    private final void trimBlocksBefore(TerminalOffset offset) {
        int firstNotRemovedBlockIndex;
        block5: {
            int n;
            List<TerminalBlockBase> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<TerminalBlockBase> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                TerminalBlockBase item$iv;
                TerminalBlockBase it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getEndOffset().compareTo(offset) > 0 || Intrinsics.areEqual((Object)it.getStartOffset(), (Object)it.getEndOffset()) && Intrinsics.areEqual((Object)it.getEndOffset(), (Object)offset)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = firstNotRemovedBlockIndex = -1;
        }
        if (firstNotRemovedBlockIndex != -1) {
            int $this$indexOfFirst$iv = 0;
            while ($this$indexOfFirst$iv < firstNotRemovedBlockIndex) {
                TerminalBlockBase block;
                int it = $this$indexOfFirst$iv++;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.getBlocks().removeFirst(), (String)"removeFirst(...)");
                this.fireListeners(new TerminalBlockRemovedEventImpl(this, block));
            }
        } else {
            TerminalCommandBlock newBlock = this.createNewBlock(this.outputModel.getStartOffset());
            this.replaceBlocks(CollectionsKt.listOf((Object)newBlock));
        }
    }

    private final void trimBlocksAfter(TerminalOffset offset) {
        int firstBlockToRemoveIndex;
        block5: {
            int n;
            List<TerminalBlockBase> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<TerminalBlockBase> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                TerminalBlockBase item$iv;
                TerminalBlockBase it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getStartOffset().compareTo(offset) > 0) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = firstBlockToRemoveIndex = -1;
        }
        if (firstBlockToRemoveIndex != -1) {
            int n = this.getBlocks().size() - firstBlockToRemoveIndex;
            int n2 = 0;
            while (n2 < n) {
                TerminalBlockBase block;
                int it = n2++;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.getBlocks().removeLast(), (String)"removeLast(...)");
                this.fireListeners(new TerminalBlockRemovedEventImpl(this, block));
            }
        }
        if (this.getBlocks().isEmpty()) {
            this.addNewBlock(this.outputModel.getStartOffset());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustActiveBlockOffsets(TerminalContentChangeEvent event) {
        TerminalBlockBase terminalBlockBase = this.getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl");
        TerminalCommandBlockImpl block = (TerminalCommandBlockImpl)terminalBlockBase;
        long delta = (long)event.getNewText().length() - (long)event.getOldText().length();
        if (block.getCommandStartOffset() != null && event.getOffset().compareTo(block.getStartOffset()) >= 0 && event.getOffset().plus(event.getOldText().length()).compareTo(block.getCommandStartOffset()) < 0) {
            TerminalOffset terminalOffset;
            TerminalCommandBlockImpl terminalCommandBlockImpl = block;
            TerminalBlockId terminalBlockId = null;
            TerminalOffset terminalOffset2 = null;
            TerminalOffset terminalOffset3 = null;
            TerminalOffset terminalOffset4 = block.getCommandStartOffset().plus(delta);
            TerminalOffset terminalOffset5 = block.getOutputStartOffset();
            if (terminalOffset5 != null) {
                void it;
                TerminalOffset terminalOffset6 = terminalOffset5;
                TerminalOffset terminalOffset7 = terminalOffset4;
                TerminalOffset terminalOffset8 = terminalOffset3;
                TerminalOffset terminalOffset9 = terminalOffset2;
                TerminalBlockId terminalBlockId2 = terminalBlockId;
                TerminalCommandBlockImpl terminalCommandBlockImpl2 = terminalCommandBlockImpl;
                boolean bl = false;
                TerminalOffset terminalOffset10 = it.plus(delta);
                terminalCommandBlockImpl = terminalCommandBlockImpl2;
                terminalBlockId = terminalBlockId2;
                terminalOffset2 = terminalOffset9;
                terminalOffset3 = terminalOffset8;
                terminalOffset4 = terminalOffset7;
                terminalOffset = terminalOffset10;
            } else {
                terminalOffset = null;
            }
            block = TerminalCommandBlockImpl.copy$default(terminalCommandBlockImpl, terminalBlockId, terminalOffset2, terminalOffset3, terminalOffset4, terminalOffset, null, null, null, 231, null);
        } else if (block.getCommandStartOffset() != null && block.getOutputStartOffset() != null && event.getOffset().compareTo(block.getCommandStartOffset()) >= 0 && event.getOffset().plus(event.getOldText().length()).compareTo(block.getOutputStartOffset()) < 0) {
            block = TerminalCommandBlockImpl.copy$default(block, null, null, null, null, block.getOutputStartOffset().plus(delta), null, null, null, 239, null);
        }
        this.setActiveBlock(TerminalCommandBlockImpl.copy$default(block, null, null, this.outputModel.getEndOffset(), null, null, null, null, null, 251, null));
    }

    private final void replaceBlocks(List<? extends TerminalBlockBase> newBlocks) {
        List oldBlocks = CollectionsKt.toList((Iterable)this.getBlocks());
        this.getBlocks().clear();
        this.getBlocks().addAll((Collection<TerminalBlockBase>)newBlocks);
        this.fireListeners(new TerminalBlocksReplacedEventImpl(this, oldBlocks, newBlocks));
    }

    private final void addNewBlock(TerminalOffset startOffset) {
        TerminalCommandBlock newBlock = this.createNewBlock(startOffset);
        this.getBlocks().add(newBlock);
        this.fireListeners(new TerminalBlockAddedEventImpl(this, newBlock));
    }

    private final TerminalCommandBlock createNewBlock(TerminalOffset startOffset) {
        int n = this.blockIdCounter;
        this.blockIdCounter = n + 1;
        return new TerminalCommandBlockImpl(new TerminalBlockIdImpl(n), startOffset, this.outputModel.getEndOffset(), null, null, ((TerminalState)this.sessionModel.getTerminalState().getValue()).getCurrentDirectory(), null, null);
    }

    private final void fireListeners(TerminalBlocksModelEvent event) {
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this.listeners, LOG, "Exception during handling " + event, arg_0 -> TerminalBlocksModelImpl.fireListeners$lambda$0(event, arg_0));
    }

    @NotNull
    public String toString() {
        return "TerminalBlocksModelImpl(blocks=" + this.getBlocks() + ")";
    }

    private static final Unit fireListeners$lambda$0(TerminalBlocksModelEvent $event, TerminalBlocksModelListener it) {
        TerminalBlocksModelEvent terminalBlocksModelEvent = $event;
        if (terminalBlocksModelEvent instanceof TerminalBlockAddedEvent) {
            it.blockAdded((TerminalBlockAddedEvent)$event);
        } else if (terminalBlocksModelEvent instanceof TerminalBlockRemovedEvent) {
            it.blockRemoved((TerminalBlockRemovedEvent)$event);
        } else if (terminalBlocksModelEvent instanceof TerminalBlocksReplacedEvent) {
            it.blocksReplaced((TerminalBlocksReplacedEvent)$event);
        } else {
            throw new IllegalStateException(("Unexpected event: " + $event).toString());
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalBlocksModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

