/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local;

import com.intellij.execution.process.LocalProcessService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.EelWindowsProcess;
import com.intellij.platform.eel.channels.EelReceiveChannel;
import com.intellij.platform.eel.channels.EelSendChannel;
import com.intellij.platform.eel.impl.local.EelLocalApiService;
import com.intellij.platform.eel.impl.local.LocalEelWindowsProcess;
import com.intellij.platform.eel.impl.local.LocalPid;
import com.intellij.platform.eel.impl.local.StreamClosedAwareEelReceiveChannel;
import com.intellij.platform.eel.provider.utils.EelChannelUtilsKt;
import com.intellij.util.io.ProcessKt;
import com.pty4j.WinSize;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010!\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\"J\b\u0010$\u001a\u00020\u0003H\u0016J\u001e\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006*"}, d2={"Lcom/intellij/platform/eel/impl/local/LocalEelWindowsProcess;", "Lcom/intellij/platform/eel/EelWindowsProcess;", "process", "Ljava/lang/Process;", "resizeWindow", "Lkotlin/Function1;", "Lcom/pty4j/WinSize;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "commandLineForDebug", "", "<init>", "(Ljava/lang/Process;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;)V", "pid", "Lcom/intellij/platform/eel/EelApi$Pid;", "getPid", "()Lcom/intellij/platform/eel/EelApi$Pid;", "stdin", "Lcom/intellij/platform/eel/channels/EelSendChannel;", "getStdin", "()Lcom/intellij/platform/eel/channels/EelSendChannel;", "stdout", "Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "getStdout", "()Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "stderr", "getStderr", "exitCode", "Lkotlinx/coroutines/Deferred;", "", "getExitCode", "()Lkotlinx/coroutines/Deferred;", "kill", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "interrupt", "convertToJavaProcess", "resizePty", "columns", "rows", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.eel.impl"})
public final class LocalEelWindowsProcess
implements EelWindowsProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process process;
    @Nullable
    private final Function1<WinSize, Unit> resizeWindow;
    @NotNull
    private final EelApi.Pid pid;
    @NotNull
    private final EelSendChannel stdin;
    @NotNull
    private final EelReceiveChannel stdout;
    @NotNull
    private final EelReceiveChannel stderr;
    @NotNull
    private final Deferred<Integer> exitCode;

    private LocalEelWindowsProcess(Process process, Function1<? super WinSize, Unit> resizeWindow, CoroutineScope scope, String commandLineForDebug) {
        this.process = process;
        this.resizeWindow = resizeWindow;
        this.pid = new LocalPid(this.process.pid());
        OutputStream outputStream = this.process.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        this.stdin = EelChannelUtilsKt.asEelChannel((OutputStream)outputStream);
        InputStream inputStream = this.process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.stdout = new StreamClosedAwareEelReceiveChannel(EelChannelUtilsKt.consumeAsEelChannel((InputStream)inputStream));
        InputStream inputStream2 = this.process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        this.stderr = new StreamClosedAwareEelReceiveChannel(EelChannelUtilsKt.consumeAsEelChannel((InputStream)inputStream2));
        this.exitCode = BuildersKt.async$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)new CoroutineName("LocalEelWindowsProcess (" + commandLineForDebug + ") pid=" + this.process.pid())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this, null){
            int label;
            final /* synthetic */ LocalEelWindowsProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ProcessKt.awaitExit((Process)LocalEelWindowsProcess.access$getProcess$p(this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public EelApi.Pid getPid() {
        return this.pid;
    }

    @NotNull
    public EelSendChannel getStdin() {
        return this.stdin;
    }

    @NotNull
    public EelReceiveChannel getStdout() {
        return this.stdout;
    }

    @NotNull
    public EelReceiveChannel getStderr() {
        return this.stderr;
    }

    @NotNull
    public Deferred<Integer> getExitCode() {
        return this.exitCode;
    }

    @Nullable
    public Object kill(@NotNull Continuation<? super Unit> $completion) {
        this.process.destroyForcibly();
        return Unit.INSTANCE;
    }

    @Nullable
    public Object interrupt(@NotNull Continuation<? super Unit> $completion) {
        LocalProcessService.Companion.getInstance().sendWinProcessCtrlC(this.process);
        return Unit.INSTANCE;
    }

    @NotNull
    public Process convertToJavaProcess() {
        return this.process;
    }

    @Nullable
    public Object resizePty(int columns, int rows, @NotNull Continuation<? super Unit> $completion) {
        if (!this.process.isAlive()) {
            throw new EelProcess.ResizePtyError.ProcessExited();
        }
        Function1<WinSize, Unit> function1 = this.resizeWindow;
        if (function1 == null) {
            throw new EelProcess.ResizePtyError.NoPty();
        }
        Function1<WinSize, Unit> resizeWindow = function1;
        resizeWindow.invoke((Object)new WinSize(columns, rows));
        return Unit.INSTANCE;
    }

    @JvmStatic
    @Nullable
    public static final Object create(@NotNull Process process, @Nullable Function1<? super WinSize, Unit> resizeWindow, @NotNull String commandLineForDebug, @NotNull Continuation<? super LocalEelWindowsProcess> $completion) {
        return Companion.create(process, resizeWindow, commandLineForDebug, $completion);
    }

    public /* synthetic */ LocalEelWindowsProcess(Process process, Function1 resizeWindow, CoroutineScope scope, String commandLineForDebug, DefaultConstructorMarker $constructor_marker) {
        this(process, (Function1<? super WinSize, Unit>)resizeWindow, scope, commandLineForDebug);
    }

    public static final /* synthetic */ Process access$getProcess$p(LocalEelWindowsProcess $this) {
        return $this.process;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0087@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/eel/impl/local/LocalEelWindowsProcess$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/platform/eel/impl/local/LocalEelWindowsProcess;", "process", "Ljava/lang/Process;", "resizeWindow", "Lkotlin/Function1;", "Lcom/pty4j/WinSize;", "", "commandLineForDebug", "", "(Ljava/lang/Process;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalEelWindowsProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEelWindowsProcess.kt\ncom/intellij/platform/eel/impl/local/LocalEelWindowsProcess$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,59:1\n75#2:60\n*S KotlinDebug\n*F\n+ 1 LocalEelWindowsProcess.kt\ncom/intellij/platform/eel/impl/local/LocalEelWindowsProcess$Companion\n*L\n30#1:60\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final Object create(@NotNull Process process, @Nullable Function1<? super WinSize, Unit> resizeWindow, @NotNull String commandLineForDebug, @NotNull Continuation<? super LocalEelWindowsProcess> $completion) {
            if (!($completion instanceof create.1)) ** GOTO lbl-1000
            var11_5 = $completion;
            if ((var11_5.label & -2147483648) != 0) {
                var11_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.create(null, null, null, (Continuation<? super LocalEelWindowsProcess>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var17_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                    var5_8 = (ComponentManager)v0;
                    var8_10 = resizeWindow;
                    var7_11 = process;
                    $i$f$serviceAsync = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)resizeWindow);
                    $continuation.L$2 = commandLineForDebug;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.L$4 = var7_11;
                    $continuation.L$5 = var8_10;
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v1 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(EelLocalApiService.class, (Continuation)$continuation);
                    if (v1 == var17_7) {
                        return var17_7;
                    }
                    ** GOTO lbl41
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    var8_10 = (Function1)$continuation.L$5;
                    var7_11 = (Process)$continuation.L$4;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$3;
                    commandLineForDebug = (String)$continuation.L$2;
                    resizeWindow = (Function1)$continuation.L$1;
                    process = (Process)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    var9_14 = v1;
                    var12_15 = null;
                    var13_16 = commandLineForDebug;
                    var14_17 = ((EelLocalApiService)var9_14).getScope();
                    var15_18 = var8_10;
                    var16_19 = var7_11;
                    return new LocalEelWindowsProcess(var16_19, var15_18, var14_17, var13_16, var12_15);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

