/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local.tunnels;

import com.intellij.platform.eel.ConfigurableClientSocket;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.channels.EelReceiveChannel;
import com.intellij.platform.eel.channels.EelSendChannel;
import com.intellij.platform.eel.impl.local.tunnels.ConfigurableClientSocketImpl;
import com.intellij.platform.eel.provider.utils.EelChannelUtilsKt;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\t\u001a\u00020\nH\u0096\u0080\u0004J7\u0010\u0013\u001a\u00020\u00142'\u0010\u0015\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/eel/impl/local/tunnels/SocketAdapter;", "Lcom/intellij/platform/eel/EelTunnelsApi$Connection;", "channel", "Ljava/nio/channels/SocketChannel;", "<init>", "(Ljava/nio/channels/SocketChannel;)V", "socket", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "toString", "", "sendChannel", "Lcom/intellij/platform/eel/channels/EelSendChannel;", "getSendChannel", "()Lcom/intellij/platform/eel/channels/EelSendChannel;", "receiveChannel", "Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "getReceiveChannel", "()Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "configureSocket", "", "block", "Lkotlin/Function2;", "Lcom/intellij/platform/eel/ConfigurableClientSocket;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel.impl"})
public final class SocketAdapter
implements EelTunnelsApi.Connection {
    @NotNull
    private final SocketChannel channel;
    private final Socket socket;
    @NotNull
    private final EelSendChannel sendChannel;
    @NotNull
    private final EelReceiveChannel receiveChannel;

    public SocketAdapter(@NotNull SocketChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.socket = this.channel.socket();
        this.sendChannel = EelChannelUtilsKt.asEelChannel((WritableByteChannel)this.channel);
        this.receiveChannel = EelChannelUtilsKt.consumeAsEelChannel((ReadableByteChannel)this.channel);
    }

    @NotNull
    public String toString() {
        return "SocketAdapter[" + this.channel + "]";
    }

    @NotNull
    public EelSendChannel getSendChannel() {
        return this.sendChannel;
    }

    @NotNull
    public EelReceiveChannel getReceiveChannel() {
        return this.receiveChannel;
    }

    @Nullable
    public Object configureSocket(@NotNull Function2<? super ConfigurableClientSocket, ? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        Socket socket = this.socket;
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
        Object object = block.invoke((Object)new ConfigurableClientSocketImpl(socket), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        if (this.socket.isClosed()) {
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SocketAdapter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            if (SocketAdapter.access$getSocket$p(this.this$0).getSoLinger() != 0) {
                                SocketAdapter.access$getSocket$p(this.this$0).shutdownOutput();
                                SocketAdapter.access$getSocket$p(this.this$0).shutdownInput();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        SocketAdapter.access$getSocket$p(this.this$0).close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Socket access$getSocket$p(SocketAdapter $this) {
        return $this.socket;
    }
}

