/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.version;

import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JBossVersionHandlerBase
implements JBossVersionHandler {
    private static final Logger LOG = Logger.getInstance(JBossVersionHandlerBase.class);
    private final String myHome;
    private JavaeeServerVersionDescriptor myVersionDescriptor;

    public JBossVersionHandlerBase(String home) {
        this.myHome = home;
    }

    @Override
    public void detect() throws IOException {
        this.myVersionDescriptor = this.doDetect();
    }

    @Override
    public JavaeeServerVersionDescriptor getVersionDescriptor() {
        return this.myVersionDescriptor;
    }

    protected final String getHome() {
        return this.myHome;
    }

    protected final Path findFileUnderHome(@NonNls String relativePath) throws IOException {
        Path result = Path.of(this.getHome(), new String[0]).resolve(FileUtil.toSystemDependentName((String)relativePath));
        if (!Files.exists(result, new LinkOption[0])) {
            throw new FileNotFoundException(AppServersCommonBundle.getText((String)"Error.fileNotFound", (Object[])new Object[]{relativePath}));
        }
        return result;
    }

    @Override
    @NotNull
    public Path findLibrary(String dir, String jarPrefix) throws IOException {
        Path asJarDir = this.findFileUnderHome(dir);
        if (!Files.isDirectory(asJarDir, new LinkOption[0])) {
            throw new IOException("Directory is expected: " + String.valueOf(asJarDir));
        }
        Stream<Path> pathStream = Files.list(asJarDir).filter(path -> {
            String string = path.getFileName().toString();
            return string.startsWith(jarPrefix) && string.endsWith(".jar");
        });
        List<Path> asJars = pathStream.toList();
        int length = asJars.size();
        if (length == 0) {
            throw new IOException("Exactly one AS JAR is expected, while found none");
        }
        if (length > 1) {
            StringBuilder message = new StringBuilder().append("There were ").append(length).append(" jars found:");
            for (Path jar : asJars) {
                message.append("\n").append(jar.toAbsolutePath());
            }
            LOG.debug(message.toString());
        }
        Path path2 = asJars.get(0);
        Path path3 = path2;
        if (path3 == null) {
            JBossVersionHandlerBase.$$$reportNull$$$0(0);
        }
        return path3;
        finally {
            if (pathStream != null) {
                pathStream.close();
            }
        }
    }

    protected abstract JavaeeServerVersionDescriptor doDetect() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/version/JBossVersionHandlerBase", "findLibrary"));
    }
}

