/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface FileViewProvider
extends Cloneable,
UserDataHolderEx {
    @NotNull
    public PsiManager getManager();

    public Document getDocument();

    @NotNull
    public CharSequence getContents();

    @NotNull
    public VirtualFile getVirtualFile();

    @NotNull
    public Language getBaseLanguage();

    @NotNull
    public @Unmodifiable Set<Language> getLanguages();

    default public boolean hasLanguage(@NotNull Language language) {
        if (language == null) {
            FileViewProvider.$$$reportNull$$$0(0);
        }
        return this.getLanguages().contains((Object)language);
    }

    @Nullable
    public PsiFile getPsi(@NotNull Language var1);

    @NotNull
    public @NotNull @Unmodifiable List<@NotNull PsiFile> getAllFiles();

    public boolean isEventSystemEnabled();

    public boolean isPhysical();

    public long getModificationStamp();

    public boolean supportsIncrementalReparse(@NotNull Language var1);

    public void rootChanged(@NotNull PsiFile var1);

    public void beforeContentsSynchronized();

    public void contentsSynchronized();

    public FileViewProvider clone();

    @Nullable
    public PsiElement findElementAt(int var1);

    @Nullable
    public PsiReference findReferenceAt(int var1);

    @Nullable
    public PsiElement findElementAt(int var1, @NotNull Language var2);

    @Nullable
    public PsiElement findElementAt(int var1, @NotNull Class<? extends Language> var2);

    @Nullable
    public PsiReference findReferenceAt(int var1, @NotNull Language var2);

    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile var1);

    @NotNull
    public PsiFile getStubBindingRoot();

    @NotNull
    public FileType getFileType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/FileViewProvider", "hasLanguage"));
    }
}

