/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import com.intellij.psi.search.CodeInsightContextInfo;
import com.intellij.psi.search.CodeInsightContextInfoIntersectionKt;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IntersectionFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class IntersectionScope
extends GlobalSearchScope
implements VirtualFileEnumerationAware,
CodeInsightContextAwareSearchScope {
    final GlobalSearchScope myScope1;
    final GlobalSearchScope myScope2;

    IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
        if (scope1 == null) {
            IntersectionScope.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            IntersectionScope.$$$reportNull$$$0(1);
        }
        super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
        this.myScope1 = scope1;
        this.myScope2 = scope2;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            IntersectionScope.$$$reportNull$$$0(2);
        }
        return this.containsScope(scope) ? this : new IntersectionScope(this, scope);
    }

    boolean containsScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            IntersectionScope.$$$reportNull$$$0(3);
        }
        if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
            return true;
        }
        if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
            return true;
        }
        return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = CoreBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
        if (string == null) {
            IntersectionScope.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        boolean firstResult;
        if (file == null) {
            IntersectionScope.$$$reportNull$$$0(5);
        }
        if (!(firstResult = this.myScope1.contains(file))) {
            return false;
        }
        ProgressManager.checkCanceled();
        return this.myScope2.contains(file);
    }

    @Override
    @NotNull
    public CodeInsightContextInfo getCodeInsightContextInfo() {
        CodeInsightContextInfo codeInsightContextInfo = CodeInsightContextInfoIntersectionKt.createIntersectionCodeInsightContextInfo(this.myScope1, this.myScope2);
        if (codeInsightContextInfo == null) {
            IntersectionScope.$$$reportNull$$$0(6);
        }
        return codeInsightContextInfo;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            IntersectionScope.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            IntersectionScope.$$$reportNull$$$0(8);
        }
        int res1 = this.myScope1.compare(file1, file2);
        int res2 = this.myScope2.compare(file1, file2);
        if (res1 == 0) {
            return res2;
        }
        if (res2 == 0) {
            return res1;
        }
        if (res1 > 0 == res2 > 0) {
            return res1;
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            IntersectionScope.$$$reportNull$$$0(9);
        }
        return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            IntersectionScope.$$$reportNull$$$0(10);
        }
        return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
    }

    @Override
    public @Unmodifiable @NotNull Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Collection collection = ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
        if (collection == null) {
            IntersectionScope.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntersectionScope)) {
            return false;
        }
        IntersectionScope that = (IntersectionScope)o;
        return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
    }

    @Override
    public int calcHashCode() {
        return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
    }

    @NonNls
    public String toString() {
        return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
    }

    @Override
    @NotNull
    public String toFullString() {
        String string = "Intersection: (" + this.myScope1.toFullString() + ", " + this.myScope2.toFullString() + ")";
        if (string == null) {
            IntersectionScope.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        VirtualFileEnumeration fileEnumeration1 = VirtualFileEnumeration.extract(this.myScope1);
        VirtualFileEnumeration fileEnumeration2 = VirtualFileEnumeration.extract(this.myScope2);
        if (fileEnumeration1 == null) {
            return null;
        }
        if (fileEnumeration2 == null) {
            return null;
        }
        return new IntersectionFileEnumeration(Arrays.asList(fileEnumeration1, fileEnumeration2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/IntersectionScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/IntersectionScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContextInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toFullString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsScope";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

