/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.types;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlMatchRecognizeExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlObjectLiteralExpression;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\"\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "Lcom/intellij/database/types/DasTypeSystemBase;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "sqlDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getSqlDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "sqlDialect$delegate", "Lkotlin/Lazy;", "getDasType", "Lcom/intellij/database/types/DasType;", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "createTableType", "Lcom/intellij/sql/psi/SqlTableType;", "target", "Lcom/intellij/database/model/DasTable;", "refElement", "getAsteriskType", "element", "getUnqualifiedAsteriskType", "supportsAsteriskArgument", "", "definition", "Lcom/intellij/sql/dialects/BuiltinFunction;", "getReservedEntityType", "name", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.base"})
public class DasTypeSystemImpl
extends DasTypeSystemBase {
    @NotNull
    private final Lazy sqlDialect$delegate;

    public DasTypeSystemImpl(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.sqlDialect$delegate = LazyKt.lazy(() -> DasTypeSystemImpl.sqlDialect_delegate$lambda$0(dbms));
    }

    @NotNull
    public final SqlLanguageDialectEx getSqlDialect() {
        Lazy lazy = this.sqlDialect$delegate;
        return (SqlLanguageDialectEx)lazy.getValue();
    }

    @NotNull
    public DasType getDasType(@Nullable SqlReference ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        SqlSelectClause clause;
        PsiElement parent;
        SqlMatchRecognizeExpression matchRecognize;
        SqlReference kind;
        DasType typeFromDb;
        PsiElement target;
        DasObject dasObject;
        if (ref == null && resolved == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        SqlReference sqlReference = ref;
        PsiElement refElement = sqlReference != null ? sqlReference.getElement() : null;
        DasSymbol dasSymbol = symbol;
        Object object = dasObject = dasSymbol != null ? dasSymbol.getDasObject() : null;
        if (dasObject instanceof ReservedEntity.Typed) {
            DasType dasType = ((ReservedEntity.Typed)dasObject).type;
            if (dasType == null) {
                dasType = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            return dasType;
        }
        Object object2 = target = dasObject != null && !(dasObject instanceof ReservedEntity) ? dasObject : resolved;
        if (target instanceof DasSynonym) {
            target = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)target));
        }
        if (target instanceof DbElement && (typeFromDb = DbImplUtilCore.getDatabaseDialect((DbElement)((DbElement)target)).getDasType(refElement, (DbElement)target)) != null) {
            return typeFromDb;
        }
        SqlReference sqlReference2 = ref;
        if (sqlReference2 == null || (sqlReference2 = sqlReference2.getReferenceElementType()) == null || (sqlReference2 = sqlReference2.getTargetKind()) == null) {
            sqlReference2 = kind = ObjectKind.NONE;
        }
        if (target == refElement) {
            PsiElement psiElement = refElement;
            Intrinsics.checkNotNull((Object)psiElement);
            if (SqlImplUtil.isAsteriskRef((PsiElement)psiElement)) {
                return this.getAsteriskType(refElement);
            }
        }
        if (kind == ObjectKind.SEQUENCE || target instanceof DasObject && ((DasObject)target).getKind() == ObjectKind.SEQUENCE) {
            DasTypeSystemBase dasTypeSystemBase = this.getSqlDialect().getTypeSystem();
            PsiElement psiElement = refElement;
            if (psiElement == null) {
                psiElement = resolved;
            }
            Intrinsics.checkNotNull((Object)psiElement);
            return dasTypeSystemBase.createSequenceType(psiElement, resolved);
        }
        if (target instanceof DasRoutine && refElement instanceof SqlReferenceExpression) {
            DasType dasType = SqlFunctionCallExpressionImpl.createFunctionReturnType((SqlReferenceExpression)((SqlReferenceExpression)refElement), (PsiElement)refElement);
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"createFunctionReturnType(...)");
            return dasType;
        }
        if (target instanceof DasTable) {
            return (DasType)this.createTableType((DasTable)target, resolved, refElement);
        }
        if (target instanceof SqlCreateTypeStatement) {
            DasType dasType = ((SqlCreateTypeStatement)target).getSelfDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getSelfDasType(...)");
            return dasType;
        }
        if (target instanceof SqlFileImpl.GroupImpl && ((SqlFileImpl.GroupImpl)target).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement createType = (SqlCreateTypeStatement)((SqlFileImpl.GroupImpl)target).delegates().filter(SqlCreateTypeStatement.class).first();
            SqlCreateTypeStatement sqlCreateTypeStatement = createType;
            if (sqlCreateTypeStatement == null || (sqlCreateTypeStatement = sqlCreateTypeStatement.getSelfDasType()) == null) {
                sqlCreateTypeStatement = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            return sqlCreateTypeStatement;
        }
        if (target instanceof SqlTypedDefinition) {
            DasType dasType;
            DasType dasType2 = SqlImplUtil.getDasType((SqlTypedDefinition)((SqlTypedDefinition)target), (SqlLanguageDialectEx)this.getSqlDialect(), (PsiElement)refElement);
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
            DasType type = dasType2;
            if (Intrinsics.areEqual((Object)type, (Object)DasTypeSystemBase.UNKNOWN)) {
                String string = ((SqlTypedDefinition)target).getName();
                Intrinsics.checkNotNull((Object)kind);
                dasType = this.getReservedEntityType(string, (ObjectKind)kind, target);
            } else {
                dasType = type;
            }
            return dasType;
        }
        if (target instanceof DasObject && ((DasObject)target).getKind() == ObjectKind.OBJECT_TYPE) {
            DasUserDefinedType customType;
            PsiElement psiElement = target;
            DasUserDefinedType dasUserDefinedType = customType = psiElement instanceof DasUserDefinedType ? (DasUserDefinedType)psiElement : null;
            if (customType != null && customType.getSuperType() == null && customType.getDasChildren(ObjectKind.OBJECT_ATTRIBUTE).filter(DasTypedObject.class).isEmpty()) {
                DataType dataType = this.getDatabaseDialect().convertUDTToDataType(customType);
                if (dataType != null) {
                    return DasUnresolvedTypeReference.Companion.of(dataType);
                }
                if (resolved != null) {
                    DasType dasType = SqlImplUtil.getDasType((DasUserDefinedType)customType, (PsiElement)resolved, (SqlLanguageDialectEx)this.getSqlDialect());
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                    return dasType;
                }
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            if (resolved != null) {
                SqlTableType sqlTableType = SqlTableTypeBase.createObjectTypeType((DasObject)((DasObject)target), (PsiElement)resolved, (PsiElement)refElement);
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createObjectTypeType(...)");
                return (DasType)sqlTableType;
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        if (target instanceof DasSynonym) {
            DasTable info;
            DasObject synonymTarget = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)target));
            if (synonymTarget instanceof DasSynonym) {
                DasType dasType;
                SqlReference sqlReference3 = ref;
                if (sqlReference3 != null) {
                    SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)((PsiReference)sqlReference3));
                    Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createUnresolvedTableType(...)");
                    dasType = (DasType)sqlTableType;
                } else {
                    dasType = (DasType)DasTypeSystemBase.UNKNOWN;
                }
                return dasType;
            }
            DasTable dasTable = info = synonymTarget instanceof DasTable ? (DasTable)synonymTarget : null;
            if (info == null || resolved == null) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            PsiElement tablePsi = SqlImplUtil.wrapObjectToPsi((DasObject)((DasObject)info), (Project)resolved.getProject());
            SqlTableType sqlTableType = SqlTableTypeBase.createType((DasTable)info, (PsiElement)tablePsi, (PsiElement)refElement);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
            return (DasType)sqlTableType;
        }
        if (target instanceof DasColumn) {
            if (resolved != null) {
                DasType dasType = SqlImplUtil.getDasType((DasTypedObject)((DasTypedObject)target), (SqlLanguageDialectEx)this.getSqlDialect(), (PsiElement)resolved);
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        if (target == null && DbImplUtilCore.isTypeKind((ObjectKind)kind)) {
            SqlReference sqlReference4 = ref;
            Intrinsics.checkNotNull((Object)sqlReference4);
            String string = sqlReference4.getReferenceName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReferenceName(...)");
            String name = string;
            if (StringUtil.isEmpty((String)name)) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            DataType dataType = DataTypeFactory.of((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            DataType dataType2 = dataType;
            return this.getSqlDialect().getTypeSystem().createDasType(dataType2);
        }
        if (symbol != null && Intrinsics.areEqual((Object)symbol.getKind(), (Object)SqlDbElementType.PATTERN_SYMBOL) && (matchRecognize = (SqlMatchRecognizeExpression)PsiTreeUtil.getParentOfType((PsiElement)resolved, SqlMatchRecognizeExpression.class)) != null) {
            DasType dasType = matchRecognize.getSourceExpression().getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return dasType;
        }
        if (target == refElement) {
            SqlReference sqlReference5 = ref;
            Intrinsics.checkNotNull((Object)sqlReference5);
            String string = sqlReference5.getReferenceName();
            Intrinsics.checkNotNull((Object)kind);
            PsiElement psiElement = refElement;
            Intrinsics.checkNotNull((Object)psiElement);
            return this.getReservedEntityType(string, (ObjectKind)kind, psiElement);
        }
        if (target instanceof BuiltinFunction && refElement != null && (parent = refElement.getParent()) instanceof SqlFunctionCallExpression) {
            DasType dasType = ((SqlFunctionCallExpression)parent).getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return dasType;
        }
        if (target instanceof SqlExpression) {
            DasType dasType = ((SqlExpression)target).getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return dasType;
        }
        if (target instanceof SqlColumnSymbol) {
            DasType dasType = ((SqlColumnSymbol)target).getType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getType(...)");
            return dasType;
        }
        if (target instanceof SqlDefinition && (parent = ((SqlDefinition)target).getParent()) instanceof SqlSelectIntoClause && (clause = (SqlSelectClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, SqlSelectClause.class)) != null) {
            SqlTableType sqlTableType = SqlImplUtil.getSelectType((List)clause.getExpressions(), (PsiElement)target);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"getSelectType(...)");
            return (DasType)sqlTableType;
        }
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
            SqlReference sqlReference6 = ref;
            Intrinsics.checkNotNull((Object)sqlReference6);
            SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)((PsiReference)sqlReference6));
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createUnresolvedTableType(...)");
            return (DasType)sqlTableType;
        }
        if (target instanceof DbCustomType && ((DbCustomType)target).getDelegate() instanceof DasTypedObject) {
            if (resolved != null) {
                Object object3 = ((DbCustomType)target).getDelegate();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.database.model.DasTypedObject");
                DasType dasType = SqlImplUtil.getDasType((DasTypedObject)((DasTypedObject)object3), (SqlLanguageDialectEx)this.getSqlDialect(), (PsiElement)resolved);
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        if (target instanceof DasTypedObject) {
            if (resolved != null) {
                DasType dasType = SqlImplUtil.getDasType((DasTypedObject)((DasTypedObject)target), (SqlLanguageDialectEx)this.getSqlDialect(), (PsiElement)resolved);
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        if (target instanceof DasUserDefinedType) {
            if (resolved != null) {
                DasType dasType = SqlImplUtil.getDasType((DasUserDefinedType)((DasUserDefinedType)target), (PsiElement)resolved, (SqlLanguageDialectEx)this.getSqlDialect());
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        return (DasType)DasTypeSystemBase.UNKNOWN;
    }

    @NotNull
    protected SqlTableType createTableType(@NotNull DasTable target, @Nullable PsiElement resolved, @Nullable PsiElement refElement) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        SqlTableType sqlTableType = SqlTableTypeBase.createType((DasTable)target, (PsiElement)resolved, (PsiElement)refElement);
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
        return sqlTableType;
    }

    private final DasType getAsteriskType(PsiElement element) {
        DasType dasType;
        SqlExpression qualifier;
        PsiElement parent = element.getParent();
        PsiElement grandParent = parent.getParent();
        SqlExpression sqlExpression = qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        if (qualifier != null) {
            dasType = SqlImplUtil.filterHiddenColumns((DasType)qualifier.getDasType());
        } else {
            dasType = this.getUnqualifiedAsteriskType(element);
            if (dasType == null) {
                SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
                return (DasType)sqlTableType;
            }
        }
        DasType dasType2 = dasType;
        Intrinsics.checkNotNull((Object)dasType2);
        DasType asteriskType = dasType2;
        if (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.CLICKHOUSE) || Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.VERTICA)) {
            return asteriskType;
        }
        if (parent instanceof SqlObjectLiteralExpression && this.getDbms().isSnowflake()) {
            return asteriskType;
        }
        if (parent instanceof SqlExpressionList && this.getDbms().isPostgres() && qualifier != null) {
            return asteriskType;
        }
        if (parent instanceof SqlReturningClause && (this.getDbms().isPostgres() || this.getDbms().isSqlite() || this.getDbms().isMicrosoft())) {
            return asteriskType;
        }
        if (parent instanceof SqlExpressionList && grandParent instanceof SqlFunctionCallExpression) {
            BuiltinFunction builtinFunction = ((SqlFunctionCallExpression)grandParent).getFunctionDefinition();
            if (builtinFunction == null) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            BuiltinFunction definition = builtinFunction;
            if (qualifier != null && !this.getDatabaseDialect().supportsQualifiedAsteriskInCalls() || !this.supportsAsteriskArgument(definition)) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
        } else {
            PsiElement curParent = parent;
            while (curParent instanceof SqlReferenceExpression) {
                curParent = ((SqlReferenceExpression)curParent).getParent();
            }
            if (this.getDbms().isPostgres() || this.getDbms().isHsqldb() || this.getDbms().isH2()) {
                while (curParent instanceof SqlParenthesizedExpression) {
                    curParent = ((SqlParenthesizedExpression)curParent).getParent();
                }
            }
            if (!(curParent instanceof SqlSelectClause || curParent instanceof SqlDmlInstruction || curParent instanceof SqlFromClause && ((SqlFromClause)curParent).getParent() instanceof SqlDmlInstruction || this.getDbms().isMysql() && PsiUtilCore.getElementType((PsiElement)curParent) == SqlCompositeElementTypes.SQL_CLAUSE && curParent.getParent() instanceof SqlDmlInstruction)) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
        }
        return asteriskType;
    }

    @Nullable
    public DasType getUnqualifiedAsteriskType(@NotNull PsiElement element) {
        SqlExpression result;
        SqlExpression sqlExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getParent() instanceof SqlReturningClause) {
            SqlDmlInstruction instruction;
            SqlDmlInstruction sqlDmlInstruction = instruction = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)element, SqlDmlInstruction.class);
            Object targetExpression = sqlDmlInstruction != null ? sqlDmlInstruction.getTargetExpression() : null;
            sqlExpression = targetExpression;
            if (sqlExpression == null || (sqlExpression = sqlExpression.getDasType()) == null) {
                sqlExpression = (DasType)SqlTableTypeBase.EMPTY_TABLE;
            }
        } else {
            SqlTableExpression tableExpression;
            SqlQueryExpression queryExpression;
            SqlQueryExpression sqlQueryExpression = queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class, (boolean)true);
            SqlTableExpression sqlTableExpression = tableExpression = sqlQueryExpression != null ? sqlQueryExpression.getTableExpression() : null;
            sqlExpression = (DasType)(sqlTableExpression != null ? sqlTableExpression.getDasType() : null);
        }
        SqlExpression sqlExpression2 = result = sqlExpression;
        return sqlExpression2 != null ? SqlImplUtil.filterHiddenColumns((DasType)sqlExpression2) : null;
    }

    protected boolean supportsAsteriskArgument(@NotNull BuiltinFunction definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return StringsKt.equals((String)definition.getName(), (String)"count", (boolean)true);
    }

    private final DasType getReservedEntityType(String name, ObjectKind kind, PsiElement element) {
        Ref.ObjectRef targetType = new Ref.ObjectRef();
        SqlLanguageDialectEx sqlLanguageDialectEx = this.getSqlDialect();
        List list = CollectionsKt.emptyList();
        this.getSqlDialect().processReservedEntitiesWithType(name, element, true, (SqlScopeProcessor)new SqlScopeProcessorBase(name, element, (Ref.ObjectRef<DasType>)targetType, sqlLanguageDialectEx, list){
            final /* synthetic */ Ref.ObjectRef<DasType> $targetType;
            {
                this.$targetType = $targetType;
                super($name, $super_call_param$1, $super_call_param$2, $element);
            }

            public boolean isResultEmpty() {
                return this.$targetType.element == null;
            }

            public boolean executeTarget(DasSymbol symbol, DasType dasType, Boolean forcedCaseSens, ResolveState state) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (dasType != null) {
                    this.$targetType.element = dasType;
                }
                return dasType == null;
            }
        });
        if (targetType.element != null) {
            Object object = targetType.element;
            Intrinsics.checkNotNull((Object)object);
            return (DasType)object;
        }
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
            return (DasType)sqlTableType;
        }
        if (StringUtil.isNotEmpty((String)name) && DbImplUtilCore.isTypeKind((ObjectKind)kind)) {
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            DataType dataType = DataTypeFactory.of((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            return DasUnresolvedTypeReference.Companion.of(dataType);
        }
        return (DasType)DasTypeSystemBase.UNKNOWN;
    }

    private static final SqlLanguageDialectEx sqlDialect_delegate$lambda$0(Dbms $dbms) {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((Dbms)$dbms);
        Intrinsics.checkNotNull((Object)sqlLanguageDialect, (String)"null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialectEx");
        return (SqlLanguageDialectEx)sqlLanguageDialect;
    }
}

