/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.Symbol;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.core.TaskSymbol;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskAutoCompletionListProvider
extends TextFieldWithAutoCompletionListProvider<Task> {
    private final Project myProject;

    public TaskAutoCompletionListProvider(Project project) {
        super(null);
        this.myProject = project;
    }

    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        if (shortcut == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(0);
        }
        return "task description and comments";
    }

    @NotNull
    public List<Task> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        List<Task> list = TaskSearchSupport.getItems(TaskManager.getManager((Project)this.myProject), prefix, cached, parameters.isAutoPopup()).stream().sorted(Comparator.comparingInt(t -> {
            TaskState selector0$temp = t.getState();
            int index$1 = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"IN_PROGRESS", "REOPENED", "SUBMITTED", "OPEN", "OTHER"}, (TaskState)selector0$temp, index$1)) {
                case 0 -> 0;
                case 1 -> 1;
                case 2, 3 -> 2;
                case 4 -> 3;
                default -> 4;
            };
        })).toList();
        if (list == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setItems(@Nullable Collection variants) {
    }

    @NotNull
    public LookupElementBuilder createLookupBuilder(@NotNull Task task2) {
        if (task2 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(2);
        }
        LookupElementBuilder builder = LookupElementBuilder.createWithSymbolPointer((String)this.getLookupString(task2), (Symbol)new TaskSymbol(task2)).withIcon(task2.getIcon()).withInsertHandler(this.createInsertHandler(task2)).withTailText(" " + task2.getSummary(), true).withLookupString(task2.getSummary());
        if (task2.isClosed()) {
            builder = builder.strikeout();
        }
        LookupElementBuilder lookupElementBuilder = builder;
        if (lookupElementBuilder == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(3);
        }
        return lookupElementBuilder;
    }

    protected InsertHandler<LookupElement> createInsertHandler(final @NotNull Task task2) {
        if (task2 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(4);
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                Document document = context.getEditor().getDocument();
                String s = ((TaskManagerImpl)TaskManager.getManager((Project)context.getProject())).getChangelistName(task2);
                s = StringUtil.convertLineSeparators((String)s);
                document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)s);
                context.getEditor().getCaretModel().moveToOffset(context.getStartOffset() + s.length());
                TaskAutoCompletionListProvider.this.handleInsert(task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/tasks/actions/TaskAutoCompletionListProvider$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void handleInsert(@NotNull Task task2) {
        if (task2 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    protected String getLookupString(@NotNull Task task2) {
        if (task2 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(6);
        }
        String string = task2.getPresentableId();
        if (string == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    public int compare(@NotNull Task task1, @NotNull Task task2) {
        if (task1 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(8);
        }
        if (task2 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/actions/TaskAutoCompletionListProvider";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/actions/TaskAutoCompletionListProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocHotKeyAdvertisementTail";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLookupBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInsertHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLookupString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7 -> new IllegalStateException(string);
        };
    }
}

