/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.runtime.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.runtime.JSDetectableRuntimeType;
import com.intellij.javascript.runtime.JSRuntimeProvider;
import com.intellij.javascript.runtime.JSRuntimeType;
import com.intellij.javascript.runtime.settings.JSRuntimeConfigurationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0002J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/runtime/settings/JSRuntimeConfiguration;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentRuntimeType", "Lcom/intellij/javascript/runtime/JSRuntimeType;", "listeners", "", "Lcom/intellij/javascript/runtime/settings/JSRuntimeConfigurationListener;", "value", "runtimeType", "getRuntimeType", "()Lcom/intellij/javascript/runtime/JSRuntimeType;", "setRuntimeType", "(Lcom/intellij/javascript/runtime/JSRuntimeType;)V", "getOrDetectRuntimeType", "storeRuntimeType", "", "detectRuntimeType", "detectRuntimeType$intellij_javascript_backend", "addListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Companion", "intellij.javascript.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJSRuntimeConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSRuntimeConfiguration.kt\ncom/intellij/javascript/runtime/settings/JSRuntimeConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n19#3:97\n19#3:98\n812#4,12:99\n1915#4,2:111\n*S KotlinDebug\n*F\n+ 1 JSRuntimeConfiguration.kt\ncom/intellij/javascript/runtime/settings/JSRuntimeConfiguration\n*L\n56#1:97\n57#1:98\n62#1:99,12\n62#1:111,2\n*E\n"})
public final class JSRuntimeConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile JSRuntimeType currentRuntimeType;
    @NotNull
    private final List<JSRuntimeConfigurationListener> listeners;

    public JSRuntimeConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Nullable
    public final JSRuntimeType getRuntimeType() {
        return this.getOrDetectRuntimeType();
    }

    public final void setRuntimeType(@Nullable JSRuntimeType value) {
        this.storeRuntimeType(value);
    }

    private final JSRuntimeType getOrDetectRuntimeType() {
        JSRuntimeType jSRuntimeType = this.currentRuntimeType;
        if (jSRuntimeType != null) {
            JSRuntimeType it = jSRuntimeType;
            boolean bl = false;
            return it;
        }
        String string = PropertiesComponent.getInstance((Project)this.project).getValue("javascript.preferred.runtime.type.id");
        if (string != null) {
            String runtimeTypeId = string;
            boolean bl = false;
            JSRuntimeType jSRuntimeType2 = JSRuntimeProvider.Companion.findRuntimeType$intellij_javascript_backend(runtimeTypeId);
            if (jSRuntimeType2 != null) {
                JSRuntimeType it = jSRuntimeType2;
                boolean bl2 = false;
                return it;
            }
        }
        if (this.project.isDefault()) {
            return null;
        }
        JSRuntimeType detectedRuntimeType = this.detectRuntimeType$intellij_javascript_backend();
        if (!NpmManager.isDetectionTemporary(this.project)) {
            this.storeRuntimeType(detectedRuntimeType);
        }
        return detectedRuntimeType;
    }

    private final void storeRuntimeType(JSRuntimeType runtimeType) {
        block5: {
            JSRuntimeType prevRuntimeType = this.currentRuntimeType;
            this.currentRuntimeType = runtimeType;
            JSRuntimeType jSRuntimeType = runtimeType;
            PropertiesComponent.getInstance((Project)this.project).setValue("javascript.preferred.runtime.type.id", jSRuntimeType != null ? jSRuntimeType.getId() : null);
            if (runtimeType == null || Intrinsics.areEqual((Object)runtimeType, (Object)prevRuntimeType)) break block5;
            for (JSRuntimeConfigurationListener listener2 : this.listeners) {
                listener2.onConfigured(this.project, runtimeType);
            }
            JSRuntimeType $this$asSafely$iv = runtimeType;
            boolean $i$f$asSafely = false;
            JSRuntimeType jSRuntimeType2 = $this$asSafely$iv;
            if (!(jSRuntimeType2 instanceof JSRuntimeConfigurationListener)) {
                jSRuntimeType2 = null;
            }
            JSRuntimeConfigurationListener jSRuntimeConfigurationListener = (JSRuntimeConfigurationListener)((Object)jSRuntimeType2);
            if (jSRuntimeConfigurationListener != null) {
                jSRuntimeConfigurationListener.onConfigured(this.project, runtimeType);
            }
            $this$asSafely$iv = prevRuntimeType;
            $i$f$asSafely = false;
            JSRuntimeType jSRuntimeType3 = $this$asSafely$iv;
            if (!(jSRuntimeType3 instanceof JSRuntimeConfigurationListener)) {
                jSRuntimeType3 = null;
            }
            JSRuntimeConfigurationListener jSRuntimeConfigurationListener2 = (JSRuntimeConfigurationListener)((Object)jSRuntimeType3);
            if (jSRuntimeConfigurationListener2 != null) {
                jSRuntimeConfigurationListener2.onConfigured(this.project, runtimeType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JSRuntimeType detectRuntimeType$intellij_javascript_backend() {
        JSRuntimeType jSRuntimeType;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = JSRuntimeProvider.Companion.listRuntimes$intellij_javascript_backend();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JSDetectableRuntimeType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JSDetectableRuntimeType it = (JSDetectableRuntimeType)element$iv;
            boolean bl = false;
            if (!it.detect(this.project)) continue;
            return it;
        }
        NodePackageRef nodePackageRef = NpmManager.getInstance(this.project).detectPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"detectPackageRef(...)");
        NodePackageRef packageRef = nodePackageRef;
        if (NpmUtil.isBunPackageRef(packageRef) && (jSRuntimeType = JSRuntimeProvider.Companion.findRuntimeType$intellij_javascript_backend("bun")) != null) {
            JSRuntimeType it = jSRuntimeType;
            boolean bl = false;
            return it;
        }
        return JSRuntimeProvider.Companion.findRuntimeType$intellij_javascript_backend("node");
    }

    public final void addListener(@NotNull Disposable parentDisposable, @NotNull JSRuntimeConfigurationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> JSRuntimeConfiguration.addListener$lambda$0(this, listener2));
    }

    private static final void addListener$lambda$0(JSRuntimeConfiguration this$0, JSRuntimeConfigurationListener $listener) {
        this$0.listeners.remove($listener);
    }

    @JvmStatic
    @NotNull
    public static final JSRuntimeConfiguration getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/runtime/settings/JSRuntimeConfiguration$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/javascript/runtime/settings/JSRuntimeConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nJSRuntimeConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSRuntimeConfiguration.kt\ncom/intellij/javascript/runtime/settings/JSRuntimeConfiguration$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,95:1\n30#2,2:96\n*S KotlinDebug\n*F\n+ 1 JSRuntimeConfiguration.kt\ncom/intellij/javascript/runtime/settings/JSRuntimeConfiguration$Companion\n*L\n85#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSRuntimeConfiguration getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JSRuntimeConfiguration> serviceClass$iv = JSRuntimeConfiguration.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JSRuntimeConfiguration)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

