/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.runtime.settings;

import com.intellij.javascript.nodejs.settings.NodeSettingsView;
import com.intellij.javascript.runtime.JSRuntimeProvider;
import com.intellij.javascript.runtime.JSRuntimeType;
import com.intellij.javascript.runtime.settings.JSRuntimeConfiguration;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/runtime/settings/JavaScriptRuntimeConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "runtimeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/javascript/runtime/JSRuntimeType;", "JSRuntimeItem", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJavaScriptRuntimeConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptRuntimeConfigurable.kt\ncom/intellij/javascript/runtime/settings/JavaScriptRuntimeConfigurable\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,131:1\n37#2,2:132\n1642#3,10:134\n1915#3:144\n1916#3:146\n1652#3:147\n1#4:145\n13#5:148\n*S KotlinDebug\n*F\n+ 1 JavaScriptRuntimeConfigurable.kt\ncom/intellij/javascript/runtime/settings/JavaScriptRuntimeConfigurable\n*L\n86#1:132,2\n42#1:134,10\n42#1:144\n42#1:146\n42#1:147\n42#1:145\n57#1:148\n*E\n"})
public final class JavaScriptRuntimeConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;

    public JavaScriptRuntimeConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = JavaScriptBundle.message((String)"settings.javascript.runtime.configurable.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "reference.settings.javascript.runtime", "settings.javascript.runtime");
        this.project = project;
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> JavaScriptRuntimeConfigurable.createPanel$lambda$0(this, arg_0));
    }

    private final ComboBox<JSRuntimeType> runtimeComboBox() {
        Collection $this$toTypedArray$iv = JSRuntimeProvider.Companion.listRuntimes$intellij_javascript_backend();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ComboBox comboBox = new ComboBox((Object[])thisCollection$iv.toArray(new JSRuntimeType[0]));
        JSRuntimeType detectedRuntimeType = JSRuntimeConfiguration.Companion.getInstance(this.project).detectRuntimeType$intellij_javascript_backend();
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JSRuntimeType>(detectedRuntimeType){
            final /* synthetic */ JSRuntimeType $detectedRuntimeType;
            {
                this.$detectedRuntimeType = $detectedRuntimeType;
            }

            protected void customizeCellRenderer(JList<? extends JSRuntimeType> list, JSRuntimeType value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                if (value == null) {
                    SimpleColoredComponent simpleColoredComponent = this.append(JavaScriptBundle.message((String)"settings.javascript.runtime.preferred.runtime.unavailable.text", (Object[])new Object[0]));
                    Intrinsics.checkNotNull((Object)simpleColoredComponent);
                } else {
                    this.append(value.getDisplayName());
                    if (Intrinsics.areEqual((Object)value, (Object)this.$detectedRuntimeType)) {
                        this.append("  " + JavaScriptBundle.message((String)"settings.javascript.runtime.preferred.runtime.auto-detected.text", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        });
        return comboBox;
    }

    private static final Unit createPanel$lambda$0$3$0$0(JSRuntimeItem $item) {
        $item.getConfigurable().reset();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0$1(JSRuntimeItem $item) {
        $item.getConfigurable().apply();
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$3$0$2(JSRuntimeItem $item) {
        return $item.getConfigurable().isModified();
    }

    private static final Unit createPanel$lambda$0$3$0(JSRuntimeItem $item, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($item.getComponent()).resizableColumn().align((Align)AlignX.FILL.INSTANCE).onReset(() -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$3$0$0($item)).onApply(() -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$3$0$1($item)).onIsModified(() -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$3$0$2($item));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(JavaScriptRuntimeConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JSRuntimeConfiguration configuration = JSRuntimeConfiguration.Companion.getInstance(this$0.project);
        Cell cell = ComboBoxKt.bindItem((Cell)$this$row.cell((JComponent)this$0.runtimeComboBox()), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(configuration){

            public Object get() {
                return ((JSRuntimeConfiguration)this.receiver).getRuntimeType();
            }

            public void set(Object value) {
                ((JSRuntimeConfiguration)this.receiver).setRuntimeType((JSRuntimeType)value);
            }
        }));
        String string = JavaScriptBundle.message((String)"settings.javascript.runtime.preferred.runtime.context.help.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.contextHelp$default((Cell)cell, (String)string, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(JSRuntimeItem $item, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$3$0($item, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$0$4(JSRuntimeItem $item) {
        $item.getConfigurable().disposeUIResources();
    }

    private static final Unit createPanel$lambda$0(JavaScriptRuntimeConfigurable this$0, Panel $this$panel) {
        NodeSettingsView.PackageManagerFieldFactory packageManagerFieldFactory;
        List items;
        block7: {
            NodeSettingsView.PackageManagerFieldFactory packageManagerFieldFactory2;
            Iterator $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = JavaScriptBundle.message((String)"settings.javascript.runtime.preferred.runtime.label.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$0(this$0, arg_0));
            Iterable $this$mapNotNull$iv = JSRuntimeProvider.Companion.listRuntimeProviders$intellij_javascript_backend();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JSRuntimeItem jSRuntimeItem;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JSRuntimeProvider provider = (JSRuntimeProvider)element$iv$iv;
                boolean bl2 = false;
                Configurable configurable = provider.createSettingsConfigurable(this$0.project);
                if (configurable.createComponent() != null) {
                    JComponent it;
                    boolean bl3 = false;
                    jSRuntimeItem = new JSRuntimeItem(provider.getRuntimeType(), configurable, it);
                } else {
                    jSRuntimeItem = null;
                }
                if (jSRuntimeItem == null) continue;
                JSRuntimeItem it$iv$iv = jSRuntimeItem;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            items = (List)destination$iv$iv;
            for (JSRuntimeItem it : (Iterable)items) {
                boolean bl = false;
                NodeSettingsView.PackageManagerFieldFactory packageManagerFieldFactory3 = (NodeSettingsView.PackageManagerFieldFactory)ClientProperty.get((Component)it.getComponent(), NodeSettingsView.Companion.getPACKAGE_MANAGER_FACTORY_KEY$intellij_javascript_backend());
                if (packageManagerFieldFactory3 == null) continue;
                packageManagerFieldFactory2 = packageManagerFieldFactory3;
                break block7;
            }
            packageManagerFieldFactory2 = packageManagerFieldFactory = null;
        }
        if (packageManagerFieldFactory != null) {
            packageManagerFieldFactory.create($this$panel);
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JavaScriptRuntimeConfigurable.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot find package manager field factory. Runtime providers: " + JSRuntimeProvider.Companion.listRuntimeProviders$intellij_javascript_backend());
        }
        for (JSRuntimeItem item : items) {
            Panel.group$default((Panel)$this$panel, (String)item.getRuntimeType().getDisplayName(), (boolean)false, arg_0 -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$3(item, arg_0), (int)2, null);
            Disposable disposable = this$0.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.register((Disposable)disposable, () -> JavaScriptRuntimeConfigurable.createPanel$lambda$0$4(item));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/runtime/settings/JavaScriptRuntimeConfigurable$JSRuntimeItem;", "", "runtimeType", "Lcom/intellij/javascript/runtime/JSRuntimeType;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/javascript/runtime/JSRuntimeType;Lcom/intellij/openapi/options/Configurable;Ljavax/swing/JComponent;)V", "getRuntimeType", "()Lcom/intellij/javascript/runtime/JSRuntimeType;", "getConfigurable", "()Lcom/intellij/openapi/options/Configurable;", "getComponent", "()Ljavax/swing/JComponent;", "intellij.javascript.backend"})
    private static final class JSRuntimeItem {
        @NotNull
        private final JSRuntimeType runtimeType;
        @NotNull
        private final Configurable configurable;
        @NotNull
        private final JComponent component;

        public JSRuntimeItem(@NotNull JSRuntimeType runtimeType, @NotNull Configurable configurable, @NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)runtimeType, (String)"runtimeType");
            Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.runtimeType = runtimeType;
            this.configurable = configurable;
            this.component = component;
        }

        @NotNull
        public final JSRuntimeType getRuntimeType() {
            return this.runtimeType;
        }

        @NotNull
        public final Configurable getConfigurable() {
            return this.configurable;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }
    }
}

