/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.typeEngine;

import com.intellij.javascript.typeEngine.JSToTSTypeConverterKt;
import com.intellij.javascript.types.TSType;
import com.intellij.javascript.types.impl.TSAnyTypeImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSServicePoweredTypeEngineEvaluator;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/typeEngine/JSTypeEngineUtils;", "", "<init>", "()V", "getTSType", "Lcom/intellij/javascript/types/TSType;", "element", "Lcom/intellij/psi/PsiElement;", "getContextualTSType", "expression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "isForCompletion", "", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSTypeEngineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTypeEngineUtils.kt\ncom/intellij/javascript/typeEngine/JSTypeEngineUtils\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,36:1\n30#2,2:37\n*S KotlinDebug\n*F\n+ 1 JSTypeEngineUtils.kt\ncom/intellij/javascript/typeEngine/JSTypeEngineUtils\n*L\n28#1:37,2\n*E\n"})
public final class JSTypeEngineUtils {
    @NotNull
    public static final JSTypeEngineUtils INSTANCE = new JSTypeEngineUtils();

    private JSTypeEngineUtils() {
    }

    @Nullable
    public final TSType getTSType(@NotNull PsiElement element2) {
        TSType fromService;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        TSType tSType = fromService = JSServicePoweredTypeEngineEvaluator.INSTANCE.getTSTypeFromService(element2);
        if (tSType != null) {
            return tSType;
        }
        JSType builtInEngineType = JSResolveUtil.getBuiltInEngineType((PsiElement)element2, (boolean)false);
        if (builtInEngineType != null && !builtInEngineType.isSourceStrict()) {
            return (TSType)TSAnyTypeImpl.INSTANCE;
        }
        JSType jSType = builtInEngineType;
        return jSType != null ? JSToTSTypeConverterKt.toTSType((JSType)jSType) : null;
    }

    @Nullable
    public final TSType getContextualTSType(@NotNull JSExpression expression, boolean isForCompletion) {
        JSType builtInEngineType;
        TSType fromService;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<TypeScriptCompilerEvaluationFacade> serviceClass$iv = TypeScriptCompilerEvaluationFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        TypeScriptCompilerEvaluationFacade instance = (TypeScriptCompilerEvaluationFacade)object;
        TSType tSType = fromService = instance.getContextualTSTypeFromService(expression, isForCompletion);
        if (tSType != null) {
            return tSType;
        }
        JSExpectedTypeKind expectedTypeKind = isForCompletion ? JSExpectedTypeKind.EXPECTED : JSExpectedTypeKind.CONTEXTUAL;
        JSType jSType = builtInEngineType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)expression, (JSExpectedTypeKind)expectedTypeKind);
        return jSType != null ? JSToTSTypeConverterKt.toTSType((JSType)jSType) : null;
    }
}

