/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNodeModulesHandlerScope
extends DelegatingGlobalSearchScope {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Set<String> myModules;
    @NotNull
    private final Set<String> myExcludedPackages;
    @NotNull
    private final VirtualFile myContextFile;
    @Nullable
    protected final JSModuleStatusOwner.ModuleStatus myStatus;
    @NotNull
    protected final NodeModulesDirectoryManager myNodeModulesDirectoryManager;
    @NotNull
    protected final JSMonorepoManager myMonorepoManager;
    protected final Set<VirtualFile> myContainingFiles;
    protected final Set<VirtualFile> myExcludedFiles;

    public JSNodeModulesHandlerScope(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull GlobalSearchScope baseScope, @Nullable JSModuleStatusOwner.ModuleStatus status) {
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(1);
        }
        if (baseScope == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(2);
        }
        super(baseScope);
        this.myContainingFiles = VfsUtilCore.createCompactVirtualFileSet();
        this.myExcludedFiles = VfsUtilCore.createCompactVirtualFileSet();
        this.myProject = project;
        this.myModules = JSNodeModulesHandlerScope.getAcceptableModules(project, contextFile);
        this.myExcludedPackages = JSNodeModulesHandlerScope.getExcludedModules(this.myModules);
        this.myContextFile = contextFile;
        this.myStatus = status;
        this.myExcludedFiles.addAll(TypeScriptLibraryProvider.getAllLibraries((Project)project));
        this.myNodeModulesDirectoryManager = NodeModulesDirectoryManager.getInstance(project);
        this.myMonorepoManager = JSMonorepoManager.getInstance(project);
    }

    public final boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(3);
        }
        if (this.myContainingFiles.contains(file)) {
            return true;
        }
        if (this.myExcludedFiles.contains(file)) {
            return false;
        }
        boolean result2 = this.containsWithoutCache(file);
        if (result2) {
            this.myContainingFiles.add(file);
        } else {
            this.myExcludedFiles.add(file);
        }
        return result2;
    }

    private boolean containsWithoutCache(@NotNull VirtualFile file) {
        if (file == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(4);
        }
        if (!super.contains(file)) {
            return false;
        }
        JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(this.myProject, file);
        return structure == null ? this.isAcceptableProjectFile(file) : this.isAcceptableNodeModulesFile(file, structure);
    }

    protected boolean isAcceptableProjectFile(@NotNull VirtualFile toCheck) {
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected boolean isAcceptableNodeModulesFile(@NotNull VirtualFile toCheck, @NotNull JSNodeModuleStructure structure) {
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(6);
        }
        if (structure == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(7);
        }
        return this.isAcceptableNodeModulesStructure(structure);
    }

    private boolean isAcceptableNodeModulesStructure(@NotNull JSNodeModuleStructure structure) {
        if (structure == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(8);
        }
        String packageName = structure.getPackageName();
        if (structure.isFromTypes() && !this.myModules.contains(packageName) && !this.myModules.contains(structure.getOriginalPackageName())) {
            return false;
        }
        return (this.myModules.contains(packageName) || this.myModules.contains(structure.getOriginalPackageName())) && !this.myExcludedPackages.contains(packageName);
    }

    protected boolean isSymlinkedNodeModule(@NotNull VirtualFile toCheck, @Nullable JSConfig config) {
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(9);
        }
        if (!this.myMonorepoManager.isWorkspaceMonorepo()) {
            return false;
        }
        if (config == null || !config.isNodeResolution()) {
            return false;
        }
        VirtualFile symlinkedFile = this.myNodeModulesDirectoryManager.getSymlinkSourceDependencyFile(toCheck, this.myContextFile);
        JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(this.myProject, symlinkedFile);
        return structure != null && this.isAcceptableNodeModulesStructure(structure);
    }

    private static Set<String> getExcludedModules(@NotNull Set<String> moduleNames) {
        if (moduleNames == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(10);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String name : moduleNames) {
            if (!name.startsWith("@types/")) continue;
            String realName = ES6CreateImportUtil.convertScopedTypesName(name.substring("@types/".length()));
            toRemove.add(realName);
        }
        return toRemove;
    }

    @Nullable
    public static VirtualFile findNearestPackageJson(@NotNull Project project, @NotNull VirtualFile contextFile) {
        Set<VirtualFile> packageJsonFiles;
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(11);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(12);
        }
        if ((packageJsonFiles = JSNodeModulesHandlerScope.getPackageJsonFilesFromParentDirs(project, contextFile)).isEmpty()) {
            return null;
        }
        VirtualFile nearest = null;
        for (VirtualFile file : packageJsonFiles) {
            if (nearest != null && !VfsUtilCore.isAncestor((VirtualFile)nearest.getParent(), (VirtualFile)file.getParent(), (boolean)true)) continue;
            nearest = file;
        }
        return nearest;
    }

    @NotNull
    private static Set<VirtualFile> getPackageJsonFilesFromParentDirs(@NotNull Project project, @NotNull VirtualFile contextFile) {
        PackageJsonFileManager manager;
        Set<VirtualFile> files;
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(13);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(14);
        }
        if ((files = (manager = PackageJsonFileManager.getInstance(project)).getValidPackageJsonFiles()).isEmpty()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                JSNodeModulesHandlerScope.$$$reportNull$$$0(15);
            }
            return set;
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            VirtualFile directory = file.getParent();
            if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)contextFile, (boolean)true)) continue;
            result2.add(file);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    public static Set<String> getAcceptableModules(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(17);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(18);
        }
        HashSet<String> moduleNames = new HashSet<String>();
        Set<VirtualFile> packageJsonFiles = JSNodeModulesHandlerScope.getPackageJsonFilesFromParentDirs(project, contextFile);
        for (VirtualFile file : packageJsonFiles) {
            PackageJsonData data2 = PackageJsonData.getOrCreate(file);
            moduleNames.addAll(data2.getAllDependencies());
        }
        HashSet<String> hashSet = moduleNames;
        if (hashSet == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSNodeModulesHandlerScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSNodeModulesHandlerScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonFilesFromParentDirs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsWithoutCache";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableProjectFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesStructure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSymlinkedNodeModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedModules";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNearestPackageJson";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonFilesFromParentDirs";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptableModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

