/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowPanel;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtReloadTasksAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public final class JsbtToolWindowManager {
    private final Project myProject;
    private final String myToolWindowId;
    private final Icon myToolWindowIcon;
    private final String myHelpId;
    private final JsbtService myService;
    private ToolWindow myToolWindow;

    public JsbtToolWindowManager(@NotNull Project project, @NotNull String toolWindowId, @NotNull Icon toolWindowIcon, @NotNull String helpId, @NotNull JsbtService service) {
        if (project == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(0);
        }
        if (toolWindowId == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(1);
        }
        if (toolWindowIcon == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(2);
        }
        if (helpId == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(3);
        }
        if (service == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myToolWindowId = toolWindowId;
        this.myToolWindowIcon = toolWindowIcon;
        this.myHelpId = helpId;
        this.myService = service;
    }

    public void setAvailable() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myToolWindow != null) {
            return;
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(this.myToolWindowId, builder2 -> {
            builder2.anchor = ToolWindowAnchor.LEFT;
            builder2.contentFactory = new ToolWindowFactory(){

                public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (toolWindow == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    JsbtToolWindowManager.this.doCreateToolWindowContent(toolWindow);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "toolWindow";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$1";
                    objectArray[2] = "createToolWindowContent";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            builder2.sideTool = true;
            builder2.icon = this.myToolWindowIcon;
            return Unit.INSTANCE;
        });
        this.myToolWindow.setAvailable(true);
    }

    private void doCreateToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(5);
        }
        JsbtTaskTreeView taskTreeView = this.myService.createTaskTreeView(null);
        this.setupToolWindowEx((ToolWindowEx)toolWindow, taskTreeView);
        taskTreeView.init();
        JsbtToolWindowPanel panel2 = new JsbtToolWindowPanel(taskTreeView, this.myHelpId);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)((Object)panel2), "", true);
        Disposer.register((Disposable)content, (Disposable)taskTreeView);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(panel2.getPreferredFocusedComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
    }

    private void setupToolWindowEx(@NotNull ToolWindowEx toolWindow, @NotNull JsbtTaskTreeView taskTreeView) {
        AnAction[] titleActions;
        if (toolWindow == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(6);
        }
        if (taskTreeView == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(7);
        }
        for (AnAction action : titleActions = new AnAction[]{new JsbtAddBuildfileAction(this.myService.getApplicationService()), new JsbtRemoveBuildfileAction(this.myService.getApplicationService(), taskTreeView), new JsbtReloadTasksAction(taskTreeView), JsbtToolWindowManager.createCollapseAllAction(taskTreeView)}) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            action.registerCustomShortcutSet(shortcutSet, (JComponent)taskTreeView.getComponent());
        }
        toolWindow.setTitleActions(List.of(titleActions));
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new ShowSettingsAction()});
        DefaultActionGroup sortActionGroup = new DefaultActionGroup(JavaScriptBundle.message((String)"buildTools.tree.sortBy.text", (Object[])new Object[0]), true);
        sortActionGroup.add((AnAction)new ToggleSortingModeAction(JsbtSortingMode.DEFINITION_ORDER, taskTreeView));
        sortActionGroup.add((AnAction)new ToggleSortingModeAction(JsbtSortingMode.NAME, taskTreeView));
        actionGroup.add((AnAction)sortActionGroup);
        actionGroup.add((AnAction)new WideScreenToolWindowLayout());
        toolWindow.setAdditionalGearActions((ActionGroup)actionGroup);
    }

    @NotNull
    private static AnAction createCollapseAllAction(@NotNull JsbtTaskTreeView taskTreeView) {
        if (taskTreeView == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(8);
        }
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new DefaultTreeExpander(taskTreeView::getComponent), (JComponent)taskTreeView.getComponent());
        collapseAllAction.getTemplatePresentation().setIcon(AllIcons.Actions.Collapseall);
        collapseAllAction.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.Collapseall);
        AnAction anAction = collapseAllAction;
        if (anAction == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(9);
        }
        return anAction;
    }

    public void show(boolean alsoActivate) {
        this.setAvailable();
        this.myToolWindow.show(null);
        if (alsoActivate && !this.myToolWindow.isActive()) {
            this.myToolWindow.activate(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowIcon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskTreeView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAllAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateToolWindowContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindowEx";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCollapseAllAction";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private class ShowSettingsAction
    extends DumbAwareAction {
        ShowSettingsAction() {
            super(JsbtToolWindowManager.this.myService.getApplicationService().getToolWindowSettingsActionName(), null, JsbtToolWindowManager.this.myService.getApplicationService().getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettingsAction.$$$reportNull$$$0(0);
            }
            JsbtToolWindowManager.this.myService.showTaskListingSettingsDialog(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$ShowSettingsAction", "actionPerformed"));
        }
    }

    private static class ToggleSortingModeAction
    extends ToggleAction
    implements DumbAware {
        private final JsbtSortingMode mySortingMode;
        private final JsbtTaskTreeView myTaskTreeView;

        ToggleSortingModeAction(@NotNull JsbtSortingMode sortingMode, @NotNull JsbtTaskTreeView taskTreeView) {
            if (sortingMode == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(0);
            }
            if (taskTreeView == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(1);
            }
            super(sortingMode.getDisplayName());
            this.mySortingMode = sortingMode;
            this.myTaskTreeView = taskTreeView;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(3);
            }
            return this.myTaskTreeView.getSortingMode() == this.mySortingMode;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(4);
            }
            this.myTaskTreeView.setSortingMode(this.mySortingMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortingMode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskTreeView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$ToggleSortingModeAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$ToggleSortingModeAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class WideScreenToolWindowLayout
    extends ToggleAction
    implements DumbAware {
        WideScreenToolWindowLayout() {
            super(IdeBundle.messagePointer((String)"checkbox.widescreen.tool.window.layout", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                WideScreenToolWindowLayout.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                WideScreenToolWindowLayout.$$$reportNull$$$0(1);
            }
            return UISettings.getInstance().getWideScreenSupport();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            UISettings uiSettings;
            boolean prev;
            if (e == null) {
                WideScreenToolWindowLayout.$$$reportNull$$$0(2);
            }
            if ((prev = (uiSettings = UISettings.getInstance()).getWideScreenSupport()) != state) {
                uiSettings.setWideScreenSupport(state);
                uiSettings.fireUISettingsChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$WideScreenToolWindowLayout";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$WideScreenToolWindowLayout";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

