/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/documentation/JSClassHighlightingHelper;", "", "<init>", "()V", "getExtendsImplementsPlaceholder", "Lcom/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$TextPlaceholder;", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "packageName", "", "includeObjectInExtendsList", "", "getReferenceType", "reference", "Lcom/intellij/lang/javascript/psi/ecmal4/JSReferenceListMember;", "context", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSClassHighlightingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSClassHighlightingHelper.kt\ncom/intellij/lang/javascript/documentation/JSClassHighlightingHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class JSClassHighlightingHelper {
    @NotNull
    public static final JSClassHighlightingHelper INSTANCE = new JSClassHighlightingHelper();

    private JSClassHighlightingHelper() {
    }

    @JvmStatic
    @NotNull
    public static final JSHtmlHighlightingUtil.TextPlaceholder getExtendsImplementsPlaceholder(@NotNull JSClass jsClass, @NotNull String packageName, boolean includeObjectInExtendsList) {
        String implementsList;
        String extendsList;
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        AtomicInteger replacementCounter = new AtomicInteger();
        Map replacements = new LinkedHashMap();
        StringBuilder builder2 = new StringBuilder();
        String string = JSClassHighlightingHelper.getExtendsImplementsPlaceholder$createTypeList(replacementCounter, replacements, jsClass.getExtendsList());
        if (string == null) {
            string = includeObjectInExtendsList && !Intrinsics.areEqual((Object)"Object", (Object)jsClass.getName()) ? "Object" : null;
        }
        if ((extendsList = string) != null) {
            builder2.append(" extends ").append(extendsList);
        }
        if ((implementsList = JSClassHighlightingHelper.getExtendsImplementsPlaceholder$createTypeList(replacementCounter, replacements, jsClass.getImplementsList())) != null) {
            builder2.append("\nimplements ").append(implementsList);
        }
        return new JSHtmlHighlightingUtil.TextPlaceholder(builder2, replacements, packageName, jsClass){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ Map<String, JSReferenceListMember> $replacements;
            final /* synthetic */ String $packageName;
            final /* synthetic */ JSClass $jsClass;
            {
                this.$builder = $builder;
                this.$replacements = $replacements;
                this.$packageName = $packageName;
                this.$jsClass = $jsClass;
            }

            public CharSequence getHolderText() {
                String string = this.$builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            public CharSequence restoreText(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                String result2 = ((Object)text).toString();
                for (Map.Entry<String, JSReferenceListMember> entry : this.$replacements.entrySet()) {
                    String placeholder = entry.getKey();
                    JSReferenceListMember reference = entry.getValue();
                    String typeLink = JSClassHighlightingHelper.access$getReferenceType(JSClassHighlightingHelper.INSTANCE, reference, this.$packageName, (PsiElement)this.$jsClass);
                    result2 = StringsKt.replaceFirst((String)result2, (String)placeholder, (String)typeLink, (boolean)false);
                }
                return result2;
            }
        };
    }

    private final String getReferenceType(JSReferenceListMember reference, String packageName, PsiElement context2) {
        Collection collection = reference.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getClasses(...)");
        JSClass jsClass = (JSClass)CollectionsKt.singleOrNull((Iterable)collection);
        if (jsClass != null) {
            String string = JSHtmlHighlightingUtil.getSimpleTypeWithLinkText(jsClass.getJSType(), false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleTypeWithLinkText(...)");
            return string;
        }
        String string = reference.getReferenceText();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String referenceText = string;
        String string3 = JSImportHandlingUtil.resolveTypeName((String)referenceText, (PsiElement)context2);
        if (string3 == null) {
            return referenceText;
        }
        String typeName = string3;
        return Intrinsics.areEqual((Object)StringUtil.getPackageName((String)typeName), (Object)packageName) ? StringsKt.substringAfterLast$default((String)typeName, (char)'.', null, (int)2, null) : typeName;
    }

    private static final boolean getExtendsImplementsPlaceholder$createTypeList$lambda$0(JSReferenceListMember it) {
        return it.getReferenceText() != null;
    }

    private static final CharSequence getExtendsImplementsPlaceholder$createTypeList$lambda$1(AtomicInteger $replacementCounter, Map $replacements, JSReferenceListMember reference) {
        String replacement = "$$Type$$Unique" + $replacementCounter.incrementAndGet();
        $replacements.put(replacement, reference);
        return replacement;
    }

    private static final String getExtendsImplementsPlaceholder$createTypeList(AtomicInteger replacementCounter, Map<String, JSReferenceListMember> replacements, JSReferenceList referenceList) {
        CharSequence charSequence;
        if (referenceList == null) {
            return null;
        }
        JSReferenceListMember[] jSReferenceListMemberArray = referenceList.getMembers();
        Intrinsics.checkNotNullExpressionValue((Object)jSReferenceListMemberArray, (String)"getMembers(...)");
        CharSequence charSequence2 = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])jSReferenceListMemberArray), JSClassHighlightingHelper::getExtendsImplementsPlaceholder$createTypeList$lambda$0), (CharSequence)", ", null, null, (int)0, null, arg_0 -> JSClassHighlightingHelper.getExtendsImplementsPlaceholder$createTypeList$lambda$1(replacementCounter, replacements, arg_0), (int)30, null);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public static final /* synthetic */ String access$getReferenceType(JSClassHighlightingHelper $this, JSReferenceListMember reference, String packageName, PsiElement context2) {
        return $this.getReferenceType(reference, packageName, context2);
    }
}

