/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TypeScriptReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(Holder.DECLARE_MODULE, new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element2, JSLiteralExpression.class);
                PsiReference[] psiReferenceArray = JSModuleReferenceContributor.getReferencesForStringLiteral((JSLiteralExpression)literalExpression, (PsiReferenceProvider)this);
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiComment().withElementType(JSTokenTypes.END_OF_LINE_COMMENT)).and((ElementPattern)new FilterPattern(new ElementFilter(this){

            public boolean isAcceptable(Object element2, PsiElement context2) {
                PsiElement psiElement = (PsiElement)element2;
                if (!DialectDetector.isTypeScript((PsiElement)psiElement)) {
                    return false;
                }
                String text = psiElement.getText();
                return TypeScriptPsiUtil.TYPESCRIPT_REFERENCE_PATH.matcher(text).matches();
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                PsiComment comment = (PsiComment)ObjectUtils.tryCast((Object)psiElement, PsiComment.class);
                Matcher matcher = TypeScriptPsiUtil.TYPESCRIPT_REFERENCE_PATH.matcher(psiElement.getText());
                if (comment != null && matcher.find()) {
                    VirtualFile libFile;
                    String fileName = TypeScriptPsiUtil.getPathText((Matcher)matcher);
                    if (fileName == null) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    boolean isTypes = "types".equals(matcher.group(1));
                    if (isTypes) {
                        PsiReference[] psiReferenceArray = JSModuleReferenceContributor.getReferences((String)fileName, (PsiElement)comment, (int)matcher.start(3), null);
                        if (psiReferenceArray == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return psiReferenceArray;
                    }
                    if ("lib".equals(matcher.group(1)) && (libFile = TypeScriptLibraryProvider.getService((Project)psiElement.getProject()).findLibraryByShortName(matcher.group(3))) != null) {
                        TextRange range = TextRange.create((int)matcher.start(3), (int)matcher.end(3));
                        PsiReference[] psiReferenceArray = new PsiReference[]{new JSExactFileReference(this, psiElement, range, Collections.singleton(libFile.getPath()), ArrayUtilRt.EMPTY_STRING_ARRAY){

                            @Override
                            @Nullable
                            protected VirtualFile findFileByPath(@NotNull String path2) {
                                if (path2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (path2.equals(libFile.getPath())) {
                                    return libFile;
                                }
                                return super.findFileByPath(path2);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2$1", "findFileByPath"));
                            }
                        }};
                        if (psiReferenceArray == null) {
                            2.$$$reportNull$$$0(4);
                        }
                        return psiReferenceArray;
                    }
                    FileReference[] fileReferenceArray = new FileReferenceSetWithDefaultContext(fileName, (PsiElement)comment, matcher.start(3), this).getAllReferences();
                    if (fileReferenceArray == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(6);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Nullable
    public static String findReferencePath(@NotNull PsiComment comment) {
        Matcher matcher;
        if (comment == null) {
            TypeScriptReferenceContributor.$$$reportNull$$$0(1);
        }
        if (comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && (matcher = TypeScriptPsiUtil.TYPESCRIPT_REFERENCE_PATH.matcher(comment.getText())).matches()) {
            return TypeScriptPsiUtil.getPathText((Matcher)matcher);
        }
        return null;
    }

    @Nullable
    public static PsiFile findReferencedFile(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptReferenceContributor.$$$reportNull$$$0(2);
        }
        if (TypeScriptReferenceContributor.findReferencePath(comment) == null) {
            return null;
        }
        PsiReference[] references = comment.getReferences();
        if (references.length == 0 || !(references[references.length - 1] instanceof JSFileReference)) {
            return null;
        }
        PsiElement resolve = references[references.length - 1].resolve();
        return resolve instanceof PsiFile ? (PsiFile)resolve : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final ElementPattern<JSLiteralExpression> DECLARE_MODULE = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withParent(TypeScriptModule.class)).with((PatternCondition)new PatternCondition<JSLiteralExpression>("TypeScript.declare.augmentation"){

            public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context2) {
                PsiElement parent;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parent = expression.getParent()) instanceof TypeScriptModule)) {
                    return false;
                }
                return ((TypeScriptModule)parent).getNameIdentifier() == expression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$Holder$1", "accepts"));
            }
        });

        private Holder() {
        }
    }

    public static class FileReferenceSetWithDefaultContext
    extends FileReferenceSet {
        public FileReferenceSetWithDefaultContext(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider) {
            if (str == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(1);
            }
            super(str, element2, startInElement, provider, false, false, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        }

        public boolean isAbsolutePathReference() {
            if (super.isAbsolutePathReference()) {
                return true;
            }
            String path2 = this.getPathString();
            return FileUtil.isAbsolute((String)path2);
        }

        protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
            if (sequence == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(2);
            }
            return StringUtil.indexOfAny((CharSequence)sequence, (String)"\\/", (int)startingFrom, (int)sequence.length());
        }

        protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
            char c;
            if (sequence == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(3);
            }
            return (c = sequence.charAt(atOffset)) == '\\' || c == '/' ? 1 : 0;
        }

        public FileReference createFileReference(TextRange textRange, int i, String text) {
            return new JSFileReference(this, text, i, textRange, this){

                @Override
                @NotNull
                public @NotNull String @NotNull [] getImplicitExtensions() {
                    if (TypeScriptUtil.TYPESCRIPT_EXTENSIONS == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return TypeScriptUtil.TYPESCRIPT_EXTENSIONS;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext$1", "getImplicitExtensions"));
                }
            };
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            PsiDirectory directory;
            PsiFile file = this.getContainingFile();
            if (file == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    FileReferenceSetWithDefaultContext.$$$reportNull$$$0(4);
                }
                return list;
            }
            if (this.isAbsolutePathReference()) {
                Collection fileSystemRoots = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable)FileReferenceSetWithDefaultContext.getAbsoluteTopLevelDirLocations((PsiFile)file), (Iterable)fileSystemRoots));
                if (arrayList == null) {
                    FileReferenceSetWithDefaultContext.$$$reportNull$$$0(5);
                }
                return arrayList;
            }
            VirtualFile parent = file.getViewProvider().getVirtualFile().getParent();
            if (parent != null && (directory = file.getManager().findDirectory(parent)) != null) {
                Set<PsiDirectory> set = Collections.singleton(directory);
                if (set == null) {
                    FileReferenceSetWithDefaultContext.$$$reportNull$$$0(6);
                }
                return set;
            }
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeDefaultContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findSeparatorOffset";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findSeparatorLength";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

