/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.SemVer;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlowJSServerService {
    protected static final long COMPLETION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    protected static final long TYPEOF_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    protected static final long DEFINITION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    @NotNull
    protected final FlowJSConfig myConfig;
    @NotNull
    protected final Project myProject;

    public FlowJSServerService(@NotNull FlowJSConfig config, @NotNull Project project) {
        if (config == null) {
            FlowJSServerService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(1);
        }
        this.myConfig = config;
        this.myProject = project;
    }

    @Nullable
    public abstract PsiElement getDefinitionOfElement(@NotNull Document var1, @NotNull PsiElement var2);

    @Nullable
    protected PsiElement getElementByPosition(@NotNull VirtualFile virtualFile, int line, int column) {
        PsiFile psiFile;
        if (virtualFile == null) {
            FlowJSServerService.$$$reportNull$$$0(2);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) == null) {
            return null;
        }
        if (line == -1) {
            return psiFile;
        }
        FileViewProvider provider = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile);
        if (provider == null) {
            return null;
        }
        Document document = provider.getDocument();
        if (document == null) {
            return null;
        }
        int offset = document.getLineStartOffset(line) + column;
        PsiElement elementAtOffset = psiFile.findElementAt(offset);
        if (elementAtOffset == null) {
            return null;
        }
        PsiElement meaningfulElement = PsiTreeUtil.findFirstParent((PsiElement)elementAtOffset, (boolean)false, t -> t instanceof JSVarStatement || t instanceof PsiNamedElement);
        if (meaningfulElement instanceof JSVarStatement) {
            JSInitializerOwner declaration = (JSInitializerOwner)ArrayUtil.getFirstElement((Object[])((JSVarStatement)meaningfulElement).getDeclarations());
            return declaration != null ? declaration : meaningfulElement;
        }
        return meaningfulElement != null ? meaningfulElement : elementAtOffset;
    }

    @Nullable
    @NlsSafe
    public String getTypeOfElementUnderProgress(@NotNull JSElement element2) {
        if (element2 == null) {
            FlowJSServerService.$$$reportNull$$$0(3);
        }
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                return (String)ReadAction.compute(() -> this.getTypeOfElement(element2));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, JavaScriptBundle.message((String)"flow.js.get.type", (Object[])new Object[0]), true, element2.getProject());
    }

    @Nullable
    protected abstract String getTypeOfElement(@NotNull JSElement var1);

    @NotNull
    public static List<FlowJSSettings.FlowJSExecutable> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList<FlowJSSettings.FlowJSExecutable> paths = new ArrayList<FlowJSSettings.FlowJSExecutable>();
        ArrayList infos = new ArrayList();
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        NodeModuleSearchUtil.findModulesWithName(infos, "flow-bin", project.getBaseDir(), interpreter2);
        for (CompletionModuleInfo info : infos) {
            VirtualFile moduleDir = info.getVirtualFile();
            if (moduleDir == null) continue;
            File moduleFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleDir);
            paths.add(new FlowJSSettings.FlowJSExecutable(moduleFile));
        }
        if (paths.isEmpty()) {
            String execFileName = FlowJSServerService.getFlowExecutableFilename();
            List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)execFileName);
            for (File file : files) {
                paths.add(new FlowJSSettings.FlowJSExecutable(file));
            }
        }
        ArrayList<FlowJSSettings.FlowJSExecutable> arrayList = paths;
        if (arrayList == null) {
            FlowJSServerService.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    static String getFlowExecutableFilename() {
        return SystemInfo.isWindows ? "flow.exe" : "flow";
    }

    @Nullable
    public static String isFlowServerAvailable(@Nullable FlowJSSettings.FlowJSExecutable flowJSExecutable, @NotNull Project project) {
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(5);
        }
        if (flowJSExecutable == null) {
            return JavaScriptBundle.message((String)"js.flow.enable.flow.service.error.empty", (Object[])new Object[0]);
        }
        CompletableFuture<String> future = flowJSExecutable.evaluateVersion(project);
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return JavaScriptBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Process doesn't respond"});
        }
        catch (ExecutionException e) {
            return e.getCause().getMessage();
        }
        catch (InterruptedException e) {
            return JavaScriptBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Checking interrupted"});
        }
        return null;
    }

    @NotNull
    public static SemVer getFlowVersion(@NotNull Project project) throws Exception {
        FlowJSSettings.FlowJSExecutable executable;
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(6);
        }
        if ((executable = FlowJSSettingsManager.getInstance(project).getRawSettings().getFlowExecutable()) == null) {
            throw new IllegalStateException("Flow executable is not set");
        }
        CompletableFuture<String> future = executable.evaluateVersion(project);
        String versionText = future.get(5L, TimeUnit.SECONDS);
        SemVer semVer = SemVer.parseFromText((String)versionText);
        if (semVer == null) {
            throw new Exception("Invalid version " + versionText);
        }
        SemVer semVer2 = semVer;
        if (semVer2 == null) {
            FlowJSServerService.$$$reportNull$$$0(7);
        }
        return semVer2;
    }

    @NotNull
    public abstract Map<String, String> getCompletionOfElement(@NotNull PsiFile var1, @NotNull Document var2, @NotNull CompletionParameters var3, @NotNull String var4);

    @NotNull
    public FlowJSConfig getConfig() {
        FlowJSConfig flowJSConfig = this.myConfig;
        if (flowJSConfig == null) {
            FlowJSServerService.$$$reportNull$$$0(8);
        }
        return flowJSConfig;
    }

    @Nullable
    public static String getTypeIfServiceEnabled(@NotNull PsiElement element2) {
        String typeFromService;
        PsiFile file;
        FlowJSServerService service;
        if (element2 == null) {
            FlowJSServerService.$$$reportNull$$$0(9);
        }
        if ((element2 instanceof JSReferenceExpression || element2 instanceof JSNamedElement) && (service = FlowJSServerManager.getService(file = element2.getContainingFile())) != null && FlowJSSettingsManager.areOtherServicesEnabled(file) && (typeFromService = service.getTypeOfElement((JSElement)element2)) != null) {
            return XmlUtil.escape((String)typeFromService);
        }
        return null;
    }

    public boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(10);
        }
        return !LightEdit.owns((Project)this.myProject) && FlowJSServerService.isAcceptableFile(file, it -> DialectDetector.JAVASCRIPT_FILE_TYPES.contains(it.getFileType()));
    }

    public static boolean isAcceptableFile(@Nullable VirtualFile virtualFile, @NotNull Predicate<VirtualFile> fileTypeChecker) {
        if (fileTypeChecker == null) {
            FlowJSServerService.$$$reportNull$$$0(11);
        }
        return virtualFile != null && virtualFile.isInLocalFileSystem() && virtualFile.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER) == null && fileTypeChecker.test(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPossibleFlowExecutableFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementByPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfElementUnderProgress";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFlowServerAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFlowVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfServiceEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

