/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRendererKt;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.JSImportAllQuickFix;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0001\u001a \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a2\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a2\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a+\u0010\u0016\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0001H\u0002\u00a8\u0006\u0019"}, d2={"showImportHint", "", "name", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "elementText", "severalCandidates", "createAction", "Lcom/intellij/lang/javascript/modules/imports/JSImportAction;", "showHint", "", "createImportAllAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "importAll", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "showSimpleHint", "range", "Lcom/intellij/openapi/util/TextRange;", "action", "getHintMessage", "Lcom/intellij/openapi/util/NlsContexts$HintText;", "allShortcut", "intellij.javascript.backend"})
public final class JSImportHintKt {
    public static final boolean showImportHint(@NotNull String name, @Nullable PsiElement element2, @NotNull Editor editor, @Nullable String elementText, boolean severalCandidates) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (name.length() <= 1) {
            return false;
        }
        if (element2 == null || elementText == null || Intrinsics.areEqual((Object)true, (Object)element2.getUserData(JSImportAction.NO_HINT_KEY))) {
            return false;
        }
        JSImportHintKt.showHint(name, element2, editor, elementText, severalCandidates);
        return true;
    }

    private static final JSImportAction createAction(String name, PsiElement element2, Editor editor) {
        return new JSImportAction(editor, element2, name);
    }

    private static final void showHint(String name, PsiElement element2, Editor editor, String elementText, boolean severalCandidates) {
        TextRange textRange = InjectedLanguageManager.getInstance((Project)element2.getProject()).injectedToHost(element2, element2.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"injectedToHost(...)");
        TextRange range = textRange;
        JSImportAction action = JSImportHintKt.createAction(name, element2, editor);
        CustomShortcutSet importAllShortcutSet = DaemonTooltipWithActionRendererKt.getRunActionCustomShortcutSet();
        String string = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)((ShortcutSet)importAllShortcutSet));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String allShortcutText = string;
        if (StringUtil.isEmptyOrSpaces((String)allShortcutText)) {
            JSImportHintKt.showSimpleHint(editor, range, action, elementText, severalCandidates);
            return;
        }
        String string2 = JSImportHintKt.getHintMessage(allShortcutText, elementText, severalCandidates);
        if (string2 == null) {
            return;
        }
        String message = string2;
        JComponent label = HintUtil.createQuestionLabel((String)message, (Icon)AllIcons.General.ContextHelp);
        AnAction anAction = JSImportHintKt.createImportAllAction(name, editor, element2, importAllShortcutSet);
        LightweightHint hint2 = new LightweightHint(label, anAction, editor){
            final /* synthetic */ AnAction $anAction;
            final /* synthetic */ Editor $editor;
            {
                this.$anAction = $anAction;
                this.$editor = $editor;
                super($label);
            }

            public void hide() {
                this.$anAction.unregisterCustomShortcutSet(this.$editor.getContentComponent());
                super.hide();
            }
        };
        HintManagerImpl.getInstanceImpl().showQuestionHint(editor, range.getStartOffset(), range.getEndOffset(), hint2, (QuestionAction)action, (short)1);
    }

    private static final AnAction createImportAllAction(String name, Editor editor, PsiElement element2, CustomShortcutSet importAll) {
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return new AnAction(importAll, editor, project2, name, element2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $name;
            final /* synthetic */ PsiElement $element;
            {
                this.$project = $project;
                this.$name = $name;
                this.$element = $element;
                this.registerCustomShortcutSet((ShortcutSet)$importAll, $editor.getContentComponent());
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$project.isDisposed()) {
                    return;
                }
                JSImportAllQuickFix fix = new JSImportAllQuickFix(this.$name, this.$element);
                PsiElement startElement = this.$element;
                if (!startElement.isValid()) {
                    return;
                }
                PsiFile containingFile = startElement.getContainingFile();
                fix.invoke(this.$project, containingFile, startElement, startElement);
            }
        };
    }

    private static final void showSimpleHint(Editor editor, TextRange range, JSImportAction action, String elementText, boolean severalCandidates) {
        String string = JSImportHintKt.getHintMessage(null, elementText, severalCandidates);
        if (string == null) {
            return;
        }
        String message = string;
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)action);
    }

    private static final String getHintMessage(String allShortcut, String elementText, boolean severalCandidates) {
        String string;
        String suffix;
        Object[] objectArray;
        if (elementText == null) {
            return null;
        }
        String string2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcutText(...)");
        String importShortcut = string2;
        if (StringUtil.isEmptyOrSpaces((String)allShortcut)) {
            v1 = "";
        } else {
            objectArray = new Object[]{allShortcut};
            v1 = suffix = " " + JavaScriptBundle.message((String)"ts.add.import.hint.all.part", (Object[])objectArray);
        }
        if (severalCandidates) {
            objectArray = new Object[]{elementText, importShortcut};
            string = "&nbsp;" + JavaScriptBundle.message((String)"ts.add.import.hint.multiple.text", (Object[])objectArray) + suffix;
        } else {
            objectArray = new Object[]{elementText, importShortcut};
            string = "&nbsp;" + JavaScriptBundle.message((String)"ts.add.import.hint.text", (Object[])objectArray) + suffix;
        }
        return string;
    }
}

