/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/patterns/CssColorUtil;", "", "<init>", "()V", "IS_COLOR_LIKE", "Lkotlin/text/Regex;", "isCssColorLike", "", "str", "", "intellij.javascript.backend"})
public final class CssColorUtil {
    @NotNull
    public static final CssColorUtil INSTANCE = new CssColorUtil();
    @NotNull
    private static final Regex IS_COLOR_LIKE = new Regex("(#[a-f0-9]{3})|(#[a-f0-9]{6})|(#[a-f0-9]{8})|((rgb|rgba|hsl|hsla|hwb|lab|lch|oklab|oklch)\\([a-f0-9\\-%,.\\s/]+\\))", RegexOption.IGNORE_CASE);

    private CssColorUtil() {
    }

    @JvmStatic
    public static final boolean isCssColorLike(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (((CharSequence)str).length() == 0) {
            return false;
        }
        if (str.length() > 30) {
            return false;
        }
        CharSequence charSequence = str;
        return IS_COLOR_LIKE.matches(charSequence);
    }
}

