/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsState;
import com.intellij.lang.typescript.compiler.TypeScriptEngineWidgetPopupService;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.experiment.ab.impl.ABExperimentOption;
import com.intellij.ui.LicensingFacade;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"isServicePoweredTypeEngineEnabledByExperiment", "", "isNonCommercialLicense", "isLicenseSuitableForExperiment", "licensingFacade", "Lcom/intellij/ui/LicensingFacade;", "SPTE_WAS_ENABLED_BY_EXPERIMENT_KEY", "", "wasServicePoweredTypeEngineEnabledByExperiment", "project", "Lcom/intellij/openapi/project/Project;", "recordServicePoweredTypesUsage", "", "intellij.javascript.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServicePoweredTypeEngineExperiment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServicePoweredTypeEngineExperiment.kt\ncom/intellij/lang/typescript/compiler/TypeScriptServicePoweredTypeEngineExperimentKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n30#2,2:74\n*S KotlinDebug\n*F\n+ 1 TypeScriptServicePoweredTypeEngineExperiment.kt\ncom/intellij/lang/typescript/compiler/TypeScriptServicePoweredTypeEngineExperimentKt\n*L\n66#1:74,2\n*E\n"})
public final class TypeScriptServicePoweredTypeEngineExperimentKt {
    @NotNull
    private static final String SPTE_WAS_ENABLED_BY_EXPERIMENT_KEY = "javascript.spte.engine.was.enabled.by.experiment";

    public static final boolean isServicePoweredTypeEngineEnabledByExperiment() {
        if (!ABExperimentOption.TYPESCRIPT_SERVICE_TYPES.isEnabled()) {
            return false;
        }
        return ApplicationInfo.getInstance().isEAP() || TypeScriptServicePoweredTypeEngineExperimentKt.isNonCommercialLicense();
    }

    private static final boolean isNonCommercialLicense() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        return licensingFacade != null && TypeScriptServicePoweredTypeEngineExperimentKt.isLicenseSuitableForExperiment(licensingFacade);
    }

    private static final boolean isLicenseSuitableForExperiment(LicensingFacade licensingFacade) {
        String metadata = licensingFacade.metadata;
        return metadata != null && metadata.length() > 10 && metadata.charAt(10) == 'F';
    }

    public static final boolean wasServicePoweredTypeEngineEnabledByExperiment(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PropertiesComponent.getInstance().getBoolean(SPTE_WAS_ENABLED_BY_EXPERIMENT_KEY) || ((TypeScriptCompilerSettingsState)TypeScriptCompilerSettings.Companion.getSettings(project).getState()).getUseServicePoweredTypesWasEnabledByExperiment();
    }

    public static final void recordServicePoweredTypesUsage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!PropertiesComponent.getInstance().getBoolean(SPTE_WAS_ENABLED_BY_EXPERIMENT_KEY) && TypeScriptServicePoweredTypeEngineExperimentKt.isServicePoweredTypeEngineEnabledByExperiment()) {
            PropertiesComponent.getInstance().setValue(SPTE_WAS_ENABLED_BY_EXPERIMENT_KEY, true);
            if (!ApplicationInfo.getInstance().isEAP() && !InitialConfigImportState.isNewUser() && TypeScriptCompilerSettings.Companion.getSettings(project).getUseServicePoweredTypesManualOverride() == null) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<TypeScriptEngineWidgetPopupService> serviceClass$iv = TypeScriptEngineWidgetPopupService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((TypeScriptEngineWidgetPopupService)object).showTooltip();
            }
        }
        if (!((TypeScriptCompilerSettingsState)TypeScriptCompilerSettings.Companion.getSettings(project).getState()).getUseServicePoweredTypesWasEnabledByExperiment() && PropertiesComponent.getInstance().getBoolean(SPTE_WAS_ENABLED_BY_EXPERIMENT_KEY)) {
            ((TypeScriptCompilerSettingsState)TypeScriptCompilerSettings.Companion.getSettings(project).getState()).setUseServicePoweredTypesWasEnabledByExperiment(true);
        }
    }
}

