/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.frameworks;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.frameworks.DownloadableTypeScriptServicePlugin;
import com.intellij.lang.typescript.compiler.languageService.frameworks.PluggableTypeScriptServiceProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/frameworks/PluggableTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "servicePlugin", "Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;)V", "getServicePlugin", "()Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;", "isDisabledByContext", "", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "ensureServiceAvailable", "createProtocol", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol;", "tsServicePath", "", "intellij.javascript.backend"})
@ApiStatus.Experimental
public abstract class PluggableTypeScriptService
extends TypeScriptServerServiceImpl {
    @NotNull
    private final DownloadableTypeScriptServicePlugin servicePlugin;

    public PluggableTypeScriptService(@NotNull Project project, @NotNull DownloadableTypeScriptServicePlugin servicePlugin) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)servicePlugin, (String)"servicePlugin");
        super(project, servicePlugin.getPackageName());
        this.servicePlugin = servicePlugin;
    }

    @NotNull
    protected final DownloadableTypeScriptServicePlugin getServicePlugin() {
        return this.servicePlugin;
    }

    @Override
    public final boolean isDisabledByContext(@NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (super.isDisabledByContext(context2)) {
            return true;
        }
        return !this.servicePlugin.getActivationRule().isEnabled(this.getProject(), context2);
    }

    @Override
    public final boolean ensureServiceAvailable() {
        return this.servicePlugin.getActivationRule().isAvailable(this.getProject());
    }

    @Override
    @NotNull
    protected TypeScriptServiceStandardOutputProtocol createProtocol(@NotNull String tsServicePath) {
        Intrinsics.checkNotNullParameter((Object)tsServicePath, (String)"tsServicePath");
        return new PluggableTypeScriptServiceProtocol(this.getProject(), this.mySettings, this.createEventConsumer(), this.getServiceName(), tsServicePath, this.servicePlugin);
    }
}

