/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"getLibraryCandidate", "Lcom/intellij/lang/typescript/library/TypeScriptLibraries;", "project", "Lcom/intellij/openapi/project/Project;", "defaultLibraries", "intellij.javascript.backend"})
public final class TypeScriptLibraryKt {
    @NotNull
    public static final TypeScriptLibraries getLibraryCandidate(@NotNull Project project, @NotNull TypeScriptLibraries defaultLibraries) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)defaultLibraries, (String)"defaultLibraries");
        if (project.isDefault() || project.isDisposed()) {
            return defaultLibraries;
        }
        try {
            TypeScriptLibraries result2 = (TypeScriptLibraries)RecursionManager.doPreventingRecursion((Object)"ts.loading.libraries", (boolean)false, () -> TypeScriptLibraryKt.getLibraryCandidate$lambda$0(project, defaultLibraries));
            if (result2 == null) {
                Logger.getInstance(TypeScriptLibraryProvider.class).error("Infinite recursion in typescript #getLibraryCandidate");
                return defaultLibraries;
            }
            return result2;
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                throw ex;
            }
            Logger.getInstance(TypeScriptLibraryProvider.class).error("Error while processing typescript external libraries", (Throwable)ex);
            return new TypeScriptLibraries();
        }
    }

    private static final TypeScriptLibraries getLibraryCandidate$lambda$0(Project $project, TypeScriptLibraries $defaultLibraries) {
        TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService($project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptServiceDirectoryWatcher, (String)"getService(...)");
        TypeScriptServiceDirectoryWatcher watcher2 = typeScriptServiceDirectoryWatcher;
        String servicePath = watcher2.getCachedCustomServiceDirectory();
        CharSequence charSequence = servicePath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)servicePath, (Object)watcher2.getDefaultServicePath())) {
            return $defaultLibraries;
        }
        VirtualFile libDirectory = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (libDirectory = VirtualFileManager.getInstance().findFileByUrl(servicePath)) != null && libDirectory.isValid()) {
            return new TypeScriptLibraries(null, libDirectory, false);
        }
        File file = new File(servicePath);
        if (!file.exists() || !new File(file, "lib.d.ts").exists()) {
            return $defaultLibraries;
        }
        libDirectory = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (libDirectory == null || !libDirectory.isValid()) {
            return $defaultLibraries;
        }
        return new TypeScriptLibraries(file, null, false);
    }
}

