/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptRestartLanguageServiceWidgetAction;
import com.intellij.lang.typescript.compiler.ui.TypeScriptConfigurable;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServerDescriptor;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspService;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServiceKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.OpenSettingsAction;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import icons.JavaScriptCoreIcons;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoLspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "()V", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "intellij.javascript.backend"})
public final class TypeScriptGoLspServerSupportProvider
implements LspServerSupportProvider {
    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        if (TypeScriptGoLspServiceKt.getTsGoLSPService(project).isAcceptable(file)) {
            serverStarter.ensureServerStarted((LspServerDescriptor)new TypeScriptGoLspServerDescriptor(project));
        }
    }

    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Icon icon = JavaScriptLanguageIcons.Typescript.TypeScriptStatusBar;
        Class<TypeScriptConfigurable> clazz = TypeScriptConfigurable.class;
        return new LspServerWidgetItem(lspServer, currentFile, icon, clazz){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($lspServer, $currentFile, $super_call_param$1, $super_call_param$2);
            }

            protected AnAction createWidgetMainAction() {
                String string = this.getServerLabel();
                Icon icon = JavaScriptCoreIcons.FileTypes.TypeScriptFile;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TypeScriptFile");
                return (AnAction)new OpenSettingsAction(TypeScriptConfigurable.class, string, icon);
            }

            protected AnAction createStopOrRestartAction() {
                String string = JavaScriptBundle.message((String)"typescript.go.name", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return new TypeScriptRestartLanguageServiceWidgetAction(string, TypeScriptGoLspService.class);
            }
        };
    }
}

