/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.browser;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.system.OS;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\b\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenLinkScriptHolder;", "", "<init>", "()V", "browserScript", "Ljava/util/Optional;", "Ljava/nio/file/Path;", "overrideEnv", "", "env", "", "", "initScript", "createScriptFile", "generateScriptBody", "Companion", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostOpenLinkScriptHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostOpenLinkScriptHolder.kt\ncom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenLinkScriptHolder\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n30#2,2:102\n13#3:104\n13#3:105\n*S KotlinDebug\n*F\n+ 1 UnattendedHostOpenLinkScriptHolder.kt\ncom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenLinkScriptHolder\n*L\n37#1:102,2\n65#1:104\n68#1:105\n*E\n"})
public final class UnattendedHostOpenLinkScriptHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Optional<Path> browserScript;
    @NotNull
    private static final String BROWSER_ENV = "BROWSER";

    public final void overrideEnv(@NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        if (!Registry.Companion.is("rdct.override.browser.env", true)) {
            return;
        }
        if (!AppMode.isRemoteDevHost()) {
            return;
        }
        if (OS.CURRENT != OS.Linux && OS.CURRENT != OS.FreeBSD) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<UnattendedHostOpenLinkScriptHolder> serviceClass$iv = UnattendedHostOpenLinkScriptHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Path browserScript = ((UnattendedHostOpenLinkScriptHolder)object).initScript();
        if (browserScript == null) {
            return;
        }
        String browserScriptPath = ((Object)browserScript).toString();
        String oldValue = env.get(BROWSER_ENV);
        env.put(BROWSER_ENV, (String)(oldValue == null ? browserScriptPath : browserScriptPath + ":" + oldValue));
    }

    @Nullable
    public final synchronized Path initScript() {
        Optional<Path> scriptPath;
        Optional<Path> optional = scriptPath = this.browserScript;
        if (optional != null) {
            return (Path)OptionalsKt.getOrNull(optional);
        }
        try {
            Path newScript = this.createScriptFile();
            this.browserScript = Optional.of(newScript);
            return newScript;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            if (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UnattendedHostOpenLinkScriptHolder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cannot create browser script file");
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UnattendedHostOpenLinkScriptHolder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot create browser script file", e);
            }
            this.browserScript = Optional.empty();
            return null;
        }
    }

    private final Path createScriptFile() {
        String body = this.generateScriptBody();
        Path scriptPath = PathManager.getTempDir().resolve("remote-dev-browser.sh");
        Intrinsics.checkNotNull((Object)scriptPath);
        PathsKt.writeText$default((Path)scriptPath, (CharSequence)body, null, (OpenOption[])new OpenOption[0], (int)2, null);
        NioFiles.setExecutable((Path)scriptPath);
        return scriptPath;
    }

    private final String generateScriptBody() {
        String productName = ApplicationInfo.getInstance().getFullApplicationName();
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        Path launcherPath = PathManager.getBinDir().resolve(scriptName).toAbsolutePath();
        String launcherPathString = ((Object)launcherPath).toString();
        if (Files.notExists(launcherPath, new LinkOption[0])) {
            throw new IOException("File not found: " + launcherPathString);
        }
        return StringsKt.trimIndent((String)("\n      #!/bin/sh\n      # ------------------------------------------------------\n      # " + productName + " Remote Development browser script.\n      # ------------------------------------------------------\n\n      exec \"" + launcherPathString + "\" openUrlOnClient \"$@\"\n      \n    "));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenLinkScriptHolder$Companion;", "", "<init>", "()V", "BROWSER_ENV", "", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

