/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.managed.cache.backend;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.managed.cache.CacheId;
import com.intellij.platform.managed.cache.RemoteManagedCacheBuildParams;
import com.intellij.platform.managed.cache.backend.RemoteManagedCacheApiImplKt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.cache.ManagedCache;
import com.intellij.util.io.cache.ManagedCacheFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0012\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00140\u0013j\u0002`\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\b\u001a3\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/managed/cache/backend/RemoteManagedCacheManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "storage", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/util/io/cache/ManagedCache;", "", "get", "cacheId", "Lcom/intellij/platform/managed/cache/CacheId;", "create", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/Pair;", "Lcom/intellij/platform/managed/cache/backend/EntriesFlow;", "buildParams", "Lcom/intellij/platform/managed/cache/RemoteManagedCacheBuildParams;", "(Lcom/intellij/platform/managed/cache/CacheId;Lcom/intellij/platform/managed/cache/RemoteManagedCacheBuildParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Externalizer", "MyKeyDescriptor", "intellij.platform.managed.cache.backend"})
@SourceDebugExtension(value={"SMAP\nRemoteManagedCacheApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteManagedCacheApiImpl.kt\ncom/intellij/platform/managed/cache/backend/RemoteManagedCacheManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
final class RemoteManagedCacheManager {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentMap<String, ManagedCache<byte[], byte[]>> storage;

    public RemoteManagedCacheManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.storage = concurrentMap;
    }

    @NotNull
    public final ManagedCache<byte[], byte[]> get(@NotNull CacheId cacheId) {
        Intrinsics.checkNotNullParameter((Object)cacheId, (String)"cacheId");
        Object v = this.storage.get(cacheId.getName());
        Intrinsics.checkNotNull(v);
        return (ManagedCache)v;
    }

    @Nullable
    public final Object create(@NotNull CacheId cacheId, @NotNull RemoteManagedCacheBuildParams buildParams, @NotNull Continuation<? super Flow<Pair<byte[], byte[]>>> $completion) {
        ManagedCache managedCache = (ManagedCache)this.storage.get(cacheId.getName());
        if (managedCache == null) {
            ManagedCache managedCache2;
            ManagedCache it = managedCache2 = ManagedCacheFactory.Companion.getInstance().createCache(this.project, RemoteManagedCacheApiImplKt.access$remoteCacheLocation(), cacheId.getName(), (KeyDescriptor)new MyKeyDescriptor(), (DataExternalizer)new Externalizer(), buildParams.getSerdeVersion(), this.coroutineScope);
            boolean bl = false;
            ((Map)this.storage).put(cacheId.getName(), it);
            managedCache = managedCache2;
        }
        ManagedCache cache2 = managedCache;
        return cache2.entries($completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/managed/cache/backend/RemoteManagedCacheManager$Externalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "<init>", "()V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "in", "Ljava/io/DataInput;", "intellij.platform.managed.cache.backend"})
    private static class Externalizer
    implements DataExternalizer<byte[]> {
        public void save(@NotNull DataOutput out, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.writeInt(value.length);
            out.write(value);
        }

        @NotNull
        public byte[] read(@NotNull DataInput in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int dataSize = in.readInt();
            byte[] data = new byte[dataSize];
            in.readFully(data);
            return data;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/managed/cache/backend/RemoteManagedCacheManager$MyKeyDescriptor;", "Lcom/intellij/platform/managed/cache/backend/RemoteManagedCacheManager$Externalizer;", "Lcom/intellij/util/io/KeyDescriptor;", "", "<init>", "()V", "getHashCode", "", "value", "isEqual", "", "val1", "val2", "intellij.platform.managed.cache.backend"})
    private static final class MyKeyDescriptor
    extends Externalizer
    implements KeyDescriptor<byte[]> {
        public int getHashCode(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Arrays.hashCode(value);
        }

        public boolean isEqual(@Nullable byte[] val1, @Nullable byte[] val2) {
            return val1 != null ? Arrays.equals(val1, val2) : val2 == null;
        }
    }
}

