/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.SpringBootFileIcons;
import com.intellij.spring.boot.SpringBootIconService;
import com.intellij.spring.boot.SpringBootIconServiceImplKt;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.application.SpringBootMainUtil;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SpringBootIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            SpringBootIconProvider.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)element.getProject())) {
            return SpringBootIconProvider.getIconInDumbMode(element, flags);
        }
        return SpringBootIconProvider.getIconInSmartMode(element, flags);
    }

    @Nullable
    private static Icon getIconInSmartMode(@NotNull PsiElement element, int flags) {
        if (element == null) {
            SpringBootIconProvider.$$$reportNull$$$0(1);
        }
        if (SpringBootIconProvider.isInstanceInSpringProject(PropertyImpl.class, element)) {
            PropertyImpl property = (PropertyImpl)element;
            if (SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(property.getContainingFile())) {
                ASTNode keyNode = property.getKeyNode();
                if (keyNode == null) {
                    return null;
                }
                MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyNode.getPsi());
                if (configKey != null) {
                    return configKey.getPresentation().getIcon();
                }
            }
            return null;
        }
        if (SpringBootIconProvider.isInstanceInSpringProject(PropertiesFile.class, element)) {
            return SpringBootConfigurationFileService.getInstance().getApplicationConfigurationFileIcon(((PropertiesFile)element).getContainingFile());
        }
        if (element instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)element;
            if ("JSON".equals(element.getLanguage().getID()) && SpringBootAdditionalConfigUtils.isAdditionalMetadataFile((PsiFile)psiFile) && SpringBootLibraryUtil.hasSpringBootLibrary((Project)element.getProject())) {
                return SpringBootFileIcons.ADDITIONAL_JSON_ICON;
            }
        }
        if (SpringBootIconProvider.isInstanceInSpringProject(PsiClass.class, element)) {
            PsiClass psiClass = (PsiClass)element;
            if (SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass) && SpringBootLibraryUtil.hasSpringBootLibrary((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) && SpringBootApplicationService.getInstance().isSpringApplication(psiClass)) {
                return SpringBootIconService.getInstance().getIconWithOverlay(PsiClassImplUtil.getClassIcon((int)flags, (PsiClass)psiClass));
            }
        } else if (element instanceof PsiPlainTextFile && "banner.txt".equals(((PsiPlainTextFile)element).getName()) && SpringBootIconProvider.isInstanceInSpringProject(PsiPlainTextFile.class, element)) {
            return SpringBootFileIcons.BANNER_ICON;
        }
        return null;
    }

    @Nullable
    private static Icon getIconInDumbMode(PsiElement element, int flags) {
        Module module;
        PsiPlainTextFile file;
        if (SpringBootIconProvider.isInstanceInSpringProject(PropertiesFileImpl.class, element)) {
            PropertiesFileImpl file2 = (PropertiesFileImpl)element;
            String fileName = file2.getName();
            if (fileName.startsWith("application-") || fileName.startsWith("application.") || fileName.equals("bootstrap.properties")) {
                Module module2 = DumbAwareLineMarkerUtilsKt.findModuleForFileWhenDumb((PsiFile)file2);
                if (module2 == null || module2.isDisposed() || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module2)) {
                    return null;
                }
                if (fileName.equals("bootstrap.properties")) {
                    return SpringBootApiIcons.SpringCloud;
                }
                return SpringBootApiIcons.SpringBoot;
            }
        } else if (SpringBootIconProvider.isInstanceInSpringProject(PsiClass.class, element)) {
            PsiClass psiClass = (PsiClass)element;
            Module module3 = DumbAwareLineMarkerUtilsKt.findModuleForFileWhenDumb((PsiFile)psiClass.getContainingFile());
            if (module3 == null || module3.isDisposed() || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module3)) {
                return null;
            }
            if (SpringBootIconProvider.isSpringApplication(psiClass)) {
                Icon classIcon = PsiClassImplUtil.getClassIcon((int)flags, (PsiClass)psiClass);
                return SpringBootIconServiceImplKt.getSpringBootIconWithOverlay((Icon)LayeredIcon.layeredIcon((Icon[])new Icon[]{classIcon, AllIcons.Nodes.RunnableMark}));
            }
        } else if (SpringBootIconProvider.isInstanceInSpringProject(PsiPlainTextFile.class, element) && (file = (PsiPlainTextFile)element).getName().equals("banner.txt") && (module = DumbAwareLineMarkerUtilsKt.findModuleForFileWhenDumb((PsiFile)file)) != null && !module.isDisposed() && SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            return SpringBootFileIcons.BANNER_ICON;
        }
        return null;
    }

    private static boolean isInstanceInSpringProject(Class<?> clazz, PsiElement element) {
        return clazz.isInstance(element) && SpringBootLibraryUtil.hasSpringBootLibrary((Project)element.getProject());
    }

    private static boolean isSpringApplication(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBootIconProvider.$$$reportNull$$$0(2);
        }
        return SpringBootMainUtil.isNotPrivateMain((PsiClass)psiClass) && ContainerUtil.exists((Object[])psiClass.getAnnotations(), a -> SpringBootIconProvider.isApplicationAnnotation(a));
    }

    private static boolean isApplicationAnnotation(PsiAnnotation a) {
        PsiJavaCodeReferenceElement nameReferenceElement = a.getNameReferenceElement();
        return nameReferenceElement != null && nameReferenceElement.textMatches((CharSequence)"SpringBootApplication");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/SpringBootIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconInSmartMode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringApplication";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

