/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.CustomContextConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootstrapWithTest
extends CustomContextConfiguration {
    public static final SemKey<SpringBootstrapWithTest> JAM_KEY = CONTEXT_CONFIGURATION_JAM_KEY.subKey("SpringBootstrapWithTest", new SemKey[0]);
    public static final SemKey<JamMemberMeta<PsiClass, SpringBootstrapWithTest>> META_KEY = ContextConfiguration.CONTEXT_CONFIGURATION_META_KEY.subKey("SpringBootstrapWithTest", new SemKey[0]);

    public SpringBootstrapWithTest(String anno, @NotNull PsiClass psiClassAnchor) {
        if (psiClassAnchor == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(0);
        }
        super(anno, PsiElementRef.real((PsiElement)psiClassAnchor));
    }

    @NotNull
    public List<PsiClass> getConfigurationClasses() {
        SmartList psiClasses = new SmartList();
        psiClasses.addAll(this.getBootstrapWithConfigurations());
        for (JamClassAttributeElement jamClassAttributeElement : CLASSES_ATTR_META.getJam(this.myPsiAnnotation)) {
            ContainerUtil.addIfNotNull((Collection)psiClasses, (Object)jamClassAttributeElement.getValue());
        }
        ContainerUtil.addAllNotNull((Collection)psiClasses, SpringBootstrapWithTest.getImportedConfigurations((PsiClass)this.getPsiElement()));
        SmartList smartList = psiClasses;
        if (smartList == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @NotNull
    private static Set<PsiClass> getImportedConfigurations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(2);
        }
        Set set = SpringJamUtils.getInstance().getImportedClasses(psiClass, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
        if (set == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public List<PsiClass> getBootstrapWithConfigurations() {
        String packageName;
        PsiClass psiClass = (PsiClass)this.getPsiElement();
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof PsiClassOwner && (packageName = ((PsiClassOwner)file).getPackageName()) != null) {
            MultiMap<String, PsiClass> map = this.getConfigurationClassesMap(psiClass);
            while (packageName != null) {
                Collection bootstrapWithConfigurations = map.get((Object)packageName);
                if (!bootstrapWithConfigurations.isEmpty()) {
                    return new ArrayList<PsiClass>(bootstrapWithConfigurations);
                }
                packageName = SpringBootstrapWithTest.getParentPackage(packageName);
            }
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private MultiMap<String, PsiClass> getConfigurationClassesMap(@NotNull PsiClass psiClass) {
        Module module;
        if (psiClass == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getPsiElement())) != null) {
            MultiMap multiMap = (MultiMap)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
                GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)true);
                ArrayList<String> fqns = new ArrayList<String>((Collection)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration", (boolean)true).apply(module));
                fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
                MultiMap<String, PsiClass> map = SpringBootstrapWithTest.getConfigurationClasses(module.getProject(), scope, fqns);
                return CachedValueProvider.Result.create(map, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT});
            });
            if (multiMap == null) {
                SpringBootstrapWithTest.$$$reportNull$$$0(6);
            }
            return multiMap;
        }
        Project project = psiClass.getProject();
        MultiMap multiMap = (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            Function customMetaAnnotations = SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration", (boolean)true);
            LinkedHashSet<String> fqns = new LinkedHashSet<String>();
            for (Module eachModule : ModuleManager.getInstance((Project)project).getModules()) {
                fqns.addAll((Collection)customMetaAnnotations.apply(eachModule));
            }
            fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
            MultiMap<String, PsiClass> map = SpringBootstrapWithTest.getConfigurationClasses(project, scope, fqns);
            return CachedValueProvider.Result.create(map, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)project), PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (multiMap == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    private static MultiMap<String, PsiClass> getConfigurationClasses(Project project, GlobalSearchScope scope, Collection<String> fqns) {
        MultiMap map = new MultiMap();
        JamService jamService = JamService.getJamService((Project)project);
        for (String fqn : fqns) {
            List elements = jamService.getJamClassElements(EnableAutoConfiguration.JAM_KEY, fqn, scope);
            for (EnableAutoConfiguration element : elements) {
                String qualifiedName;
                PsiClass aClass = (PsiClass)element.getPsiElement();
                if (aClass.isAnnotationType() || (qualifiedName = aClass.getQualifiedName()) == null) continue;
                map.putValue((Object)StringUtil.getPackageName((String)qualifiedName), (Object)aClass);
            }
        }
        return map;
    }

    @Nullable
    private static String getParentPackage(@NotNull String sourcePackage) {
        if (sourcePackage == null) {
            SpringBootstrapWithTest.$$$reportNull$$$0(8);
        }
        if (sourcePackage.isEmpty()) {
            return null;
        }
        int lastDot = sourcePackage.lastIndexOf(".");
        return lastDot == -1 ? "" : sourcePackage.substring(0, lastDot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassAnchor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootstrapWithConfigurations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImportedConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationClassesMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentPackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

