/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.spi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsFileReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "FilePackageOrClassReference", "intellij.spring.boot.core"})
public final class SpringBootImportsFileReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiFile spiFile = (PsiFile)element;
        String string = FileUtil.getNameWithoutExtension((String)spiFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String text = string;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        new DelimitedListProcessor(references, spiFile){
            final /* synthetic */ ArrayList<PsiReference> $references;
            final /* synthetic */ PsiFile $spiFile;
            {
                this.$references = $references;
                this.$spiFile = $spiFile;
                super(".$");
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                this.$references.add((PsiReference)new FilePackageOrClassReference(this.$spiFile, start, end));
            }
        }.processText(text);
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"toArray(...)");
        return psiReferenceArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsFileReferenceProvider$FilePackageOrClassReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiFile;", "psiFile", "start", "", "end", "<init>", "(Lcom/intellij/psi/PsiFile;II)V", "getCanonicalText", "", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "resolve", "bindToElement", "psiElement", "isReferenceTo", "", "element", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.spring.boot.core"})
    private static final class FilePackageOrClassReference
    extends PsiReferenceBase<PsiFile> {
        @NotNull
        private final PsiFile psiFile;
        private final int start;
        private final int end;

        public FilePackageOrClassReference(@NotNull PsiFile psiFile, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            super((PsiElement)psiFile, new TextRange(0, 0), false);
            this.psiFile = psiFile;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.psiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            int n = 0;
            int n2 = this.end;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return string3;
        }

        @NotNull
        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            TextRange textRange = TextRange.create((int)this.start, (int)this.end);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return this.handleElementRename(newElementName, textRange);
        }

        @Nullable
        public PsiElement resolve() {
            PsiPackage aPackage;
            String text = this.getCanonicalText();
            PsiPackage psiPackage = aPackage = JavaPsiFacade.getInstance((Project)this.psiFile.getProject()).findPackage(text);
            return psiPackage != null ? (PsiElement)psiPackage : (PsiElement)ClassUtil.findPsiClass((PsiManager)this.psiFile.getManager(), (String)text, null, (boolean)true, (GlobalSearchScope)this.psiFile.getResolveScope());
        }

        @NotNull
        public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            if (psiElement instanceof PsiPackage) {
                String string = ((PsiPackage)psiElement).getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
                TextRange textRange = TextRange.create((int)0, (int)this.end);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                return this.handleElementRename(string, textRange);
            }
            if (psiElement instanceof PsiClass) {
                String string = this.psiFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = StringsKt.contains$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null) ? ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiElement)) : ((PsiClass)psiElement).getQualifiedName();
                if (string2 == null) {
                    PsiElement psiElement2 = this.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
                    return psiElement2;
                }
                String newName = string2;
                TextRange textRange = TextRange.create((int)0, (int)this.end);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                return this.handleElementRename(newName, textRange);
            }
            PsiElement psiElement3 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getElement(...)");
            return psiElement3;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof PsiPackage) {
                return Intrinsics.areEqual((Object)this.getCanonicalText(), (Object)((PsiPackage)element).getQualifiedName());
            }
            if (element instanceof PsiClass) {
                String text = this.getCanonicalText();
                return Intrinsics.areEqual((Object)text, (Object)((PsiClass)element).getQualifiedName()) || Intrinsics.areEqual((Object)text, (Object)ClassUtil.getJVMClassName((PsiClass)((PsiClass)element)));
            }
            return false;
        }

        private final PsiElement handleElementRename(String newElementName, TextRange textRange) throws IncorrectOperationException {
            String string = this.psiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            String string2 = FileUtil.getNameWithoutExtension((String)fileName);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
            String name = string2;
            String string3 = StringUtil.replaceSubstring((String)name, (TextRange)textRange, (String)newElementName);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"replaceSubstring(...)");
            String newName = string3;
            this.psiFile.setName(newName + "." + FileUtilRt.getExtension((String)fileName));
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            return psiElement;
        }
    }
}

