/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.spi;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.spi.SpringBootImportsFileIndexKt;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J6\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsManagerImpl;", "Lcom/intellij/spring/boot/spi/SpringBootImportsManager;", "<init>", "()V", "getClasses", "", "Lcom/intellij/psi/PsiClass;", "module", "Lcom/intellij/openapi/module/Module;", "key", "", "includeTests", "", "processValues", "valueHint", "processor", "Lcom/intellij/util/PairProcessor;", "Lcom/intellij/psi/PsiElement;", "getAutoConfigurationClasses", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getScope", "intellij.spring.boot.core"})
public final class SpringBootImportsManagerImpl
extends SpringBootImportsManager {
    @NotNull
    public List<PsiClass> getClasses(@NotNull Module module, @NotNull String key, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return SpringBootImportsFileIndexKt.getSpringBootImportsClasses(project, this.getScope(module, includeTests), key);
    }

    public boolean processValues(@NotNull Module module, @Nullable String valueHint, boolean includeTests, @NotNull PairProcessor<PsiElement, PsiClass> processor) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return SpringBootImportsFileIndexKt.processSpringBootImportsValues(project, this.getScope(module, includeTests), valueHint, processor);
    }

    @NotNull
    public List<PsiClass> getAutoConfigurationClasses(@NotNull Module module, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getAutoConfigurationClasses(this.getScope(module, includeTests), module);
    }

    @NotNull
    public List<PsiClass> getAutoConfigurationClasses(@NotNull GlobalSearchScope scope, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ArrayList result = new ArrayList();
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_3_0_0)) {
            result.addAll(SpringSpiManager.getInstance((Project)project2).getClassesListValue("org.springframework.boot.autoconfigure.EnableAutoConfiguration", scope));
        }
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_7_0)) {
            result.addAll(SpringBootImportsFileIndexKt.getSpringBootImportsClasses(project2, scope, "org.springframework.boot.autoconfigure.AutoConfiguration"));
        }
        ContainerUtil.removeDuplicates((Collection)result);
        return result;
    }

    private final GlobalSearchScope getScope(Module module, boolean includeTests) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)includeTests);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleRuntimeScope(...)");
        return globalSearchScope;
    }
}

