/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.utils;

import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.boot.model.SpringBootAutodetectedModelsSearcher;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public final class SpringBootAutodetectedModelsUtils {
    @NotNull
    public static Set<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> getSpringApplicationLauncherConfigurations(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(0);
        }
        HashSet configurations = new HashSet();
        configurations.addAll(SpringBootAutodetectedModelsUtils.getSpringApplicationLaunchers(module));
        configurations.addAll(SpringBootAutodetectedModelsUtils.getSpringApplicationBuilderLaunchers(module));
        Set<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> set = configurations.isEmpty() ? Collections.emptySet() : configurations;
        if (set == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static Set<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> getSpringApplicationLaunchers(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(2);
        }
        HashSet configurations = new HashSet();
        RecursionManager.runInNewContext(() -> {
            Set<? extends LocalSearchScope> launcherScopes = SpringBootAutodetectedModelsUtils.getSpringApplicationLauncherScopes(module);
            if (launcherScopes.isEmpty()) {
                return;
            }
            PsiClass springApplicationClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.SpringApplication");
            if (springApplicationClass == null) {
                return;
            }
            PsiMethod[] constructors = SpringFunctionalSearchersUtils.findMethods((String)"SpringApplication", (PsiClass)springApplicationClass);
            PsiMethod[] runs = SpringFunctionalSearchersUtils.findMethods((String)"run", (PsiClass)springApplicationClass);
            configurations.addAll(SpringBootAutodetectedModelsUtils.getLauncherConfigurations(module, runs, launcherScopes));
            configurations.addAll(SpringBootAutodetectedModelsUtils.getLauncherConfigurations(module, constructors, launcherScopes));
        });
        return configurations.isEmpty() ? Collections.emptySet() : configurations;
    }

    private static Set<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> getSpringApplicationBuilderLaunchers(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(3);
        }
        HashSet configurations = new HashSet();
        RecursionManager.runInNewContext(() -> {
            PsiClass applicationBuilderClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.builder.SpringApplicationBuilder");
            if (applicationBuilderClass == null) {
                return;
            }
            @NotNull Set<UCallExpression> launcherExpressions = SpringBootAutodetectedModelsUtils.getRunExpressionSearchScopes(applicationBuilderClass, SpringBootAutodetectedModelsUtils.getSpringApplicationBuilderLauncherScopes(module));
            if (launcherExpressions.isEmpty()) {
                return;
            }
            for (UCallExpression uCallExpression : launcherExpressions) {
                PsiElement expressionJavaPsi = uCallExpression.getJavaPsi();
                if (expressionJavaPsi == null) continue;
                HashSet<PsiClass> configurationClasses = new HashSet<PsiClass>();
                configurationClasses.addAll(SpringBootAutodetectedModelsUtils.getConfigurationClasses(module, SpringFunctionalSearchersUtils.findMethods((String)"parent", (PsiClass)applicationBuilderClass), new LocalSearchScope(expressionJavaPsi)));
                configurationClasses.addAll(SpringBootAutodetectedModelsUtils.getConfigurationClasses(module, SpringFunctionalSearchersUtils.findMethods((String)"child", (PsiClass)applicationBuilderClass), new LocalSearchScope(expressionJavaPsi)));
                configurationClasses.addAll(SpringBootAutodetectedModelsUtils.getConfigurationClasses(module, SpringFunctionalSearchersUtils.findMethods((String)"sibling", (PsiClass)applicationBuilderClass), new LocalSearchScope(expressionJavaPsi)));
                if (configurationClasses.isEmpty()) continue;
                configurations.add(new SpringBootAutodetectedModelsSearcher.LauncherConfigurations(uCallExpression, configurationClasses));
            }
        });
        return configurations.isEmpty() ? Collections.emptySet() : configurations;
    }

    @NotNull
    private static Set<UCallExpression> getRunExpressionSearchScopes(@NotNull PsiClass springApplicationClass, @NotNull Set<? extends LocalSearchScope> launcherScopes) {
        if (springApplicationClass == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(4);
        }
        if (launcherScopes == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(5);
        }
        Set<UCallExpression> set = Arrays.stream(SpringFunctionalSearchersUtils.findMethods((String)"run", (PsiClass)springApplicationClass)).flatMap(runMethod -> launcherScopes.stream().flatMap(localSearchScope -> SpringFunctionalSearchersUtils.findMethodCallsWithSearchService((PsiMethod)runMethod, (SearchScope)localSearchScope).stream())).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private static Set<PsiClass> getConfigurationClasses(@NotNull Module module, PsiMethod[] methods, LocalSearchScope ... launcherScopes) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(7);
        }
        Set<PsiClass> set = Arrays.stream(methods).flatMap(runMethod -> Arrays.stream(launcherScopes).flatMap(localSearchScope -> SpringFunctionalSearchersUtils.findMethodCallsWithSearchService((PsiMethod)runMethod, (SearchScope)localSearchScope).stream())).flatMap(uCallExpression -> SpringBootAutodetectedModelsUtils.getConfigurationClasses(module, uCallExpression).stream()).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> getLauncherConfigurations(@NotNull Module module, PsiMethod[] methods, @NotNull Set<? extends LocalSearchScope> launcherScopes) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(9);
        }
        if (launcherScopes == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(10);
        }
        HashSet<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> configurations = new HashSet<SpringBootAutodetectedModelsSearcher.LauncherConfigurations>();
        for (PsiMethod runMethod : methods) {
            for (LocalSearchScope localSearchScope : launcherScopes) {
                for (UCallExpression uCallExpression : SpringFunctionalSearchersUtils.findMethodCallsWithSearchService((PsiMethod)runMethod, (SearchScope)localSearchScope)) {
                    Set<PsiClass> classes = SpringBootAutodetectedModelsUtils.getConfigurationClasses(module, uCallExpression);
                    if (classes.isEmpty()) continue;
                    configurations.add(new SpringBootAutodetectedModelsSearcher.LauncherConfigurations(uCallExpression, classes));
                }
            }
        }
        HashSet<SpringBootAutodetectedModelsSearcher.LauncherConfigurations> hashSet = configurations;
        if (hashSet == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static Set<PsiClass> getConfigurationClasses(@NotNull Module module, @NotNull UCallExpression uCallExpression) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(12);
        }
        if (uCallExpression == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(13);
        }
        HashSet<PsiClass> configurations = new HashSet<PsiClass>();
        for (UExpression argument : uCallExpression.getValueArguments()) {
            if (argument instanceof UClassLiteralExpression) {
                ContainerUtil.addIfNotNull(configurations, (Object)SpringBootAutodetectedModelsUtils.getClassConfiguration((UClassLiteralExpression)argument));
                continue;
            }
            if (!(argument instanceof UCallExpression)) continue;
            for (UExpression valueArgument : ((UCallExpression)argument).getValueArguments()) {
                if (!(valueArgument instanceof UClassLiteralExpression)) continue;
                ContainerUtil.addIfNotNull(configurations, (Object)SpringBootAutodetectedModelsUtils.getClassConfiguration((UClassLiteralExpression)valueArgument));
            }
        }
        return configurations;
    }

    @Nullable
    private static PsiClass getClassConfiguration(UClassLiteralExpression argument) {
        PsiType type = argument.getType();
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @NotNull
    private static Set<? extends LocalSearchScope> getSpringApplicationLauncherScopes(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(14);
        }
        return SpringBootAutodetectedModelsUtils.getLauncherScopes(module, "SpringApplication");
    }

    @NotNull
    private static Set<? extends LocalSearchScope> getSpringApplicationBuilderLauncherScopes(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(15);
        }
        return SpringBootAutodetectedModelsUtils.getLauncherScopes(module, "SpringApplicationBuilder");
    }

    @NotNull
    private static Set<LocalSearchScope> getLauncherScopes(@NotNull Module module, String magicWord) {
        if (module == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(16);
        }
        Set<LocalSearchScope> set = SearchService.getInstance().searchWord(module.getProject(), magicWord).inContexts(SearchContext.inCode(), new SearchContext[0]).inScope((SearchScope)module.getModuleRuntimeScope(false)).buildQuery(occurrence -> {
            if (occurrence.getOffsetInStart() != 0) {
                return Collections.emptySet();
            }
            UClass aClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)occurrence.getStart(), UClass.class);
            return aClass != null ? Collections.singleton(aClass) : Collections.emptySet();
        }).findAll().stream().map(aClass -> new LocalSearchScope((PsiElement)aClass.getJavaPsi())).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsUtils.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8, 11, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/utils/SpringBootAutodetectedModelsUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springApplicationClass";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherScopes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/utils/SpringBootAutodetectedModelsUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringApplicationLauncherConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunExpressionSearchScopes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationLauncherConfigurations";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationLaunchers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationBuilderLaunchers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRunExpressionSearchScopes";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationClasses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherConfigurations";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationLauncherScopes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationBuilderLauncherScopes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherScopes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8, 11, 17 -> new IllegalStateException(string);
        };
    }
}

