/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.text;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.LanguageWithVariant;
import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.nlp.tokenizer.NonDestructiveTokenizer;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.retokenizer.PatternRetokenizer;
import ai.grazie.nlp.tokenizer.retokenizer.QuotesRetokenizer;
import ai.grazie.nlp.tokenizer.sequence.NonDestructiveCharSequenceTokenizer;
import ai.grazie.nlp.tokenizer.word.HeuristicWordTokenizer;
import ai.grazie.nlp.utils.RangesKt;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.spell.GermanCompoundChecker;
import ai.grazie.spell.GrazieSplittingSpeller;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.rule.IgnoreRuleDictionary;
import ai.grazie.spell.text.Typo;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import ai.grazie.text.exclusions.Exclusion;
import ai.grazie.utils.CollectionsKt;
import ai.grazie.utils.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0016\u0018\u0000 M2\u00020\u0001:\u0003MNOB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0003H\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u0010\u001c\u001a\u00020 H\u0004J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0003H\u0002J\u0016\u0010%\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0003H\u0002J\u0016\u0010&\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0003H\u0002J\u0016\u0010'\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0003H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020#H\u0002J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0018\u00101\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u00102\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0003H\u0005J$\u00103\u001a\b\u0012\u0004\u0012\u00020#0\u00032\f\u00104\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000eH\u0002J*\u00106\u001a\b\u0012\u0004\u0012\u00020#0\u00032\f\u00107\u001a\b\u0012\u0004\u0012\u00020#0\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0003H\u0002J,\u00108\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00107\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u00109\u001a\u00020:H\u0002J*\u00108\u001a\b\u0012\u0004\u0012\u00020#0\u00032\f\u00107\u001a\b\u0012\u0004\u0012\u00020#0\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u0003H\u0002J$\u0010=\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010)\u001a\u00020#2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003H\u0002J$\u0010?\u001a\b\u0012\u0004\u0012\u00020<0\u00032\u0006\u0010)\u001a\u00020#2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003H\u0002J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020<0\u00032\f\u0010A\u001a\b\u0012\u0004\u0012\u00020<0\u0003H\u0002J\u0018\u0010B\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000fH\u0016J\u0018\u0010D\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000fH\u0002J\u001e\u0010E\u001a\u0012\u0012\u0004\u0012\u00020\u000e0Fj\b\u0012\u0004\u0012\u00020\u000e`G2\u0006\u0010+\u001a\u00020\u000eJ\u0012\u0010H\u001a\u0004\u0018\u00010\u00132\u0006\u0010+\u001a\u00020\u000eH\u0004J0\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020K0J2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u00020\u000eH\u0004R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006P"}, d2={"Lai/grazie/spell/text/TextSpeller;", "", "spellers", "", "Lai/grazie/spell/Speller;", "<init>", "(Ljava/util/List;)V", "getSpellers", "()Ljava/util/List;", "languages", "Lai/grazie/nlp/langs/LanguageWithVariant;", "german", "spellCacheSplit", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "spellCachePlain", "sugCache", "", "Lai/grazie/spell/text/TextSpeller$Suggestions;", "tokenizer", "Lai/grazie/nlp/tokenizer/NonDestructiveTokenizer;", "suggestionLimit", "", "getSuggestionLimit", "()I", "checkText", "Lai/grazie/spell/text/Typo;", "text", "", "exclusions", "Lai/grazie/text/exclusions/Exclusion;", "Lai/grazie/spell/text/TextSpeller$TokenizedText;", "findForeignFragments", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "typos", "seemsForeignWords", "closelySpaced", "containsForeignAlphabet", "lazyTypo", "token", "ignoreInContext", "word", "ignoreGerman", "isShortenedGermanForm", "mayBeCorrectForSwiss", "isLowerCaseWithDifferentCaseSuggestions", "isAcceptedInAnotherCase", "isOkWithPunctuationAround", "tokenize", "removeTranscriptions", "nonIgnored", "isInUnknownScript", "splitByUnknown", "tokens", "nonIgnoredTokens", "ignorePattern", "Lai/grazie/nlp/patterns/Pattern;", "ignoreRanges", "Lai/grazie/text/TextRange;", "splitBy", "offsets", "getRanges", "mergeIntersectingRanges", "sorted", "isMisspelled", "allowSplitting", "computeIsMisspelled", "suggestions", "Ljava/util/LinkedHashSet;", "Lai/grazie/utils/LinkedSet;", "rankedSuggestions", "preferTwoWordsForMixedCase", "", "", "wordText", "Companion", "TokenizedText", "Suggestions", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nTextSpeller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextSpeller.kt\nai/grazie/spell/text/TextSpeller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,382:1\n1368#2:383\n1454#2,5:384\n1755#2,3:390\n774#2:393\n865#2,2:394\n774#2:396\n865#2,2:397\n827#2:399\n855#2,2:400\n1557#2:402\n1628#2,3:403\n1782#2,3:406\n2632#2,3:409\n1785#2:412\n1755#2,3:413\n1755#2,3:416\n774#2:419\n865#2,2:420\n1611#2,9:422\n1863#2:431\n1864#2:433\n1620#2:434\n1557#2:435\n1628#2,3:436\n1734#2,3:441\n774#2:444\n865#2,2:445\n1053#2:453\n774#2:454\n865#2,2:455\n1557#2:457\n1628#2,3:458\n1611#2,9:461\n1863#2:470\n1864#2:472\n1620#2:473\n1755#2,3:474\n1734#2,2:477\n1755#2,3:479\n1736#2:482\n1062#2:483\n1557#2:484\n1628#2,3:485\n1#3:389\n1#3:432\n1#3:471\n1088#4,2:439\n1069#4,2:488\n158#4,6:490\n1069#4,2:496\n1069#4,2:498\n1069#4,2:503\n1069#4,2:505\n77#5:447\n97#5,5:448\n535#6:500\n520#6,2:501\n522#6,4:507\n*S KotlinDebug\n*F\n+ 1 TextSpeller.kt\nai/grazie/spell/text/TextSpeller\n*L\n75#1:383\n75#1:384,5\n82#1:390,3\n100#1:393\n100#1:394,2\n103#1:396\n103#1:397,2\n106#1:399\n106#1:400,2\n107#1:402\n107#1:403,3\n130#1:406,3\n130#1:409,3\n130#1:412\n160#1:413,3\n173#1:416,3\n212#1:419\n212#1:420,2\n213#1:422,9\n213#1:431\n213#1:433\n213#1:434\n214#1:435\n214#1:436,3\n219#1:441,3\n222#1:444\n222#1:445,2\n250#1:453\n280#1:454\n280#1:455,2\n282#1:457\n282#1:458,3\n320#1:461,9\n320#1:470\n320#1:472\n320#1:473\n321#1:474,3\n327#1:477,2\n327#1:479,3\n327#1:482\n336#1:483\n336#1:484\n336#1:485,3\n213#1:432\n320#1:471\n219#1:439,2\n355#1:488,2\n357#1:490,6\n364#1:496,2\n367#1:498,2\n373#1:503,2\n374#1:505,2\n238#1:447\n238#1:448,5\n370#1:500\n370#1:501,2\n370#1:507,4\n*E\n"})
public class TextSpeller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Speller> spellers;
    @NotNull
    private final List<LanguageWithVariant> languages;
    @Nullable
    private final LanguageWithVariant german;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> spellCacheSplit;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> spellCachePlain;
    @NotNull
    private final ConcurrentHashMap<String, Suggestions[]> sugCache;
    @NotNull
    private final NonDestructiveTokenizer tokenizer;
    @NotNull
    private static final RegexPattern sep_n_sep = new RegexPattern("[" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]n[" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]");
    @NotNull
    private static final Pattern x_n_y = sep_n_sep.before(new Regex("[A-Za-z]+")).afterReversed(new Regex("[A-Za-z]+"));
    @NotNull
    private static final AggregatedPattern ignorePatternCheap;
    @NotNull
    private static final Regex transcription;
    @NotNull
    private static final AggregatedPattern ignorePatternExpensive;
    @NotNull
    private static final IgnoreRuleDictionary ignoreDict;
    @NotNull
    private static final Regex shortenedArticle;
    @NotNull
    private static final Regex versionAbbr;
    @NotNull
    private static final Regex looksLikeGermanWord;
    @NotNull
    private static final Pattern anySnakeKebabName;

    /*
     * WARNING - void declaration
     */
    public TextSpeller(@NotNull List<? extends Speller> spellers) {
        boolean bl;
        PatternRetokenizer.Companion companion;
        Object[] objectArray;
        block6: {
            void $this$any$iv;
            Object v0;
            Object $i$f$flatMap22;
            TextSpeller textSpeller;
            block5: {
                Iterator $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Intrinsics.checkNotNullParameter(spellers, (String)"spellers");
                this.spellers = spellers;
                objectArray = (Object[])this.spellers;
                textSpeller = this;
                boolean $i$f$flatMap22 = false;
                void var4_6 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    Speller it = (Speller)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = it.languages();
                    kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                textSpeller.languages = kotlin.collections.CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                objectArray = this.languages;
                textSpeller = this;
                $i$f$flatMap22 = objectArray;
                for (Object object : $i$f$flatMap22) {
                    LanguageWithVariant it = (LanguageWithVariant)object;
                    boolean bl3 = false;
                    if (!(it.getBase() == Language.GERMAN)) continue;
                    v0 = object;
                    break block5;
                }
                v0 = null;
            }
            textSpeller.german = v0;
            this.spellCacheSplit = new ConcurrentHashMap();
            this.spellCachePlain = new ConcurrentHashMap();
            this.sugCache = new ConcurrentHashMap();
            objectArray = new Pattern[2];
            objectArray[0] = LikelyPatterns.PythonString;
            $i$f$flatMap22 = this.languages;
            int n = 1;
            Object[] objectArray2 = objectArray;
            companion = PatternRetokenizer.Companion;
            textSpeller = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LanguageWithVariant it = (LanguageWithVariant)element$iv;
                    boolean bl4 = false;
                    if (!(it.getBase() == Language.ENGLISH)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        objectArray2[n] = bl5 ? x_n_y : null;
        textSpeller.tokenizer = companion.forPatterns(kotlin.collections.CollectionsKt.listOfNotNull((Object[])objectArray), (NonDestructiveTokenizer)new QuotesRetokenizer((NonDestructiveCharSequenceTokenizer)new HeuristicWordTokenizer(false, false)));
    }

    @NotNull
    protected final List<Speller> getSpellers() {
        return this.spellers;
    }

    protected int getSuggestionLimit() {
        return 3;
    }

    @JvmOverloads
    @NotNull
    public final List<Typo> checkText(@NotNull CharSequence text2, @NotNull List<Exclusion> exclusions) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
        return this.checkText(this.tokenize(text2, exclusions));
    }

    public static /* synthetic */ List checkText$default(TextSpeller textSpeller, CharSequence charSequence, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkText");
        }
        if ((n & 2) != 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return textSpeller.checkText(charSequence, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Typo> checkText(@NotNull TokenizedText text2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Tokenizer.Token it;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Set unknownWords = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)text2.getTokensToSpellCheck()), TextSpeller::checkText$lambda$3)), arg_0 -> TextSpeller.checkText$lambda$4(this, arg_0)));
        if (unknownWords.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = text2.getTokensToSpellCheck();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Tokenizer.Token it2 = (Tokenizer.Token)element$iv$iv;
            boolean bl = false;
            if (!unknownWords.contains(it2.getToken())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownTokens = (List)destination$iv$iv;
        Set<Tokenizer.Token> foreignWords = this.findForeignFragments(unknownTokens);
        Iterable $this$filter$iv2 = unknownTokens;
        boolean $i$f$filter2 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tokenizer.Token)element$iv$iv;
            boolean bl = false;
            if (!(!foreignWords.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonForeign = (List)destination$iv$iv2;
        $this$filter$iv2 = this.nonIgnoredTokens(text2.getText(), nonForeign, (Pattern)ignorePatternExpensive);
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Tokenizer.Token)element$iv$iv;
            boolean bl = false;
            if (this.ignoreInContext(it, text2.getText())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tokenizer.Token)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.lazyTypo(it));
        }
        return (List)destination$iv$iv2;
    }

    private final Set<Tokenizer.Token> findForeignFragments(List<Tokenizer.Token> typos) {
        HashSet result = new HashSet();
        int windowSize = 5;
        int i = 0;
        int n = typos.size() - windowSize;
        if (i <= n) {
            while (true) {
                List<Tokenizer.Token> seq;
                if (this.seemsForeignWords(seq = typos.subList(i, i + windowSize))) {
                    result.addAll(seq);
                }
                if (i == n) break;
                ++i;
            }
        }
        return result;
    }

    private final boolean seemsForeignWords(List<Tokenizer.Token> typos) {
        return this.containsForeignAlphabet(typos) && this.closelySpaced(typos);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean closelySpaced(List<Tokenizer.Token> typos) {
        Iterable iterable = typos;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Tokenizer.Token token = (Tokenizer.Token)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getText().length();
            n = n2 + n3;
        }
        int totalTypoLen = n;
        int coveredRangeLen = RangesKt.getCheckedEndExclusive((IntRange)((Tokenizer.Token)kotlin.collections.CollectionsKt.last(typos)).getRange()) - ((Tokenizer.Token)kotlin.collections.CollectionsKt.first(typos)).getRange().getFirst();
        return totalTypoLen > coveredRangeLen * 2 / 3;
    }

    private final boolean containsForeignAlphabet(List<Tokenizer.Token> typos) {
        int n;
        Iterable $this$count$iv = typos;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl;
                block6: {
                    Tokenizer.Token it = (Tokenizer.Token)element$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = this.languages;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            LanguageWithVariant lang = (LanguageWithVariant)element$iv2;
                            boolean bl3 = false;
                            if (!lang.getBase().getAlphabet().matchEntire((CharSequence)it.getText())) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (!bl || ++count$iv >= 0) continue;
                kotlin.collections.CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > typos.size() / 2;
    }

    private final Typo lazyTypo(Tokenizer.Token token) {
        return new Typo(token, this){
            final /* synthetic */ Tokenizer.Token $token;
            final /* synthetic */ TextSpeller this$0;
            {
                this.$token = $token;
                this.this$0 = $receiver;
            }

            public String getWord() {
                return this.$token.getToken();
            }

            public TextRange getRange() {
                return TextRange.Companion.invoke(this.$token.getRange());
            }

            public LinkedHashSet<String> getFixes() {
                return this.this$0.suggestions(this.$token.getToken());
            }

            public String toString() {
                return this.getWord();
            }
        };
    }

    protected boolean ignoreInContext(@NotNull Tokenizer.Token word, @NotNull CharSequence text2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.isOkWithPunctuationAround(word, text2) || this.german != null && looksLikeGermanWord.matches(charSequence = (CharSequence)word.getText()) && this.ignoreGerman(word, text2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean ignoreGerman(Tokenizer.Token word, CharSequence text2) {
        if (this.isShortenedGermanForm(word, text2)) return true;
        if (new GermanCompoundChecker((Function1<? super String, Boolean>)((Function1)arg_0 -> TextSpeller.ignoreGerman$lambda$12(this, arg_0))).isNonDictCompound(word.getText().getValue())) return true;
        LanguageWithVariant languageWithVariant = this.german;
        if ((languageWithVariant != null ? languageWithVariant.getVariant() : null) != null) return false;
        if (StringsKt.contains$default((CharSequence)text2, (CharSequence)"\u00df", (boolean)false, (int)2, null)) return false;
        if (!this.mayBeCorrectForSwiss(word.getToken())) return false;
        return true;
    }

    private final boolean isShortenedGermanForm(Tokenizer.Token word, CharSequence text2) {
        CharSequence charSequence;
        return word.getRange().getFirst() > 0 && Symbols.INSTANCE.getApostrophes().contains(Character.valueOf(text2.charAt(word.getRange().getFirst() - 1))) && shortenedArticle.matches(charSequence = (CharSequence)word.getText().getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean mayBeCorrectForSwiss(String word) {
        String it;
        if (!StringsKt.contains$default((CharSequence)word, (CharSequence)"ss", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = this.suggestions(word);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)it, (String)"\u00df", (String)"ss", (boolean)false, (int)4, null), (Object)word));
        return true;
    }

    private final boolean isLowerCaseWithDifferentCaseSuggestions(Tokenizer.Token word, CharSequence text2) {
        Object v0;
        block4: {
            if (!TextKt.isLowercase((String)word.getToken())) {
                return false;
            }
            Iterable iterable = anySnakeKebabName.find(text2);
            for (Object t : iterable) {
                TextRange it = (TextRange)t;
                boolean bl = false;
                if (!it.contains(word.getInterval())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        TextRange textRange = v0;
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        if (this.isAcceptedInAnotherCase(word.getToken())) {
            return true;
        }
        return Regex.find$default((Regex)versionAbbr, (CharSequence)text2.subSequence(range.getStart(), range.getEndExclusive()), (int)0, (int)2, null) != null && this.suggestions(word.getToken()).isEmpty();
    }

    private final boolean isAcceptedInAnotherCase(String word) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.spellers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Speller it = (Speller)element$iv;
                    boolean bl2 = false;
                    String string = word.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    if (!(!it.isMisspelled(string, false))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isOkWithPunctuationAround(Tokenizer.Token word, CharSequence text2) {
        block5: {
            char prev;
            block8: {
                block7: {
                    block6: {
                        char next;
                        if (word.getRange().getLast() + 1 < text2.length() && (((next = text2.charAt(word.getRange().getLast() + 1)) == '-' || Symbols.INSTANCE.getApostrophes().contains(Character.valueOf(next))) && !this.isMisspelled(word.getText().getValue() + next, false) || StringsKt.contains$default((CharSequence)"-_*", (char)next, (boolean)false, (int)2, null) && this.isLowerCaseWithDifferentCaseSuggestions(word, text2))) {
                            return true;
                        }
                        if (word.getRange().getFirst() <= 0) break block5;
                        prev = text2.charAt(word.getRange().getFirst() - 1);
                        if (prev != '-') break block6;
                        char c = prev;
                        String string = word.getText().getValue();
                        if (!this.isMisspelled(c + string, false)) break block7;
                    }
                    if (!StringsKt.contains$default((CharSequence)"-_*", (char)prev, (boolean)false, (int)2, null) || !this.isLowerCaseWithDifferentCaseSuggestions(word, text2)) break block8;
                }
                return true;
            }
            if (prev == '[' && StringsKt.startsWith$default((CharSequence)text2, (CharSequence)"]", (int)RangesKt.getCheckedEndExclusive((IntRange)word.getRange()), (boolean)false, (int)4, null) && this.isAcceptedInAnotherCase(word.getToken())) {
                return true;
            }
        }
        return false;
    }

    @JvmOverloads
    @NotNull
    protected final TokenizedText tokenize(@NotNull CharSequence text2, @NotNull List<Exclusion> exclusions) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
        List<Tokenizer.Token> tokens = this.splitByUnknown(this.tokenizer.tokenize(new Text(text2)), exclusions);
        List<Tokenizer.Token> nonIgnored = this.nonIgnoredTokens(text2, tokens, (Pattern)ignorePatternCheap);
        List<Tokenizer.Token> tokensToCheck = this.removeTranscriptions(nonIgnored, text2);
        return new TokenizedText(text2, tokens, tokensToCheck);
    }

    public static /* synthetic */ TokenizedText tokenize$default(TextSpeller textSpeller, CharSequence charSequence, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tokenize");
        }
        if ((n & 2) != 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return textSpeller.tokenize(charSequence, list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tokenizer.Token> removeTranscriptions(List<Tokenizer.Token> nonIgnored, CharSequence text2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = nonIgnored;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tokenizer.Token)element$iv$iv;
            boolean bl = false;
            if (!this.isInUnknownScript(it.getToken())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            IntRange it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Tokenizer.Token token = (Tokenizer.Token)element$iv$iv;
            boolean bl2 = false;
            MatchResult matchResult = transcription.matchAt(text2, token.getRange().getLast() + 1);
            if ((matchResult != null ? matchResult.getRange() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TextRange.Companion.invoke((IntRange)it));
        }
        List toExclude = (List)destination$iv$iv;
        return this.nonIgnoredTokens(nonIgnored, toExclude);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInUnknownScript(String token) {
        Speller it;
        block4: {
            CharSequence $this$any$iv = token;
            boolean $i$f$any = false;
            int n = 0;
            while (n < $this$any$iv.length()) {
                char element$iv;
                char it2 = element$iv = $this$any$iv.charAt(n);
                boolean bl = false;
                if (!Character.isLetter(it2)) {
                    ++n;
                    continue;
                }
                break block4;
            }
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$all$iv = this.spellers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Speller)element$iv;
            boolean bl2 = false;
        } while (it.isAlien(token));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tokenizer.Token> splitByUnknown(List<Tokenizer.Token> tokens, List<Exclusion> exclusions) {
        void $this$flatMapTo$iv$iv;
        Iterator<Tokenizer.Token> $this$filterTo$iv$iv;
        Iterable $this$filter$iv = exclusions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Exclusion it = (Exclusion)element$iv$iv;
            boolean bl = false;
            if (!it.isUnknown()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownExclusions = (List)destination$iv$iv;
        if (unknownExclusions.isEmpty()) {
            return tokens;
        }
        Map tokenToExclusions = new LinkedHashMap();
        int exclusionPointer = 0;
        block1: for (Tokenizer.Token token : tokens) {
            while (exclusionPointer < unknownExclusions.size()) {
                Exclusion exclusion = (Exclusion)unknownExclusions.get(exclusionPointer);
                Intrinsics.checkNotNullExpressionValue((Object)tokenToExclusions.computeIfAbsent(token, arg_0 -> TextSpeller.splitByUnknown$lambda$23(TextSpeller::splitByUnknown$lambda$22, arg_0)), (String)"computeIfAbsent(...)");
                if (exclusion.getOffset() >= token.getRange().getLast()) continue block1;
                if (token.getInterval().contains(exclusion.getOffset())) {
                    List exclusionOffsets;
                    exclusionOffsets.add(exclusion.getOffset());
                }
                ++exclusionPointer;
            }
        }
        Map $this$flatMap$iv = tokenToExclusions;
        boolean $i$f$flatMap = false;
        Map exclusion = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            Iterable list$iv$iv = this.splitBy((Tokenizer.Token)it.getKey(), (List)it.getValue());
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final List<Tokenizer.Token> nonIgnoredTokens(CharSequence text2, List<Tokenizer.Token> tokens, Pattern ignorePattern) {
        if (tokens.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        return this.nonIgnoredTokens(tokens, ignorePattern.find(text2));
    }

    private final List<Tokenizer.Token> nonIgnoredTokens(List<Tokenizer.Token> tokens, List<TextRange> ignoreRanges) {
        if (ignoreRanges.isEmpty()) {
            return tokens;
        }
        Iterable $this$sortedBy$iv = ignoreRanges;
        boolean $i$f$sortedBy = false;
        List<TextRange> sortedRanges = this.mergeIntersectingRanges(kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        }));
        ArrayList<Tokenizer.Token> result = new ArrayList<Tokenizer.Token>();
        int ignoredIndex = 0;
        for (Tokenizer.Token token : tokens) {
            while (ignoredIndex < sortedRanges.size() && sortedRanges.get(ignoredIndex).getEndExclusive() <= token.getInterval().getStart()) {
                ++ignoredIndex;
            }
            if (ignoredIndex < sortedRanges.size() && sortedRanges.get(ignoredIndex).intersects(token.getInterval())) continue;
            result.add(token);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tokenizer.Token> splitBy(Tokenizer.Token token, List<Integer> offsets) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (offsets.isEmpty()) {
            return kotlin.collections.CollectionsKt.listOf((Object)token);
        }
        if (!(((Number)kotlin.collections.CollectionsKt.first(offsets)).intValue() >= token.getRange().getFirst() && ((Number)kotlin.collections.CollectionsKt.last(offsets)).intValue() <= token.getRange().getLast() + 1)) {
            boolean $i$a$-require-TextSpeller$splitBy$22 = false;
            String $i$a$-require-TextSpeller$splitBy$22 = "Can't split token " + this + " at offsets " + offsets + ". Offsets must be in range [" + token.getRange().getFirst() + ", " + token.getRange().getLast() + "].";
            throw new IllegalArgumentException($i$a$-require-TextSpeller$splitBy$22.toString());
        }
        Iterable $this$filter$iv = offsets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it != token.getRange().getFirst() && it != token.getRange().getLast() + 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valuableOffsets = (List)destination$iv$iv;
        if (valuableOffsets.isEmpty()) {
            return kotlin.collections.CollectionsKt.listOf((Object)token);
        }
        Iterable $this$map$iv = this.getRanges(token, valuableOffsets);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TextRange it = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(token.getText().substring(it), it));
        }
        return (List)destination$iv$iv;
    }

    private final List<TextRange> getRanges(Tokenizer.Token token, List<Integer> offsets) {
        List ranges = new ArrayList();
        ranges.add(new TextRange(token.getRange().getFirst(), ((Number)kotlin.collections.CollectionsKt.first(offsets)).intValue()));
        int n = offsets.size() - 1;
        for (int i = 0; i < n; ++i) {
            ranges.add(new TextRange(((Number)offsets.get(i)).intValue(), ((Number)offsets.get(i + 1)).intValue()));
        }
        ranges.add(new TextRange(((Number)kotlin.collections.CollectionsKt.last(offsets)).intValue(), token.getRange().getLast() + 1));
        return ranges;
    }

    private final List<TextRange> mergeIntersectingRanges(List<TextRange> sorted) {
        if (sorted.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        TextRange current = sorted.get(0);
        int n = sorted.size();
        for (int i = 1; i < n; ++i) {
            TextRange next = sorted.get(i);
            if (current.getEndExclusive() >= next.getStart()) {
                current = new TextRange(current.getStart(), Math.max(current.getEndExclusive(), next.getEndExclusive()));
                continue;
            }
            result.add(current);
            current = next;
        }
        result.add(current);
        return result;
    }

    public boolean isMisspelled(@NotNull String word, boolean allowSplitting) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        ConcurrentHashMap<String, Boolean> cache = allowSplitting ? this.spellCacheSplit : this.spellCachePlain;
        Boolean bl = cache.computeIfAbsent(word, arg_0 -> TextSpeller.isMisspelled$lambda$30(arg_0 -> TextSpeller.isMisspelled$lambda$29(this, word, allowSplitting, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    private final boolean computeIsMisspelled(String word, boolean allowSplitting) {
        String normalized;
        List applicable;
        block19: {
            block18: {
                boolean bl;
                block15: {
                    Iterator $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = this.spellers;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Speller it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Speller it = (Speller)element$iv$iv;
                        boolean bl3 = false;
                        if ((it.isAlien(word) ? null : (!allowSplitting && it instanceof GrazieSplittingSpeller ? ((GrazieSplittingSpeller)it).getSpeller() : it)) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    applicable = (List)destination$iv$iv;
                    if (applicable.isEmpty()) break block18;
                    Iterable $this$any$iv = applicable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Speller it = (Speller)element$iv;
                            boolean bl5 = false;
                            if (!(!Speller.isMisspelled$default(it, word, false, 2, null))) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block19;
            }
            return false;
        }
        if (this.languages.get(0).getBase() == Language.ENGLISH && !Intrinsics.areEqual((Object)(normalized = TextKt.normalizeAccents((String)word)), (Object)word)) {
            boolean bl;
            block17: {
                Iterable $this$all$iv = applicable;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl6;
                        Speller it;
                        block16: {
                            it = (Speller)element$iv;
                            boolean bl7 = false;
                            Iterable $this$any$iv = it.languages();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl6 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    LanguageWithVariant lwv = (LanguageWithVariant)element$iv2;
                                    boolean bl8 = false;
                                    if (!(lwv.getBase() == Language.ENGLISH)) continue;
                                    bl6 = true;
                                    break block16;
                                }
                                bl6 = false;
                            }
                        }
                        if (bl6 && Speller.isMisspelled$default(it, normalized, false, 2, null)) continue;
                        bl = false;
                        break block17;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinkedHashSet<String> suggestions(@NotNull String word) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Suggestions suggestions = this.rankedSuggestions(word);
        Map map = suggestions != null ? suggestions.getRanked() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map ranked = map;
        Map<String, Double> filtered = this.preferTwoWordsForMixedCase(ranked, word);
        Iterable $this$sortedByDescending$iv = filtered.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        });
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return CollectionsKt.toLinkedSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    protected final Suggestions rankedSuggestions(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Suggestions[] suggestionsArray = this.sugCache.computeIfAbsent(word, arg_0 -> TextSpeller.rankedSuggestions$lambda$38(arg_0 -> TextSpeller.rankedSuggestions$lambda$37(this, word, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)suggestionsArray, (String)"computeIfAbsent(...)");
        return (Suggestions)ArraysKt.firstOrNull((Object[])suggestionsArray);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final Map<String, Double> preferTwoWordsForMixedCase(@NotNull Map<String, Double> suggestions, @NotNull String wordText) {
        block22: {
            block21: {
                block20: {
                    block26: {
                        block25: {
                            block19: {
                                Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
                                Intrinsics.checkNotNullParameter((Object)wordText, (String)"wordText");
                                if (suggestions.size() < 2) break block25;
                                $this$all$iv = wordText;
                                $i$f$all = false;
                                for (var5_8 = 0; var5_8 < $this$all$iv.length(); ++var5_8) {
                                    it = element$iv = $this$all$iv.charAt(var5_8);
                                    $i$a$-all-TextSpeller$preferTwoWordsForMixedCase$1 = false;
                                    if (Character.isLetter((char)it)) continue;
                                    v0 = false;
                                    break block19;
                                }
                                v0 = true;
                            }
                            if (v0) break block26;
                        }
                        return suggestions;
                    }
                    $this$indexOfFirst$iv = StringsKt.drop((String)wordText, (int)1);
                    $i$f$indexOfFirst = false;
                    it = $this$indexOfFirst$iv.length();
                    for (index$iv = 0; index$iv < it; ++index$iv) {
                        it = $this$indexOfFirst$iv.charAt(index$iv);
                        $i$a$-indexOfFirst-TextSpeller$preferTwoWordsForMixedCase$upperCaseIndex$1 = 0;
                        if (!Character.isUpperCase(it)) continue;
                        v1 = index$iv;
                        break block20;
                    }
                    v1 = upperCaseIndex = -1;
                }
                if (upperCaseIndex < 0) {
                    return suggestions;
                }
                splitIndex = upperCaseIndex + 1;
                firstPart = StringsKt.take((String)wordText, (int)splitIndex);
                v2 = wordText.substring(splitIndex);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                secondPart = v2;
                $this$all$iv = firstPart;
                $i$f$all = false;
                for ($i$a$-indexOfFirst-TextSpeller$preferTwoWordsForMixedCase$upperCaseIndex$1 = 0; $i$a$-indexOfFirst-TextSpeller$preferTwoWordsForMixedCase$upperCaseIndex$1 < $this$all$iv.length(); ++$i$a$-indexOfFirst-TextSpeller$preferTwoWordsForMixedCase$upperCaseIndex$1) {
                    it = element$iv = $this$all$iv.charAt($i$a$-indexOfFirst-TextSpeller$preferTwoWordsForMixedCase$upperCaseIndex$1);
                    $i$a$-all-TextSpeller$preferTwoWordsForMixedCase$2 = false;
                    if (Character.isLowerCase((char)it)) continue;
                    v3 = false;
                    break block21;
                }
                v3 = true;
            }
            if (!v3) {
                return suggestions;
            }
            if (secondPart.length() == 1) ** GOTO lbl-1000
            $this$all$iv = StringsKt.drop((String)secondPart, (int)1);
            $i$f$all = false;
            for (element$iv = 0; element$iv < $this$all$iv.length(); ++element$iv) {
                it = element$iv = $this$all$iv.charAt(element$iv);
                $i$a$-all-TextSpeller$preferTwoWordsForMixedCase$isValidSecondPart$1 = false;
                if (Character.isLowerCase(it)) continue;
                v4 = false;
                break block22;
            }
            v4 = true;
        }
        if (v4) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = isValidSecondPart = false;
        }
        if (!isValidSecondPart) {
            return suggestions;
        }
        $this$filter$iv = suggestions;
        $i$f$filter = false;
        element$iv = $this$filter$iv;
        destination$iv$iv = (Map<String, Double>)new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var14_26 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var14_26.hasNext()) {
            block24: {
                block23: {
                    var16_28 = element$iv$iv = var14_26.next();
                    $i$a$-filter-TextSpeller$preferTwoWordsForMixedCase$matching$1 = false;
                    var20_32 = new Regex("\\s+");
                    suggestion = (String)var16_28.getKey();
                    var19_31 = StringsKt.trim((CharSequence)suggestion).toString();
                    words = var20_32.split(var19_31, var21_34 = 0);
                    if (words.size() != 2) ** GOTO lbl-1000
                    $this$all$iv = (CharSequence)words.get(0);
                    $i$f$all = false;
                    for (var21_34 = 0; var21_34 < $this$all$iv.length(); ++var21_34) {
                        it = element$iv = $this$all$iv.charAt(var21_34);
                        $i$a$-all-TextSpeller$preferTwoWordsForMixedCase$matching$1$1 = false;
                        if (Character.isLetter(it)) continue;
                        v6 = false;
                        break block23;
                    }
                    v6 = true;
                }
                if (!v6 || !Intrinsics.areEqual(words.get(0), (Object)firstPart)) ** GOTO lbl-1000
                $this$all$iv = (CharSequence)words.get(1);
                $i$f$all = false;
                for (var21_34 = 0; var21_34 < $this$all$iv.length(); ++var21_34) {
                    it = element$iv = $this$all$iv.charAt(var21_34);
                    $i$a$-all-TextSpeller$preferTwoWordsForMixedCase$matching$1$2 = false;
                    if (Character.isLetter(it)) continue;
                    v7 = false;
                    break block24;
                }
                v7 = true;
            }
            if (v7 && Intrinsics.areEqual(words.get(1), (Object)secondPart)) {
                v8 = true;
            } else lbl-1000:
            // 3 sources

            {
                v8 = false;
            }
            if (!v8) continue;
            destination$iv$iv.put((String)element$iv$iv.getKey(), (Double)element$iv$iv.getValue());
        }
        matching = destination$iv$iv;
        var9_19 = matching;
        if (var9_19.isEmpty()) {
            $i$a$-ifEmpty-TextSpeller$preferTwoWordsForMixedCase$3 = false;
            v9 = suggestions;
        } else {
            v9 = var9_19;
        }
        return v9;
    }

    @JvmOverloads
    @NotNull
    public final List<Typo> checkText(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return TextSpeller.checkText$default(this, text2, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    protected final TokenizedText tokenize(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return TextSpeller.tokenize$default(this, text2, null, 2, null);
    }

    private static final String checkText$lambda$3(Tokenizer.Token it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getToken();
    }

    private static final boolean checkText$lambda$4(TextSpeller this$0, String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return !ignoreDict.matches(word) && this$0.isMisspelled(word, true);
    }

    private static final boolean ignoreGerman$lambda$12(TextSpeller this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isMisspelled(it, false);
    }

    private static final List splitByUnknown$lambda$22(Tokenizer.Token it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List splitByUnknown$lambda$23(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Boolean isMisspelled$lambda$29(TextSpeller this$0, String $word, boolean $allowSplitting, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeIsMisspelled($word, $allowSplitting);
    }

    private static final Boolean isMisspelled$lambda$30(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Suggestions[] rankedSuggestions$lambda$37(TextSpeller this$0, String $word, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (Speller speller : this$0.spellers) {
            Map<String, Double> suggest;
            if (speller.isAlien($word) || !(!(suggest = speller.suggestAndRank($word, this$0.getSuggestionLimit())).isEmpty())) continue;
            Suggestions[] suggestionsArray = new Suggestions[]{new Suggestions(speller, suggest)};
            return suggestionsArray;
        }
        return new Suggestions[0];
    }

    private static final Suggestions[] rankedSuggestions$lambda$38(Function1 $tmp0, Object p0) {
        return (Suggestions[])$tmp0.invoke(p0);
    }

    static {
        Pattern[] patternArray = new Pattern[]{LikelyPatterns.IsURL, LikelyPatterns.DataUrlBase64, LikelyPatterns.IsEmail, LikelyPatterns.IsFilePath, LikelyPatterns.CommandLineOption, LikelyPatterns.PythonString, LikelyPatterns.FunctionName, LikelyPatterns.ChatTextEmoji, LikelyPatterns.IsExcelFormula, sep_n_sep};
        ignorePatternCheap = new AggregatedPattern(patternArray);
        Companion $this$transcription_u24lambda_u2447 = Companion;
        boolean bl = false;
        String word = "\\p{L}+";
        String transcription = "[(" + LikelyPatterns.quotes + "]?" + word + "(\\s+" + word + ")?[)" + LikelyPatterns.quotes + "]?";
        String translationSeparator = "([" + LikelyPatterns.quotes + "]|[-\u2013\u2014]\\s+|\\()";
        TextSpeller.transcription = new Regex("\\s+" + transcription + "\\s+" + translationSeparator + "(?=\\p{L})");
        patternArray = new Pattern[]{LikelyPatterns.IsAbbreviation, LikelyPatterns.IsCompositeInflection, LikelyPatterns.IsRebusAbbreviation, LikelyPatterns.RestoredWordPart, LikelyPatterns.Chemical, LikelyPatterns.IsIBAN, LikelyPatterns.AcademicCitation, LikelyPatterns.IsMention, LikelyPatterns.TicketName, LikelyPatterns.INSTANCE.snakeKebabName(2), LikelyPatterns.IsHashLike, LikelyPatterns.ChainedName, LikelyPatterns.LicenseKey, LikelyPatterns.DatePattern, LikelyPatterns.PropertyName, LikelyPatterns.LongRomanNumeral, LikelyPatterns.IsGermanEponymEndingInSche};
        ignorePatternExpensive = new AggregatedPattern(patternArray);
        ignoreDict = IgnoreRuleDictionary.Companion.standard(2);
        shortenedArticle = new Regex("n(e[mnsr]?)?");
        versionAbbr = new Regex("[_-][vV]\\d");
        looksLikeGermanWord = new Regex("[a-z\u00e4\u00f6\u00fc\u00df]+", RegexOption.IGNORE_CASE);
        anySnakeKebabName = LikelyPatterns.INSTANCE.snakeKebabName(1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/grazie/spell/text/TextSpeller$Companion;", "", "<init>", "()V", "sep_n_sep", "Lai/grazie/nlp/patterns/RegexPattern;", "getSep_n_sep", "()Lai/grazie/nlp/patterns/RegexPattern;", "x_n_y", "Lai/grazie/nlp/patterns/Pattern;", "ignorePatternCheap", "Lai/grazie/nlp/patterns/AggregatedPattern;", "transcription", "Lkotlin/text/Regex;", "ignorePatternExpensive", "ignoreDict", "Lai/grazie/spell/dictionary/rule/IgnoreRuleDictionary;", "shortenedArticle", "versionAbbr", "looksLikeGermanWord", "anySnakeKebabName", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RegexPattern getSep_n_sep() {
            return sep_n_sep;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lai/grazie/spell/text/TextSpeller$Suggestions;", "", "speller", "Lai/grazie/spell/Speller;", "ranked", "", "", "", "<init>", "(Lai/grazie/spell/Speller;Ljava/util/Map;)V", "getSpeller", "()Lai/grazie/spell/Speller;", "getRanked", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gec-spell-engine-local"})
    protected static final class Suggestions {
        @NotNull
        private final Speller speller;
        @NotNull
        private final Map<String, Double> ranked;

        public Suggestions(@NotNull Speller speller, @NotNull Map<String, Double> ranked) {
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            Intrinsics.checkNotNullParameter(ranked, (String)"ranked");
            this.speller = speller;
            this.ranked = ranked;
        }

        @NotNull
        public final Speller getSpeller() {
            return this.speller;
        }

        @NotNull
        public final Map<String, Double> getRanked() {
            return this.ranked;
        }

        @NotNull
        public final Speller component1() {
            return this.speller;
        }

        @NotNull
        public final Map<String, Double> component2() {
            return this.ranked;
        }

        @NotNull
        public final Suggestions copy(@NotNull Speller speller, @NotNull Map<String, Double> ranked) {
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            Intrinsics.checkNotNullParameter(ranked, (String)"ranked");
            return new Suggestions(speller, ranked);
        }

        public static /* synthetic */ Suggestions copy$default(Suggestions suggestions, Speller speller, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                speller = suggestions.speller;
            }
            if ((n & 2) != 0) {
                map = suggestions.ranked;
            }
            return suggestions.copy(speller, map);
        }

        @NotNull
        public String toString() {
            return "Suggestions(speller=" + this.speller + ", ranked=" + this.ranked + ")";
        }

        public int hashCode() {
            int result = this.speller.hashCode();
            result = result * 31 + ((Object)this.ranked).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Suggestions)) {
                return false;
            }
            Suggestions suggestions = (Suggestions)other;
            if (!Intrinsics.areEqual((Object)this.speller, (Object)suggestions.speller)) {
                return false;
            }
            return Intrinsics.areEqual(this.ranked, suggestions.ranked);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lai/grazie/spell/text/TextSpeller$TokenizedText;", "", "text", "", "allTokens", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "tokensToSpellCheck", "<init>", "(Ljava/lang/CharSequence;Ljava/util/List;Ljava/util/List;)V", "getText", "()Ljava/lang/CharSequence;", "getAllTokens", "()Ljava/util/List;", "getTokensToSpellCheck", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gec-spell-engine-local"})
    protected static final class TokenizedText {
        @NotNull
        private final CharSequence text;
        @NotNull
        private final List<Tokenizer.Token> allTokens;
        @NotNull
        private final List<Tokenizer.Token> tokensToSpellCheck;

        public TokenizedText(@NotNull CharSequence text2, @NotNull List<Tokenizer.Token> allTokens, @NotNull List<Tokenizer.Token> tokensToSpellCheck) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(allTokens, (String)"allTokens");
            Intrinsics.checkNotNullParameter(tokensToSpellCheck, (String)"tokensToSpellCheck");
            this.text = text2;
            this.allTokens = allTokens;
            this.tokensToSpellCheck = tokensToSpellCheck;
        }

        @NotNull
        public final CharSequence getText() {
            return this.text;
        }

        @NotNull
        public final List<Tokenizer.Token> getAllTokens() {
            return this.allTokens;
        }

        @NotNull
        public final List<Tokenizer.Token> getTokensToSpellCheck() {
            return this.tokensToSpellCheck;
        }

        @NotNull
        public final CharSequence component1() {
            return this.text;
        }

        @NotNull
        public final List<Tokenizer.Token> component2() {
            return this.allTokens;
        }

        @NotNull
        public final List<Tokenizer.Token> component3() {
            return this.tokensToSpellCheck;
        }

        @NotNull
        public final TokenizedText copy(@NotNull CharSequence text2, @NotNull List<Tokenizer.Token> allTokens, @NotNull List<Tokenizer.Token> tokensToSpellCheck) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(allTokens, (String)"allTokens");
            Intrinsics.checkNotNullParameter(tokensToSpellCheck, (String)"tokensToSpellCheck");
            return new TokenizedText(text2, allTokens, tokensToSpellCheck);
        }

        public static /* synthetic */ TokenizedText copy$default(TokenizedText tokenizedText, CharSequence charSequence, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = tokenizedText.text;
            }
            if ((n & 2) != 0) {
                list = tokenizedText.allTokens;
            }
            if ((n & 4) != 0) {
                list2 = tokenizedText.tokensToSpellCheck;
            }
            return tokenizedText.copy(charSequence, list, list2);
        }

        @NotNull
        public String toString() {
            return "TokenizedText(text=" + this.text + ", allTokens=" + this.allTokens + ", tokensToSpellCheck=" + this.tokensToSpellCheck + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + ((Object)this.allTokens).hashCode();
            result = result * 31 + ((Object)this.tokensToSpellCheck).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenizedText)) {
                return false;
            }
            TokenizedText tokenizedText = (TokenizedText)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)tokenizedText.text)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allTokens, tokenizedText.allTokens)) {
                return false;
            }
            return Intrinsics.areEqual(this.tokensToSpellCheck, tokenizedText.tokensToSpellCheck);
        }
    }
}

