/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.foundation.shape.CornerSizeKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.unit.Dp;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.DirProvider;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeIconDataKt;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.theme.BridgeGlobalColorsKt;
import org.jetbrains.jewel.bridge.theme.BridgeGlobalMetricsKt;
import org.jetbrains.jewel.bridge.theme.BridgeGrayFilterValuesKt;
import org.jetbrains.jewel.bridge.theme.BridgeThemeColorPaletteKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeBannerKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeButtonKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeCheckboxKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeChipKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeCircularProgressKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeComboBoxKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeDividerKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeDropdownKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeGroupHeaderKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeHorizontalProgressBarKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeIconButtonKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeLazyTreeKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeLinkKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeMenuKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgePopupContainerKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeRadioButtonKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeScrollbarKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSearchMatchKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSegmentedControlButtonKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSegmentedControlKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSelectableLazyColumnKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSimpleListItemKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSliderKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSpeedSearchKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeSplitButtonKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeTabKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeTextAreaKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeTextFieldKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeTextKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeTooltipKt;
import org.jetbrains.jewel.foundation.DisabledAppearanceValues;
import org.jetbrains.jewel.foundation.GlobalColors;
import org.jetbrains.jewel.foundation.GlobalMetrics;
import org.jetbrains.jewel.foundation.theme.ThemeColorPalette;
import org.jetbrains.jewel.foundation.theme.ThemeDefinition;
import org.jetbrains.jewel.foundation.theme.ThemeIconData;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.ui.ComponentStyling;
import org.jetbrains.jewel.ui.DefaultComponentStyling;
import org.jetbrains.jewel.ui.component.styling.ButtonStyle;
import org.jetbrains.jewel.ui.component.styling.CheckboxStyle;
import org.jetbrains.jewel.ui.component.styling.ChipStyle;
import org.jetbrains.jewel.ui.component.styling.CircularProgressStyle;
import org.jetbrains.jewel.ui.component.styling.ComboBoxStyle;
import org.jetbrains.jewel.ui.component.styling.DefaultBannerStyles;
import org.jetbrains.jewel.ui.component.styling.DividerStyle;
import org.jetbrains.jewel.ui.component.styling.DropdownStyle;
import org.jetbrains.jewel.ui.component.styling.GroupHeaderStyle;
import org.jetbrains.jewel.ui.component.styling.HorizontalProgressBarStyle;
import org.jetbrains.jewel.ui.component.styling.IconButtonStyle;
import org.jetbrains.jewel.ui.component.styling.InlineBannerStyles;
import org.jetbrains.jewel.ui.component.styling.LazyTreeStyle;
import org.jetbrains.jewel.ui.component.styling.LinkStyle;
import org.jetbrains.jewel.ui.component.styling.MenuStyle;
import org.jetbrains.jewel.ui.component.styling.PopupContainerStyle;
import org.jetbrains.jewel.ui.component.styling.RadioButtonStyle;
import org.jetbrains.jewel.ui.component.styling.ScrollbarStyle;
import org.jetbrains.jewel.ui.component.styling.SearchMatchStyle;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlButtonStyle;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlStyle;
import org.jetbrains.jewel.ui.component.styling.SelectableLazyColumnStyle;
import org.jetbrains.jewel.ui.component.styling.SimpleListItemStyle;
import org.jetbrains.jewel.ui.component.styling.SliderStyle;
import org.jetbrains.jewel.ui.component.styling.SpeedSearchStyle;
import org.jetbrains.jewel.ui.component.styling.SplitButtonStyle;
import org.jetbrains.jewel.ui.component.styling.TabStyle;
import org.jetbrains.jewel.ui.component.styling.TextAreaStyle;
import org.jetbrains.jewel.ui.component.styling.TextFieldStyle;
import org.jetbrains.jewel.ui.component.styling.TooltipStyle;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u000b\u001a\u00020\fH\u0000\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0014\u0010\r\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\"\u0014\u0010\u0017\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0014\u0010\u001b\u001a\u00020\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"logger", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "uiDefaults", "Ljavax/swing/UIDefaults;", "kotlin.jvm.PlatformType", "getUiDefaults", "()Ljavax/swing/UIDefaults;", "iconsBasePath", "", "getIconsBasePath", "()Ljava/lang/String;", "createBridgeThemeDefinition", "Lorg/jetbrains/jewel/foundation/theme/ThemeDefinition;", "isDark", "", "()Z", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "editorTextStyle", "consoleTextStyle", "createBridgeComponentStyling", "Lorg/jetbrains/jewel/ui/ComponentStyling;", "theme", "componentArc", "Landroidx/compose/foundation/shape/CornerSize;", "getComponentArc", "()Landroidx/compose/foundation/shape/CornerSize;", "borderWidth", "Landroidx/compose/ui/unit/Dp;", "getBorderWidth", "()F", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridge.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/Dp\n*L\n1#1,115:1\n60#2:116\n*S KotlinDebug\n*F\n+ 1 IntUiBridge.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeKt\n*L\n111#1:116\n*E\n"})
public final class IntUiBridgeKt {
    @NotNull
    private static final JewelLogger logger = JewelLogger.Companion.getInstance("JewelIntUiBridge");

    public static final UIDefaults getUiDefaults() {
        return UIManager.getDefaults();
    }

    @NotNull
    public static final String getIconsBasePath() {
        return new DirProvider().dir();
    }

    @NotNull
    public static final ThemeDefinition createBridgeThemeDefinition() {
        TextStyle textStyle = IntUiBridgeTextKt.retrieveDefaultTextStyle();
        TextStyle editorTextStyle = IntUiBridgeTextKt.retrieveEditorTextStyle();
        TextStyle consoleTextStyle = IntUiBridgeTextKt.retrieveConsoleTextStyle();
        return IntUiBridgeKt.createBridgeThemeDefinition(textStyle, editorTextStyle, consoleTextStyle);
    }

    public static final boolean isDark() {
        return !JBColor.isBright();
    }

    @NotNull
    public static final ThemeDefinition createBridgeThemeDefinition(@NotNull TextStyle textStyle, @NotNull TextStyle editorTextStyle, @NotNull TextStyle consoleTextStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)editorTextStyle, (String)"editorTextStyle");
        Intrinsics.checkNotNullParameter((Object)consoleTextStyle, (String)"consoleTextStyle");
        logger.debug("Obtaining theme definition from Swing...");
        String string = BridgeUtilsKt.lafName();
        boolean bl = IntUiBridgeKt.isDark();
        GlobalColors globalColors = BridgeGlobalColorsKt.readFromLaF(GlobalColors.Companion);
        GlobalMetrics globalMetrics = BridgeGlobalMetricsKt.readFromLaF(GlobalMetrics.Companion);
        Color color = JBColor.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        return new ThemeDefinition(string, bl, globalColors, globalMetrics, textStyle, editorTextStyle, consoleTextStyle, BridgeUtilsKt.toComposeColor(color), BridgeThemeColorPaletteKt.readFromLaF(ThemeColorPalette.Companion), BridgeIconDataKt.readFromLaF(ThemeIconData.Companion), BridgeGrayFilterValuesKt.readFromLaF(DisabledAppearanceValues.Companion), null);
    }

    @NotNull
    public static final ComponentStyling createBridgeComponentStyling(@NotNull ThemeDefinition theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        logger.debug("Obtaining Int UI component styling from Swing...");
        TextFieldStyle textFieldStyle = IntUiBridgeTextFieldKt.readTextFieldStyle();
        MenuStyle menuStyle = IntUiBridgeMenuKt.readMenuStyle();
        CheckboxStyle checkboxStyle = IntUiBridgeCheckboxKt.readCheckboxStyle();
        ChipStyle chipStyle = IntUiBridgeChipKt.readChipStyle();
        CircularProgressStyle circularProgressStyle = IntUiBridgeCircularProgressKt.readCircularProgressStyle(theme.isDark());
        ComboBoxStyle comboBoxStyle = IntUiBridgeComboBoxKt.readDefaultComboBoxStyle();
        DefaultBannerStyles defaultBannerStyles = IntUiBridgeBannerKt.readDefaultBannerStyle();
        ButtonStyle buttonStyle = IntUiBridgeButtonKt.readDefaultButtonStyle();
        DropdownStyle dropdownStyle = IntUiBridgeDropdownKt.readDefaultDropdownStyle(menuStyle);
        SplitButtonStyle splitButtonStyle = IntUiBridgeSplitButtonKt.readDefaultSplitButtonStyle();
        TabStyle tabStyle = IntUiBridgeTabKt.readDefaultTabStyle();
        DividerStyle dividerStyle = IntUiBridgeDividerKt.readDividerStyle();
        TabStyle tabStyle2 = IntUiBridgeTabKt.readEditorTabStyle();
        GroupHeaderStyle groupHeaderStyle = IntUiBridgeGroupHeaderKt.readGroupHeaderStyle();
        HorizontalProgressBarStyle horizontalProgressBarStyle = IntUiBridgeHorizontalProgressBarKt.readHorizontalProgressBarStyle();
        IconButtonStyle iconButtonStyle = IntUiBridgeIconButtonKt.readIconButtonStyle();
        IconButtonStyle iconButtonStyle2 = IntUiBridgeIconButtonKt.readTransparentIconButton();
        InlineBannerStyles inlineBannerStyles = IntUiBridgeBannerKt.readInlineBannerStyle();
        LazyTreeStyle lazyTreeStyle = IntUiBridgeLazyTreeKt.readLazyTreeStyle();
        LinkStyle linkStyle = IntUiBridgeLinkKt.readLinkStyle();
        ButtonStyle buttonStyle2 = IntUiBridgeButtonKt.readOutlinedButtonStyle();
        SplitButtonStyle splitButtonStyle2 = IntUiBridgeSplitButtonKt.readOutlinedSplitButtonStyle();
        PopupContainerStyle popupContainerStyle = IntUiBridgePopupContainerKt.readPopupContainerStyle();
        RadioButtonStyle radioButtonStyle = IntUiBridgeRadioButtonKt.readRadioButtonStyle();
        ScrollbarStyle scrollbarStyle = IntUiBridgeScrollbarKt.readScrollbarStyle(theme.isDark());
        SegmentedControlButtonStyle segmentedControlButtonStyle = IntUiBridgeSegmentedControlButtonKt.readSegmentedControlButtonStyle();
        SegmentedControlStyle segmentedControlStyle = IntUiBridgeSegmentedControlKt.readSegmentedControlStyle();
        SelectableLazyColumnStyle selectableLazyColumnStyle = IntUiBridgeSelectableLazyColumnKt.readSelectableLazyColumnStyle();
        SimpleListItemStyle simpleListItemStyle = IntUiBridgeSimpleListItemKt.readSimpleListItemStyle();
        SliderStyle sliderStyle = IntUiBridgeSliderKt.readSliderStyle(theme.isDark());
        TextAreaStyle textAreaStyle = IntUiBridgeTextAreaKt.readTextAreaStyle(textFieldStyle.getMetrics());
        TooltipStyle tooltipStyle = IntUiBridgeTooltipKt.readTooltipStyle();
        DropdownStyle dropdownStyle2 = IntUiBridgeDropdownKt.readUndecoratedDropdownStyle(menuStyle);
        SpeedSearchStyle speedSearchStyle = IntUiBridgeSpeedSearchKt.readSpeedSearchStyle();
        SearchMatchStyle searchMatchStyle = IntUiBridgeSearchMatchKt.readSearchMatchStyle(theme.isDark());
        return (ComponentStyling)new DefaultComponentStyling(checkboxStyle, chipStyle, circularProgressStyle, defaultBannerStyles, comboBoxStyle, buttonStyle, dropdownStyle, splitButtonStyle, tabStyle, dividerStyle, tabStyle2, groupHeaderStyle, horizontalProgressBarStyle, iconButtonStyle, iconButtonStyle2, inlineBannerStyles, lazyTreeStyle, linkStyle, menuStyle, buttonStyle2, popupContainerStyle, splitButtonStyle2, radioButtonStyle, scrollbarStyle, segmentedControlButtonStyle, segmentedControlStyle, selectableLazyColumnStyle, simpleListItemStyle, sliderStyle, textAreaStyle, textFieldStyle, tooltipStyle, dropdownStyle2, speedSearchStyle, searchMatchStyle);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CornerSize getComponentArc() {
        void $v$c$androidx-compose-ui-unit-Dp$-this$0$iv;
        JBValue jBValue = DarculaUIUtil.COMPONENT_ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"COMPONENT_ARC");
        float f = BridgeUtilsKt.safeValue-YgX7TsA$default(BridgeUtilsKt.getDp(jBValue), 0.0f, 1, null);
        int other$iv = 2;
        boolean bl = false;
        return CornerSizeKt.CornerSize-0680j_4((float)Dp.constructor-impl((float)($v$c$androidx-compose-ui-unit-Dp$-this$0$iv / (float)other$iv)));
    }

    public static final float getBorderWidth() {
        JBValue jBValue = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"LW");
        return BridgeUtilsKt.safeValue-YgX7TsA$default(BridgeUtilsKt.getDp(jBValue), 0.0f, 1, null);
    }
}

