/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.ui.unit.Dp;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeButtonKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeDividerKt;
import org.jetbrains.jewel.ui.component.styling.ButtonStyle;
import org.jetbrains.jewel.ui.component.styling.SplitButtonColors;
import org.jetbrains.jewel.ui.component.styling.SplitButtonMetrics;
import org.jetbrains.jewel.ui.component.styling.SplitButtonStyle;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0005\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"dividerPadding", "", "getDividerPadding", "()I", "readOutlinedSplitButtonStyle", "Lorg/jetbrains/jewel/ui/component/styling/SplitButtonStyle;", "readDefaultSplitButtonStyle", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridgeSplitButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridgeSplitButton.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeSplitButtonKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,40:1\n122#2:41\n122#2:42\n*S KotlinDebug\n*F\n+ 1 IntUiBridgeSplitButton.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeSplitButtonKt\n*L\n26#1:41\n38#1:42\n*E\n"})
public final class IntUiBridgeSplitButtonKt {
    private static final int getDividerPadding() {
        return BridgeUtilsKt.isNewUiTheme() ? 4 : 1;
    }

    @NotNull
    public static final SplitButtonStyle readOutlinedSplitButtonStyle() {
        ButtonStyle buttonStyle = IntUiBridgeButtonKt.readOutlinedButtonStyle();
        Color color = JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"buttonOutlineColorStart(...)");
        long l = BridgeUtilsKt.toComposeColor(color);
        Color color2 = JBUI.CurrentTheme.Button.disabledOutlineColor();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"disabledOutlineColor(...)");
        long l2 = BridgeUtilsKt.toComposeColor(color2);
        Color color3 = JBUI.CurrentTheme.Button.Split.Default.ICON_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"ICON_COLOR");
        int $this$dp$iv = IntUiBridgeSplitButtonKt.getDividerPadding();
        boolean $i$f$getDp = false;
        return new SplitButtonStyle(buttonStyle, new SplitButtonColors(l, l2, BridgeUtilsKt.toComposeColor(color3), null), new SplitButtonMetrics(IntUiBridgeDividerKt.readDividerStyle().getMetrics(), Dp.constructor-impl((float)$this$dp$iv), null));
    }

    @NotNull
    public static final SplitButtonStyle readDefaultSplitButtonStyle() {
        ButtonStyle buttonStyle = IntUiBridgeButtonKt.readDefaultButtonStyle();
        long l = BridgeUtilsKt.retrieveColorOrUnspecified("Button.Split.default.separatorColor");
        Color color = JBUI.CurrentTheme.Button.disabledOutlineColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"disabledOutlineColor(...)");
        long l2 = BridgeUtilsKt.toComposeColor(color);
        Color color2 = JBUI.CurrentTheme.Button.Split.Default.ICON_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"ICON_COLOR");
        int $this$dp$iv = IntUiBridgeSplitButtonKt.getDividerPadding();
        boolean $i$f$getDp = false;
        return new SplitButtonStyle(buttonStyle, new SplitButtonColors(l, l2, BridgeUtilsKt.toComposeColor(color2), null), new SplitButtonMetrics(IntUiBridgeDividerKt.readDividerStyle().getMetrics(), Dp.constructor-impl((float)$this$dp$iv), null));
    }
}

