/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import java.io.StringReader;
import java.util.Collection;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0019J\u0006\u0010!\u001a\u00020\u0019J\"\u0010\"\u001a\u00020\u00192\b\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\tH\u0016J \u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u00140\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/mcpserver/util/HtmlToMarkdownConverter;", "Ljavax/swing/text/html/HTMLEditorKit$ParserCallback;", "<init>", "()V", "markdownBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "listStack", "Lcom/intellij/util/containers/Stack;", "", "inSaveSpaces", "inBlockquote", "rowCount", "trimNextTextIndent", "", "cellCountInRow", "href", "", "lineEnd", "endTerminators", "Lkotlin/Pair;", "Ljavax/swing/text/html/HTML$Tag;", "convert", "html", "handleText", "", "data", "", "pos", "generateLineEnd", "addNewLine", "addNewLineIfNeeded", "addLineSeparator", "addSpaceIfNeeded", "handleSimpleTag", "t", "a", "Ljavax/swing/text/MutableAttributeSet;", "handleStartTag", "handleEndTag", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nHtmlToMarkdownConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlToMarkdownConverter.kt\ncom/intellij/mcpserver/util/HtmlToMarkdownConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
final class HtmlToMarkdownConverter
extends HTMLEditorKit.ParserCallback {
    @NotNull
    private final StringBuilder markdownBuilder = new StringBuilder();
    @NotNull
    private Stack<Integer> listStack = new Stack();
    private int inSaveSpaces;
    private int inBlockquote;
    private int rowCount;
    private boolean trimNextTextIndent;
    private int cellCountInRow;
    @NotNull
    private String href = "";
    @NotNull
    private String lineEnd = "\n";
    @NotNull
    private Stack<Pair<HTML.Tag, String>> endTerminators = new Stack();

    @NotNull
    public final String convert(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        StringReader reader = new StringReader(html);
        ParserDelegator parserDelegator = new ParserDelegator();
        parserDelegator.parse(reader, this, true);
        String string = this.markdownBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @Override
    public void handleText(@NotNull char[] data, int pos) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String text = new String(data);
        if (this.inSaveSpaces <= 0) {
            CharSequence charSequence = text;
            Regex regex = new Regex("\\s+");
            String string = " ";
            text = regex.replace(charSequence, string);
        }
        if (this.trimNextTextIndent) {
            text = StringsKt.trimIndent((String)text);
            this.trimNextTextIndent = false;
        }
        this.markdownBuilder.append(text);
    }

    public final void generateLineEnd() {
        StringBuilder b = new StringBuilder("\n");
        int n = this.inBlockquote;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            b.append("> ");
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.lineEnd = string;
    }

    public final void addNewLine() {
        this.markdownBuilder.append(this.lineEnd);
    }

    public final void addNewLineIfNeeded() {
        if (((CharSequence)this.markdownBuilder).length() > 0) {
            String string = this.markdownBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (!StringsKt.endsWith$default((String)string, (String)this.lineEnd, (boolean)false, (int)2, null)) {
                this.addNewLine();
            }
        }
    }

    public final void addLineSeparator() {
        if (((CharSequence)this.markdownBuilder).length() > 0) {
            String string = this.markdownBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (!StringsKt.endsWith$default((String)string, (String)(this.lineEnd + this.lineEnd), (boolean)false, (int)2, null)) {
                this.markdownBuilder.append(this.lineEnd);
            }
        }
    }

    public final void addSpaceIfNeeded() {
        if (((CharSequence)this.markdownBuilder).length() > 0 && StringsKt.last((CharSequence)this.markdownBuilder) != ' ') {
            this.markdownBuilder.append(' ');
        }
    }

    @Override
    public void handleSimpleTag(@Nullable HTML.Tag t, @NotNull MutableAttributeSet a, int pos) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        HTML.Tag tag = t;
        if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.BR)) {
            this.addNewLine();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.IMG)) {
            String alt;
            Object object = a.getAttribute(HTML.Attribute.SRC);
            String src = object instanceof String ? (String)object : null;
            Object object2 = a.getAttribute(HTML.Attribute.ALT);
            String string = object2 instanceof String ? (String)object2 : null;
            if (string == null) {
                string = alt = "";
            }
            if (src != null) {
                this.markdownBuilder.append("![" + alt + "](" + src + ")");
            }
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.INPUT)) {
            String inputType;
            Object alt = a.getAttribute(HTML.Attribute.TYPE);
            String string = inputType = alt instanceof String ? (String)alt : null;
            if (StringUtil.equalsIgnoreCase((CharSequence)inputType, (CharSequence)"checkbox")) {
                boolean isChecked = a.getAttribute(HTML.Attribute.CHECKED) != null;
                this.addSpaceIfNeeded();
                this.markdownBuilder.append("[" + (isChecked ? "x" : " ") + "] ");
                this.trimNextTextIndent = true;
            }
        } else if (tag instanceof HTML.UnknownTag && Intrinsics.areEqual((Object)((HTML.UnknownTag)t).toString(), (Object)"latex_unknown_tag") && a.getAttribute("latex_text") != null) {
            Object object = a.getAttribute("latex_text");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String latex = (String)object;
            this.markdownBuilder.append(latex);
        }
    }

    @Override
    public void handleStartTag(@NotNull HTML.Tag t, @NotNull MutableAttributeSet a, int pos) {
        String color;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        HTML.Tag tag = t;
        if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H1)) {
            this.markdownBuilder.append("# ");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H2)) {
            this.markdownBuilder.append("## ");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H3)) {
            this.markdownBuilder.append("### ");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H4)) {
            this.markdownBuilder.append("#### ");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H5)) {
            this.markdownBuilder.append("##### ");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H6)) {
            this.markdownBuilder.append("###### ");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.B) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.STRONG)) {
            this.markdownBuilder.append("**");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.I) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.EM)) {
            this.markdownBuilder.append("_");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.S) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.STRIKE)) {
            this.markdownBuilder.append("~~");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.P) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.DIV)) {
            if (this.listStack.isEmpty()) {
                this.addNewLineIfNeeded();
            }
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.UL)) {
            this.listStack.push((Object)0);
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.OL)) {
            this.listStack.push((Object)1);
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.LI)) {
            if (!((Collection)this.listStack).isEmpty()) {
                Integer order;
                this.addNewLineIfNeeded();
                int n = this.listStack.size() - 1;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    this.markdownBuilder.append("    ");
                }
                Integer n3 = order = (Integer)this.listStack.pop();
                if (n3 != null && n3 == 0) {
                    this.markdownBuilder.append("- ");
                } else {
                    this.markdownBuilder.append(order + ". ");
                    order = order + 1;
                }
                this.trimNextTextIndent = true;
                this.listStack.push((Object)order);
            }
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.PRE)) {
            ++this.inSaveSpaces;
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.CODE)) {
            if (this.inSaveSpaces > 0) {
                this.addNewLineIfNeeded();
                this.markdownBuilder.append("```");
                this.addNewLine();
            } else {
                this.markdownBuilder.append("`");
            }
            ++this.inSaveSpaces;
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.A)) {
            Object object = a.getAttribute(HTML.Attribute.HREF);
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                string = "";
            }
            this.href = string;
            this.markdownBuilder.append("[");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.BLOCKQUOTE)) {
            ++this.inBlockquote;
            this.generateLineEnd();
            this.addNewLine();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TABLE)) {
            this.rowCount = 0;
            this.cellCountInRow = 0;
            this.addNewLineIfNeeded();
            this.addNewLine();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TR)) {
            ++this.rowCount;
            this.cellCountInRow = 0;
            this.addNewLineIfNeeded();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TD) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TH)) {
            ++this.cellCountInRow;
            this.markdownBuilder.append("| ");
            this.trimNextTextIndent = true;
        }
        Ref.ObjectRef terminator = new Ref.ObjectRef();
        terminator.element = "";
        Object object = a.getAttribute(HTML.Attribute.COLOR);
        String string = color = object instanceof String ? (String)object : null;
        if (color != null) {
            this.markdownBuilder.append("<span style=\"color:" + color + "\">");
            HtmlToMarkdownConverter.handleStartTag$checkStrike(a, this, (Ref.ObjectRef<String>)terminator);
            terminator.element = terminator.element + "</span>";
        } else {
            HtmlToMarkdownConverter.handleStartTag$checkStrike(a, this, (Ref.ObjectRef<String>)terminator);
        }
        this.endTerminators.push((Object)new Pair((Object)t, terminator.element));
    }

    @Override
    public void handleEndTag(@NotNull HTML.Tag t, int pos) {
        HTML.Tag tag;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!((Collection)this.endTerminators).isEmpty()) {
            tag = (Pair)this.endTerminators.pop();
            HTML.Tag tag2 = (HTML.Tag)tag.component1();
            String terminator = (String)tag.component2();
            if (((CharSequence)terminator).length() > 0) {
                this.markdownBuilder.append(terminator);
            }
        }
        if (Intrinsics.areEqual((Object)(tag = t), (Object)HTML.Tag.H1) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H2) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H3) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H4) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H5) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.H6)) {
            this.addNewLineIfNeeded();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.B) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.STRONG)) {
            this.markdownBuilder.append("**");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.I) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.EM)) {
            this.markdownBuilder.append("_");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.S) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.STRIKE)) {
            this.markdownBuilder.append("~~");
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.P) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.DIV)) {
            this.addNewLineIfNeeded();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.A)) {
            this.markdownBuilder.append("](" + this.href + ")");
            this.href = "";
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.BLOCKQUOTE)) {
            this.inBlockquote += -1;
            this.generateLineEnd();
            this.addNewLine();
            this.addNewLine();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.UL) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.OL)) {
            this.listStack.pop();
            this.addLineSeparator();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.LI)) {
            this.addNewLineIfNeeded();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.PRE)) {
            this.inSaveSpaces += -1;
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.CODE)) {
            this.inSaveSpaces += -1;
            if (this.inSaveSpaces > 0) {
                this.addNewLineIfNeeded();
                this.markdownBuilder.append("```");
                this.addNewLine();
            } else {
                this.markdownBuilder.append("`");
            }
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TABLE)) {
            this.addNewLineIfNeeded();
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TR)) {
            this.markdownBuilder.append("|");
            this.addNewLine();
            if (this.rowCount == 1 && this.cellCountInRow > 0) {
                int n = this.cellCountInRow;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    this.markdownBuilder.append("| --- ");
                }
                this.markdownBuilder.append("|");
                this.addNewLine();
            }
        } else if (Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TD) || Intrinsics.areEqual((Object)tag, (Object)HTML.Tag.TH)) {
            this.markdownBuilder.append(" ");
            this.trimNextTextIndent = true;
        }
    }

    private static final void handleStartTag$checkStrike(MutableAttributeSet $a, HtmlToMarkdownConverter this$0, Ref.ObjectRef<String> terminator) {
        String clazz;
        Object object = $a.getAttribute(HTML.Attribute.CLASS);
        String string = clazz = object instanceof String ? (String)object : null;
        if (clazz != null && StringsKt.indexOf$default((CharSequence)clazz, (String)"user-del", (int)0, (boolean)false, (int)6, null) >= 0) {
            this$0.markdownBuilder.append("~~");
            terminator.element = terminator.element + "~~";
        }
    }
}

