/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.HighlighterStorage;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "Lcom/jetbrains/rdclient/daemon/HighlighterStorage;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "queueDeletion", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "flushNotDeleted", "", "recycle", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nRecyclingHighlighterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecyclingHighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,69:1\n1915#2,2:70\n67#3,4:72\n13#3:77\n13#4:76\n*S KotlinDebug\n*F\n+ 1 RecyclingHighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage\n*L\n44#1:70,2\n63#1:72,4\n23#1:77\n23#1:76\n*E\n"})
public final class RecyclingHighlighterStorage
extends HighlighterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final MarkupModelEx ideaMarkup;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Boolean> queuedForDeletionKey;

    public RecyclingHighlighterStorage(@NotNull CompoundHighlighterModelsHandler compoundHandler, @NotNull MarkupModelEx ideaMarkup, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(lifetime);
        this.compoundHandler = compoundHandler;
        this.ideaMarkup = ideaMarkup;
    }

    @Override
    public void queueDeletion(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super.queueDeletion(highlighter);
        RecyclingHighlighterStorage.Companion.setQueuedForDeletion((RangeHighlighter)highlighter, true);
    }

    @Override
    @NotNull
    public List<RangeHighlighterEx> flushNotDeleted() {
        List<RangeHighlighterEx> notDeleted = super.flushNotDeleted();
        Iterable $this$forEach$iv = notDeleted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
            boolean bl = false;
            RecyclingHighlighterStorage.Companion.setQueuedForDeletion((RangeHighlighter)it, false);
        }
        return notDeleted;
    }

    @Nullable
    public final RangeHighlighterEx recycle(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        if (this.getQueuedForDeletion().isEmpty()) {
            return null;
        }
        IProtocolHighlighterModelHandler handler = this.compoundHandler.getHandler(model2);
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        this.ideaMarkup.processRangeHighlightersOverlappingWith(model2.getStart(), model2.getStart(), arg_0 -> RecyclingHighlighterStorage.recycle$lambda$1(arg_0 -> RecyclingHighlighterStorage.recycle$lambda$0(handler, model2, result2, arg_0), arg_0));
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)result2.element;
        if (rangeHighlighterEx == null) {
            return null;
        }
        RangeHighlighterEx recycled = rangeHighlighterEx;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Successfully recycled highlighter for " + HighlightersUtilKt.prettyPrint((RangeHighlighter)recycled));
        }
        this.getQueuedForDeletion().remove(recycled);
        RecyclingHighlighterStorage.Companion.setQueuedForDeletion((RangeHighlighter)recycled, false);
        this.addHighlighter(model2.getId(), recycled);
        return recycled;
    }

    private static final boolean recycle$lambda$0(IProtocolHighlighterModelHandler $handler, HighlighterModel $model, Ref.ObjectRef $result, RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNull((Object)highlighter);
        if ($handler.compare($model, (RangeHighlighter)highlighter) && RecyclingHighlighterStorage.Companion.isQueuedForDeletion((RangeHighlighter)highlighter)) {
            $result.element = highlighter;
            return false;
        }
        return true;
    }

    private static final boolean recycle$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RecyclingHighlighterStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RecyclingHighlighterStorage.logger = logger;
        queuedForDeletionKey = new Key("FrontendHighlighterStorage.QueuedForDeletion");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u00020\b*\u00020\u000b2\u0006\u0010\t\u001a\u00020\b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "queuedForDeletionKey", "Lcom/intellij/openapi/util/Key;", "", "value", "isQueuedForDeletion", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Z", "setQueuedForDeletion", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Z)V", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isQueuedForDeletion(RangeHighlighter $this$isQueuedForDeletion) {
            Boolean bl = (Boolean)$this$isQueuedForDeletion.getUserData(queuedForDeletionKey);
            return bl != null ? bl : false;
        }

        private final void setQueuedForDeletion(RangeHighlighter $this$isQueuedForDeletion, boolean value) {
            Boolean nullableValue = value ? Boolean.valueOf(true) : null;
            $this$isQueuedForDeletion.putUserData(queuedForDeletionKey, (Object)nullableValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

