/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.diagnostics;

import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.jetbrains.rd.ide.model.ChangeReason;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rdclient.diagnostics.ActionRequestFusData;
import com.jetbrains.rdclient.diagnostics.UtilsKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001(B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\tJ\u000e\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rdclient/diagnostics/ConflictTracker;", "", "sessionType", "Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "backendChangeReason", "Lcom/jetbrains/rd/ide/model/ChangeReason;", "backendChangeReasonExtra", "", "backendBatchSize", "", "batchSize", "<init>", "(Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;Lcom/jetbrains/rd/ide/model/ChangeReason;Ljava/lang/String;II)V", "getSessionType", "()Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "getBackendChangeReason", "()Lcom/jetbrains/rd/ide/model/ChangeReason;", "getBackendChangeReasonExtra", "()Ljava/lang/String;", "getBackendBatchSize", "()I", "getBatchSize", "startTime", "", "primaryConflict", "Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;", "getPrimaryConflict", "()Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;", "setPrimaryConflict", "(Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;)V", "restoredChangesCount", "totalConflictsCount", "trackConflict", "", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "conflicts", "trackRestoredChanges", "count", "reportSummary", "ConflictEvent", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nConflictTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConflictTracker.kt\ncom/jetbrains/rdclient/diagnostics/ConflictTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class ConflictTracker {
    @NotNull
    private final SyncEventsLogger.RebaseSessionType sessionType;
    @Nullable
    private final ChangeReason backendChangeReason;
    @Nullable
    private final String backendChangeReasonExtra;
    private final int backendBatchSize;
    private final int batchSize;
    private final long startTime;
    @Nullable
    private ConflictEvent primaryConflict;
    private int restoredChangesCount;
    private int totalConflictsCount;

    public ConflictTracker(@NotNull SyncEventsLogger.RebaseSessionType sessionType, @Nullable ChangeReason backendChangeReason, @Nullable String backendChangeReasonExtra, int backendBatchSize, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        this.sessionType = sessionType;
        this.backendChangeReason = backendChangeReason;
        this.backendChangeReasonExtra = backendChangeReasonExtra;
        this.backendBatchSize = backendBatchSize;
        this.batchSize = batchSize;
        this.startTime = System.nanoTime();
    }

    public /* synthetic */ ConflictTracker(SyncEventsLogger.RebaseSessionType rebaseSessionType, ChangeReason changeReason, String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            rebaseSessionType = SyncEventsLogger.RebaseSessionType.OTHER;
        }
        if ((n3 & 2) != 0) {
            changeReason = null;
        }
        if ((n3 & 4) != 0) {
            string = null;
        }
        if ((n3 & 8) != 0) {
            n = 0;
        }
        this(rebaseSessionType, changeReason, string, n, n2);
    }

    @NotNull
    public final SyncEventsLogger.RebaseSessionType getSessionType() {
        return this.sessionType;
    }

    @Nullable
    public final ChangeReason getBackendChangeReason() {
        return this.backendChangeReason;
    }

    @Nullable
    public final String getBackendChangeReasonExtra() {
        return this.backendChangeReasonExtra;
    }

    public final int getBackendBatchSize() {
        return this.backendBatchSize;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public final ConflictEvent getPrimaryConflict() {
        return this.primaryConflict;
    }

    public final void setPrimaryConflict(@Nullable ConflictEvent conflictEvent) {
        this.primaryConflict = conflictEvent;
    }

    public final void trackConflict(@Nullable FrontendAsyncRequest request, int conflicts) {
        ActionRequestFusData actionRequestFusData;
        if (conflicts <= 0) {
            return;
        }
        this.totalConflictsCount += conflicts;
        FrontendAsyncRequest frontendAsyncRequest = request;
        Class<?> requestType = frontendAsyncRequest != null ? frontendAsyncRequest.getClass() : null;
        FrontendAsyncRequest frontendAsyncRequest2 = request;
        ActionRequestFusData actionRequestFusData2 = actionRequestFusData = frontendAsyncRequest2 != null ? UtilsKt.actionRequestFusData(frontendAsyncRequest2) : null;
        if (this.primaryConflict == null) {
            this.primaryConflict = new ConflictEvent(conflicts, requestType, actionRequestFusData);
        }
        SyncEventsLogger.INSTANCE.getCONFLICT_EVENT().log(null, arg_0 -> ConflictTracker.trackConflict$lambda$0(this, requestType, actionRequestFusData, conflicts, arg_0));
    }

    public final void trackRestoredChanges(int count) {
        this.restoredChangesCount += count;
    }

    public final void reportSummary() {
        if (this.totalConflictsCount == 0) {
            return;
        }
        ConflictEvent primaryConflict = this.primaryConflict;
        if (primaryConflict == null) {
            boolean $i$a$-requireNotNull-ConflictTracker$reportSummary$22 = false;
            String $i$a$-requireNotNull-ConflictTracker$reportSummary$22 = "totalConflictsCount > 0 but primaryConflict is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ConflictTracker$reportSummary$22.toString());
        }
        long duration = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)(System.nanoTime() - this.startTime), (DurationUnit)DurationUnit.NANOSECONDS));
        int cancelledChanges = this.totalConflictsCount - this.restoredChangesCount;
        ActionRequestFusData actionRequestFusData = primaryConflict.getActionRequestFusData();
        SyncEventsLogger.INSTANCE.getREBASE_EVENT().log(null, arg_0 -> ConflictTracker.reportSummary$lambda$1(this, primaryConflict, actionRequestFusData, duration, cancelledChanges, arg_0));
    }

    private static final Unit trackConflict$lambda$0(ConflictTracker this$0, Class $requestType, ActionRequestFusData $actionRequestFusData, int $conflicts, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        SyncEventsLogger.INSTANCE.withRebaseSessionType((List)$this$log, this$0.sessionType);
        SyncEventsLogger.INSTANCE.withRequestType((List)$this$log, $requestType);
        ActionRequestFusData actionRequestFusData = $actionRequestFusData;
        SyncEventsLogger.INSTANCE.withActionId((List)$this$log, actionRequestFusData != null ? actionRequestFusData.getActionId() : null);
        SyncEventsLogger.INSTANCE.withConflictStats((List)$this$log, $conflicts);
        SyncEventsLogger.INSTANCE.withBackendChangeReason((List)$this$log, this$0.backendChangeReason, this$0.backendChangeReasonExtra, Integer.valueOf(this$0.backendBatchSize));
        ActionRequestFusData actionRequestFusData2 = $actionRequestFusData;
        ActionRequestFusData actionRequestFusData3 = $actionRequestFusData;
        ActionRequestFusData actionRequestFusData4 = $actionRequestFusData;
        SyncEventsLogger.INSTANCE.withFileTypeAndLanguage((List)$this$log, (FileType)(actionRequestFusData2 != null ? actionRequestFusData2.getFileType() : null), (Language)(actionRequestFusData3 != null ? actionRequestFusData3.getFileLanguage() : null), (Language)(actionRequestFusData4 != null ? actionRequestFusData4.getInjectedLanguage() : null));
        return Unit.INSTANCE;
    }

    private static final Unit reportSummary$lambda$1(ConflictTracker this$0, ConflictEvent $primaryConflict, ActionRequestFusData $actionRequestFusData, long $duration, int $cancelledChanges, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        SyncEventsLogger.INSTANCE.withRebaseSessionType((List)$this$log, this$0.sessionType);
        SyncEventsLogger.INSTANCE.withRequestType((List)$this$log, $primaryConflict.getRequestType());
        ActionRequestFusData actionRequestFusData = $actionRequestFusData;
        SyncEventsLogger.INSTANCE.withActionId((List)$this$log, actionRequestFusData != null ? actionRequestFusData.getActionId() : null);
        SyncEventsLogger.INSTANCE.withDuration((List)$this$log, $duration);
        SyncEventsLogger.INSTANCE.withRebaseStats((List)$this$log, this$0.totalConflictsCount, this$0.restoredChangesCount, $cancelledChanges, this$0.batchSize);
        SyncEventsLogger.INSTANCE.withBackendChangeReason((List)$this$log, this$0.backendChangeReason, this$0.backendChangeReasonExtra, Integer.valueOf(this$0.backendBatchSize));
        ActionRequestFusData actionRequestFusData2 = $actionRequestFusData;
        ActionRequestFusData actionRequestFusData3 = $actionRequestFusData;
        ActionRequestFusData actionRequestFusData4 = $actionRequestFusData;
        SyncEventsLogger.INSTANCE.withFileTypeAndLanguage((List)$this$log, (FileType)(actionRequestFusData2 != null ? actionRequestFusData2.getFileType() : null), (Language)(actionRequestFusData3 != null ? actionRequestFusData3.getFileLanguage() : null), (Language)(actionRequestFusData4 != null ? actionRequestFusData4.getInjectedLanguage() : null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;", "", "conflictsCount", "", "requestType", "Ljava/lang/Class;", "actionRequestFusData", "Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "<init>", "(ILjava/lang/Class;Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;)V", "getConflictsCount", "()I", "getRequestType", "()Ljava/lang/Class;", "getActionRequestFusData", "()Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rd.client"})
    public static final class ConflictEvent {
        private final int conflictsCount;
        @Nullable
        private final Class<?> requestType;
        @Nullable
        private final ActionRequestFusData actionRequestFusData;

        public ConflictEvent(int conflictsCount, @Nullable Class<?> requestType, @Nullable ActionRequestFusData actionRequestFusData) {
            this.conflictsCount = conflictsCount;
            this.requestType = requestType;
            this.actionRequestFusData = actionRequestFusData;
        }

        public final int getConflictsCount() {
            return this.conflictsCount;
        }

        @Nullable
        public final Class<?> getRequestType() {
            return this.requestType;
        }

        @Nullable
        public final ActionRequestFusData getActionRequestFusData() {
            return this.actionRequestFusData;
        }

        public final int component1() {
            return this.conflictsCount;
        }

        @Nullable
        public final Class<?> component2() {
            return this.requestType;
        }

        @Nullable
        public final ActionRequestFusData component3() {
            return this.actionRequestFusData;
        }

        @NotNull
        public final ConflictEvent copy(int conflictsCount, @Nullable Class<?> requestType, @Nullable ActionRequestFusData actionRequestFusData) {
            return new ConflictEvent(conflictsCount, requestType, actionRequestFusData);
        }

        public static /* synthetic */ ConflictEvent copy$default(ConflictEvent conflictEvent, int n, Class clazz, ActionRequestFusData actionRequestFusData, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = conflictEvent.conflictsCount;
            }
            if ((n2 & 2) != 0) {
                clazz = conflictEvent.requestType;
            }
            if ((n2 & 4) != 0) {
                actionRequestFusData = conflictEvent.actionRequestFusData;
            }
            return conflictEvent.copy(n, clazz, actionRequestFusData);
        }

        @NotNull
        public String toString() {
            return "ConflictEvent(conflictsCount=" + this.conflictsCount + ", requestType=" + this.requestType + ", actionRequestFusData=" + this.actionRequestFusData + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.conflictsCount);
            result2 = result2 * 31 + (this.requestType == null ? 0 : this.requestType.hashCode());
            result2 = result2 * 31 + (this.actionRequestFusData == null ? 0 : this.actionRequestFusData.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConflictEvent)) {
                return false;
            }
            ConflictEvent conflictEvent = (ConflictEvent)other;
            if (this.conflictsCount != conflictEvent.conflictsCount) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requestType, conflictEvent.requestType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.actionRequestFusData, (Object)conflictEvent.actionRequestFusData);
        }
    }
}

