/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.AesEncryptionSupport;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupport;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.PgpKeyEncryptionSupport;
import com.intellij.credentialStore.WindowsCrypt32EncryptionSupport;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0019\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"builtInEncryptionKey", "Ljavax/crypto/spec/SecretKeySpec;", "getDefaultEncryptionType", "Lcom/intellij/credentialStore/EncryptionType;", "createEncryptionSupport", "Lcom/intellij/credentialStore/EncryptionSupport;", "spec", "Lcom/intellij/credentialStore/EncryptionSpec;", "createBuiltInOrCrypt32EncryptionSupport", "isCrypt32", "", "toByteArrayAndClear", "", "", "intellij.platform.credentialStore.impl"})
public final class EncryptionSupportKt {
    @NotNull
    private static final SecretKeySpec builtInEncryptionKey;

    @ApiStatus.Internal
    @NotNull
    public static final EncryptionType getDefaultEncryptionType() {
        return SystemInfo.isWindows ? EncryptionType.CRYPT_32 : EncryptionType.BUILT_IN;
    }

    @NotNull
    public static final EncryptionSupport createEncryptionSupport(@NotNull EncryptionSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        return switch (WhenMappings.$EnumSwitchMapping$0[spec.getType().ordinal()]) {
            case 1 -> EncryptionSupportKt.createBuiltInOrCrypt32EncryptionSupport(false);
            case 2 -> EncryptionSupportKt.createBuiltInOrCrypt32EncryptionSupport(true);
            case 3 -> new PgpKeyEncryptionSupport(spec);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final EncryptionSupport createBuiltInOrCrypt32EncryptionSupport(boolean isCrypt32) {
        if (isCrypt32) {
            if (!SystemInfo.isWindows) {
                throw new IllegalArgumentException("Crypt32 encryption is supported only on Windows");
            }
            if (JnaLoader.isLoaded()) {
                return new WindowsCrypt32EncryptionSupport(builtInEncryptionKey);
            }
        }
        return new AesEncryptionSupport(builtInEncryptionKey);
    }

    @NotNull
    public static final byte[] toByteArrayAndClear(@NotNull char[] $this$toByteArrayAndClear) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArrayAndClear, (String)"<this>");
        CharBuffer charBuffer = CharBuffer.wrap($this$toByteArrayAndClear);
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(charBuffer);
        ArraysKt.fill$default((char[])$this$toByteArrayAndClear, (char)'\u0000', (int)0, (int)0, (int)6, null);
        Intrinsics.checkNotNull((Object)byteBuffer);
        return IoKt.toByteArray((ByteBuffer)byteBuffer, (boolean)true);
    }

    static {
        byte[] byArray = new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99};
        builtInEncryptionKey = new SecretKeySpec(byArray, "AES");
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionType.values().length];
            try {
                nArray[EncryptionType.BUILT_IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionType.CRYPT_32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionType.PGP_KEY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

