/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.gpg;

import com.intellij.credentialStore.gpg.GpgToolWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0003J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/credentialStore/gpg/GpgToolWrapperImpl;", "Lcom/intellij/credentialStore/gpg/GpgToolWrapper;", "gpgPath", "", "timeoutInMilliseconds", "", "<init>", "(Ljava/lang/String;I)V", "version", "listSecretKeys", "encrypt", "", "data", "recipient", "decrypt", "createCommandLineForEncodeOrDecode", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "doEncryptOrDecrypt", "commandLine", "doExecute", "createCommandLine", "isAddStringOutputRelatedOptions", "", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nGpgToolWrapperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgToolWrapperImpl.kt\ncom/intellij/credentialStore/gpg/GpgToolWrapperImpl\n+ 2 GpgToolWrapperImpl.kt\ncom/intellij/credentialStore/gpg/GpgToolWrapperImplKt\n*L\n1#1,130:1\n128#2:131\n128#2:132\n128#2:133\n*S KotlinDebug\n*F\n+ 1 GpgToolWrapperImpl.kt\ncom/intellij/credentialStore/gpg/GpgToolWrapperImpl\n*L\n61#1:131\n66#1:132\n71#1:133\n*E\n"})
public final class GpgToolWrapperImpl
implements GpgToolWrapper {
    @NotNull
    private final String gpgPath;
    private final int timeoutInMilliseconds;

    public GpgToolWrapperImpl(@NotNull String gpgPath, int timeoutInMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)gpgPath, (String)"gpgPath");
        this.gpgPath = gpgPath;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public /* synthetic */ GpgToolWrapperImpl(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "gpg";
        }
        if ((n2 & 2) != 0) {
            n = 5000;
        }
        this(string, n);
    }

    @NotNull
    public final String version() {
        GeneralCommandLine commandLine = GpgToolWrapperImpl.createCommandLine$default(this, false, 1, null);
        commandLine.addParameter("--version");
        return this.doExecute(commandLine);
    }

    @Override
    @NotNull
    public String listSecretKeys() {
        GeneralCommandLine commandLine = GpgToolWrapperImpl.createCommandLine$default(this, false, 1, null);
        commandLine.addParameter("--list-secret-keys");
        return this.doExecute(commandLine);
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data, @NotNull String recipient) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        GeneralCommandLine commandLine = this.createCommandLineForEncodeOrDecode();
        commandLine.addParameter("--encrypt");
        commandLine.addParameter("--recipient");
        commandLine.addParameter(recipient);
        return this.doEncryptOrDecrypt(commandLine, data);
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        GeneralCommandLine commandLine = this.createCommandLineForEncodeOrDecode();
        commandLine.addParameter("--decrypt");
        return this.doEncryptOrDecrypt(commandLine, data);
    }

    private final GeneralCommandLine createCommandLineForEncodeOrDecode() {
        GeneralCommandLine result = this.createCommandLine(false);
        result.addParameter("--trust-model");
        result.addParameter("always");
        return result;
    }

    private final byte[] doEncryptOrDecrypt(GeneralCommandLine commandLine, byte[] data) {
        Process process = commandLine.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        Process process2 = process;
        BufferExposingByteArrayOutputStream output = new BufferExposingByteArrayOutputStream();
        BufferExposingByteArrayOutputStream errorOutput = new BufferExposingByteArrayOutputStream();
        try {
            CompletableFuture[] completableFutureArray = new CompletableFuture[3];
            boolean $i$f$runAsync = false;
            Intrinsics.checkNotNullExpressionValue(CompletableFuture.runAsync(new Runnable(process2, data){
                final /* synthetic */ Process $process$inlined;
                final /* synthetic */ byte[] $data$inlined;
                {
                    this.$process$inlined = process;
                    this.$data$inlined = byArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl = false;
                    Closeable closeable = this.$process$inlined.getOutputStream();
                    Throwable throwable = null;
                    try {
                        OutputStream it = (OutputStream)closeable;
                        boolean bl2 = false;
                        it.write(this.$data$inlined);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, AppExecutorUtil.getAppExecutorService()), (String)"runAsync(...)");
            $i$f$runAsync = false;
            Intrinsics.checkNotNullExpressionValue(CompletableFuture.runAsync(new Runnable(process2, output){
                final /* synthetic */ Process $process$inlined;
                final /* synthetic */ BufferExposingByteArrayOutputStream $output$inlined;
                {
                    this.$process$inlined = process;
                    this.$output$inlined = bufferExposingByteArrayOutputStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl = false;
                    Closeable closeable = this.$process$inlined.getInputStream();
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        FileUtilRt.copy((InputStream)it, (OutputStream)((OutputStream)this.$output$inlined));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, AppExecutorUtil.getAppExecutorService()), (String)"runAsync(...)");
            $i$f$runAsync = false;
            Intrinsics.checkNotNullExpressionValue(CompletableFuture.runAsync(new Runnable(process2, errorOutput){
                final /* synthetic */ Process $process$inlined;
                final /* synthetic */ BufferExposingByteArrayOutputStream $errorOutput$inlined;
                {
                    this.$process$inlined = process;
                    this.$errorOutput$inlined = bufferExposingByteArrayOutputStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl = false;
                    Closeable closeable = this.$process$inlined.getErrorStream();
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        FileUtilRt.copy((InputStream)it, (OutputStream)((OutputStream)this.$errorOutput$inlined));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, AppExecutorUtil.getAppExecutorService()), (String)"runAsync(...)");
            CompletableFuture.allOf(completableFutureArray).get(3L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            String string = commandLine.getCommandLineString();
            byte[] byArray = errorOutput.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            throw new RuntimeException("Cannot execute " + string + "\nerror output: " + new String(byArray2, charset), e.getCause());
        }
        if (!process2.waitFor(5L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Cannot execute " + this.gpgPath + ": timeout");
        }
        int exitCode = process2.exitValue();
        if (exitCode != 0) {
            String string = commandLine.getCommandLineString();
            byte[] byArray = errorOutput.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] e = byArray;
            Charset charset = Charsets.UTF_8;
            throw new RuntimeException("Cannot execute " + string + "\nexit code " + exitCode + ", error output: " + new String(e, charset));
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] result = byArray;
        byte[] byArray3 = output.getInternalBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getInternalBuffer(...)");
        byte[] internalBuffer = byArray3;
        if (result != internalBuffer) {
            ArraysKt.fill$default((byte[])internalBuffer, (byte)0, (int)0, (int)0, (int)6, null);
        }
        return result;
    }

    private final String doExecute(GeneralCommandLine commandLine) {
        ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)this.timeoutInMilliseconds);
        int exitCode = processOutput.getExitCode();
        if (exitCode != 0) {
            throw new RuntimeException("Cannot execute " + this.gpgPath + ": exit code " + exitCode + ", error output: " + processOutput.getStderr());
        }
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return string;
    }

    private final GeneralCommandLine createCommandLine(boolean isAddStringOutputRelatedOptions) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.gpgPath);
        if (isAddStringOutputRelatedOptions) {
            commandLine.addParameter("--with-colons");
            commandLine.addParameter("--fixed-list-mode");
        }
        commandLine.addParameter("--no-tty");
        commandLine.addParameter("--yes");
        commandLine.addParameter("--display-charset");
        commandLine.addParameter("utf-8");
        return commandLine;
    }

    static /* synthetic */ GeneralCommandLine createCommandLine$default(GpgToolWrapperImpl gpgToolWrapperImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gpgToolWrapperImpl.createCommandLine(bl);
    }

    public GpgToolWrapperImpl() {
        this(null, 0, 3, null);
    }
}

