/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol.startup.parameters;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelParameter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000f\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/NamedKernelParameter;", "T", "", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelParameter;", "aliases", "", "", "<init>", "(Ljava/util/List;)V", "getAliases", "()Ljava/util/List;", "parseValue", "argValue", "previousValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "serializeValue", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "tryParse", "arg", "serialize", "protocol"})
public abstract class NamedKernelParameter<T>
implements KernelParameter<T> {
    @NotNull
    private final List<String> aliases;

    public NamedKernelParameter(@NotNull List<String> aliases) {
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        this.aliases = aliases;
    }

    @NotNull
    public final List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public abstract T parseValue(@NotNull String var1, @Nullable T var2);

    @Nullable
    public abstract String serializeValue(@NotNull T var1);

    @Override
    @Nullable
    public T tryParse(@NotNull String arg, @Nullable T previousValue) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        for (String alias : this.aliases) {
            String prefix = "-" + alias + "=";
            if (!StringsKt.startsWith$default((String)arg, (String)prefix, (boolean)false, (int)2, null)) continue;
            String value = StringsKt.substringAfter$default((String)arg, (String)prefix, null, (int)2, null);
            return this.parseValue(value, previousValue);
        }
        return null;
    }

    @Override
    @Nullable
    public String serialize(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String string = this.serializeValue(value);
        if (string == null) {
            return null;
        }
        String serializedValue = string;
        return "-" + CollectionsKt.first(this.aliases) + "=" + serializedValue;
    }
}

