/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zmq.Msg;
import zmq.pipe.Pipe;
import zmq.util.Blob;
import zmq.util.Errno;
import zmq.util.ValueReference;

public class FQ {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int active = 0;
    private Pipe lastIn;
    private int current = 0;
    private boolean more = false;
    private Blob savedCredential;

    public void attach(Pipe pipe) {
        this.pipes.add(pipe);
        Collections.swap(this.pipes, this.active, this.pipes.size() - 1);
        ++this.active;
    }

    public void terminated(Pipe pipe) {
        int index = this.pipes.indexOf(pipe);
        if (index < this.active) {
            --this.active;
            Collections.swap(this.pipes, index, this.active);
            if (this.current == this.active) {
                this.current = 0;
            }
        }
        this.pipes.remove(pipe);
        if (this.lastIn == pipe) {
            this.savedCredential = this.lastIn.getCredential();
            this.lastIn = null;
        }
    }

    public void activated(Pipe pipe) {
        Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.active);
        ++this.active;
    }

    public Msg recv(Errno errno) {
        return this.recvPipe(errno, null);
    }

    public Msg recvPipe(Errno errno, ValueReference<Pipe> pipe) {
        while (this.active > 0) {
            boolean fetched;
            Pipe currentPipe = this.pipes.get(this.current);
            Msg msg = currentPipe.read();
            boolean bl = fetched = msg != null;
            if (fetched) {
                if (pipe != null) {
                    pipe.set(currentPipe);
                }
                this.more = msg.hasMore();
                if (!this.more) {
                    this.lastIn = currentPipe;
                    assert (this.active > 0);
                    this.current = (this.current + 1) % this.active;
                }
                return msg;
            }
            assert (!this.more);
            --this.active;
            Collections.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        errno.set(35);
        return null;
    }

    public boolean hasIn() {
        if (this.more) {
            return true;
        }
        while (this.active > 0) {
            if (this.pipes.get(this.current).checkRead()) {
                return true;
            }
            --this.active;
            Collections.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        return false;
    }

    public Blob getCredential() {
        return this.lastIn != null ? this.lastIn.getCredential() : this.savedCredential;
    }
}

