/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.registry.cloud;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.platform.registry.cloud.UpdateConfig;
import com.intellij.platform.registry.cloud.dto.ArchKind;
import com.intellij.platform.registry.cloud.dto.OsDto;
import com.intellij.platform.registry.cloud.dto.OsFamily;
import com.intellij.platform.registry.cloud.dto.ProductDto;
import com.intellij.platform.registry.cloud.dto.UpdateDto;
import com.intellij.platform.registry.cloud.dto.VersionDto;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a$\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0002\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0019"}, d2={"ourJson", "Lkotlinx/serialization/json/Json;", "getOurJson$annotations", "()V", "getOurJson", "()Lkotlinx/serialization/json/Json;", "matchesDate", "", "config", "Lcom/intellij/platform/registry/cloud/UpdateConfig;", "updateDto", "Lcom/intellij/platform/registry/cloud/dto/UpdateDto;", "matchesProducts", "matchesOs", "osDto", "Lcom/intellij/platform/registry/cloud/dto/OsDto;", "matchesVersion", "build", "Lcom/intellij/openapi/util/BuildNumber;", "version", "Lcom/intellij/platform/registry/cloud/dto/VersionDto;", "isInRangeInclusive", "buildNumber", "sinceVersion", "untilVersion", "intellij.platform.registry.cloud"})
public final class CommonKt {
    @NotNull
    private static final Json ourJson = JsonKt.Json$default(null, CommonKt::ourJson$lambda$0, (int)1, null);

    @NotNull
    public static final Json getOurJson() {
        return ourJson;
    }

    public static /* synthetic */ void getOurJson$annotations() {
    }

    public static final boolean matchesDate(@NotNull UpdateConfig config, @NotNull UpdateDto updateDto) {
        Instant instant;
        Instant instant2;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)updateDto, (String)"updateDto");
        Instant instant3 = updateDto.getFrom();
        Instant instant4 = updateDto.getUntil();
        if (instant4 == null) {
            instant4 = instant2 = Instant.Companion.getDISTANT_FUTURE();
        }
        return 0 <= ((Comparable)(instant = config.getNow())).compareTo(instant3) ? ((Comparable)instant).compareTo(instant2) <= 0 : false;
    }

    public static final boolean matchesProducts(@NotNull UpdateConfig config, @NotNull UpdateDto updateDto) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)updateDto, (String)"updateDto");
        if (updateDto.getProducts().isEmpty()) {
            return false;
        }
        for (ProductDto p : updateDto.getProducts()) {
            boolean osOk;
            boolean versionOk;
            ProductDto productDto = p;
            if (productDto instanceof ProductDto.Ide) {
                boolean codeMatches = Intrinsics.areEqual((Object)((ProductDto.Ide)p).getCode(), (Object)config.getIdeVersion().getProductCode()) || Intrinsics.areEqual((Object)((ProductDto.Ide)p).getCode(), (Object)"*");
                versionOk = CommonKt.matchesVersion(config.getIdeVersion(), ((ProductDto.Ide)p).getVersion());
                osOk = CommonKt.matchesOs(config, ((ProductDto.Ide)p).getOs());
                if (!codeMatches || !versionOk || !osOk) continue;
                return true;
            }
            if (productDto instanceof ProductDto.Plugin) {
                BuildNumber pluginBuild = config.getPluginVersions().get(((ProductDto.Plugin)p).getId());
                if (pluginBuild == null) continue;
                versionOk = CommonKt.matchesVersion(pluginBuild, ((ProductDto.Plugin)p).getVersion());
                osOk = CommonKt.matchesOs(config, ((ProductDto.Plugin)p).getOs());
                if (!versionOk || !osOk) continue;
                return true;
            }
            throw new NoWhenBranchMatchedException();
        }
        return false;
    }

    private static final boolean matchesOs(UpdateConfig config, OsDto osDto) {
        if (osDto == null) {
            return true;
        }
        boolean isFamilyOk = switch (WhenMappings.$EnumSwitchMapping$0[osDto.getName().ordinal()]) {
            case 1 -> {
                if (config.getOs() == OS.Windows) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (config.getOs() == OS.macOS) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (config.getOs() == OS.Linux) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if (!isFamilyOk) {
            return false;
        }
        ArchKind archKind = osDto.getArch();
        boolean isArchOk = switch (archKind == null ? -1 : WhenMappings.$EnumSwitchMapping$1[archKind.ordinal()]) {
            case 1 -> {
                if (config.getArch() == CpuArch.X86_64) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (config.getArch() == CpuArch.ARM32 || config.getArch() == CpuArch.ARM64) {
                    yield true;
                }
                yield false;
            }
            case -1 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
        return isArchOk;
    }

    private static final boolean matchesVersion(BuildNumber build, VersionDto version) {
        boolean bl;
        VersionDto versionDto = version;
        if (versionDto instanceof VersionDto.Any) {
            bl = true;
        } else if (versionDto instanceof VersionDto.Strict) {
            bl = Intrinsics.areEqual((Object)build, (Object)BuildNumber.fromString((String)((VersionDto.Strict)version).getVersion()));
        } else if (versionDto instanceof VersionDto.Range) {
            bl = CommonKt.isInRangeInclusive(build, BuildNumber.fromString((String)((VersionDto.Range)version).getSince()), BuildNumber.fromString((String)((VersionDto.Range)version).getUntil()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final boolean isInRangeInclusive(BuildNumber buildNumber, BuildNumber sinceVersion, BuildNumber untilVersion) {
        return !(sinceVersion != null && buildNumber.compareTo(sinceVersion) < 0 || untilVersion != null && buildNumber.compareTo(untilVersion) > 0);
    }

    private static final Unit ourJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setAllowComments(true);
        $this$Json.setAllowSpecialFloatingPointValues(true);
        $this$Json.setLenient(true);
        $this$Json.setClassDiscriminator("kind");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OsFamily.values().length];
            try {
                nArray[OsFamily.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OsFamily.MacOs.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OsFamily.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ArchKind.values().length];
            try {
                nArray[ArchKind.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchKind.ARM32_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

