/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.registry.cloud.notifications;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.platform.registry.cloud.notifications.ActionsKt;
import com.intellij.platform.registry.cloud.notifications.CloudRegistryAction;
import com.intellij.platform.registry.cloud.notifications.NotificationInteractor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/registry/cloud/notifications/OpenUrlAction;", "Lcom/intellij/platform/registry/cloud/notifications/CloudRegistryAction;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "performAction", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "", "notification", "Lcom/intellij/platform/registry/cloud/notifications/NotificationInteractor;", "validate", "", "Companion", "intellij.platform.registry.cloud"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 actions.kt\ncom/intellij/platform/registry/cloud/notifications/OpenUrlAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1807#2,3:148\n*S KotlinDebug\n*F\n+ 1 actions.kt\ncom/intellij/platform/registry/cloud/notifications/OpenUrlAction\n*L\n74#1:148,3\n*E\n"})
public final class OpenUrlAction
implements CloudRegistryAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    public static final int $stable;
    @NotNull
    private static final String URL_KEY = "url";

    public OpenUrlAction() {
        this.id = "open.url";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void performAction(@NotNull Project project, @NotNull Map<String, String> context, @NotNull NotificationInteractor notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        String url = context.get(URL_KEY);
        if (url == null) {
            ActionsKt.access$getLog$p().warn("URL is not specified for action: " + this.getId());
            return;
        }
        try {
            BrowserUtil.browse((String)url);
            notification.expire();
        }
        catch (Exception e) {
            ActionsKt.access$getLog$p().warn("Failed to open URL: " + url, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(@NotNull Map<String, String> context) {
        String it;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        List allowedPrefixes = CollectionsKt.listOf((Object)"https://");
        String url = context.get(URL_KEY);
        if (url == null) return false;
        Iterable $this$any$iv = allowedPrefixes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null));
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/registry/cloud/notifications/OpenUrlAction$Companion;", "", "<init>", "()V", "URL_KEY", "", "intellij.platform.registry.cloud"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

