/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewUtil;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.platform.vcs.backend.split.BackendLocalChangesHostKt;
import com.intellij.platform.vcs.backend.split.Node;
import com.intellij.platform.vcs.backend.split.NodeModelRenderer;
import com.intellij.platform.vcs.backend.split.NodePresentationModel;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.LocalChangesWindowModel;
import com.jetbrains.rd.ide.model.RdLocalChangesItem;
import com.jetbrains.rd.ide.model.RdTextChunk;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u0015J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendLocalChangesWindowHandler;", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rd/ide/model/LocalChangesWindowModel;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/LocalChangesWindowModel;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/LocalChangesWindowModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "groupingSupport", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "getGroupingSupport", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "lastNodeId", "", "idToDataMap", "", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "roots", "", "Lcom/intellij/platform/vcs/backend/split/Node;", "getNodeById", "id", "scheduleUpdate", "", "updateTitle", "rebuildTree", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendLocalChangesHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLocalChangesHost.kt\ncom/intellij/platform/vcs/backend/split/BackendLocalChangesWindowHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1915#2,2:282\n1661#2,3:287\n1586#2:290\n1661#2,3:291\n1586#2:294\n1661#2,3:295\n221#3:284\n222#3:286\n1#4:285\n*S KotlinDebug\n*F\n+ 1 BackendLocalChangesHost.kt\ncom/intellij/platform/vcs/backend/split/BackendLocalChangesWindowHandler\n*L\n133#1:282,2\n167#1:287,3\n177#1:290\n177#1:291,3\n183#1:294\n183#1:295,3\n159#1:284\n159#1:286\n*E\n"})
public final class BackendLocalChangesWindowHandler {
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final LocalChangesWindowModel model;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final ChangesGroupingSupport groupingSupport;
    private int lastNodeId;
    @NotNull
    private Map<Integer, ? extends ChangesBrowserNode<?>> idToDataMap;
    @NotNull
    private List<Node> roots;

    public BackendLocalChangesWindowHandler(@NotNull ClientProjectSession session, @NotNull Lifetime lifetime, @NotNull LocalChangesWindowModel model) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.session = session;
        this.model = model;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        this.queue = new MergingUpdateQueue("BackendLocalChangesHost", 300, true, null, this.disposable, null, false, 96, null);
        this.groupingSupport = new ChangesGroupingSupport(this.session.getProject(), (Object)this, false);
        this.idToDataMap = MapsKt.emptyMap();
        this.roots = CollectionsKt.emptyList();
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.model.getShowDiff()), null, null, arg_0 -> BackendLocalChangesWindowHandler._init_$lambda$0(this, arg_0), (int)3, null);
        List list = ChangesTree.DEFAULT_GROUPING_KEYS;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DEFAULT_GROUPING_KEYS");
        this.groupingSupport.setGroupingKeysOrSkip((Collection)CollectionsKt.toSet((Iterable)list));
        this.groupingSupport.addPropertyChangeListener(arg_0 -> BackendLocalChangesWindowHandler._init_$lambda$1(this, arg_0));
        ChangeListManager.getInstance((Project)this.session.getProject()).addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListsChanged() {
                this.scheduleUpdate();
            }
        }, this.disposable);
        this.rebuildTree();
        this.updateTitle();
    }

    @NotNull
    public final LocalChangesWindowModel getModel() {
        return this.model;
    }

    @NotNull
    public final ChangesGroupingSupport getGroupingSupport() {
        return this.groupingSupport;
    }

    @Nullable
    public final ChangesBrowserNode<?> getNodeById(int id) {
        return this.idToDataMap.get(id);
    }

    private final void scheduleUpdate() {
        this.queue.queue(Update.Companion.create((Object)"update", () -> BackendLocalChangesWindowHandler.scheduleUpdate$lambda$0(this)));
    }

    private final void updateTitle() {
        Content content = ChangesViewContentManager.Companion.getInstance(this.session.getProject()).findContent("Local Changes");
        IOptProperty iOptProperty = this.model.getTitle();
        Object object = content;
        if (object == null || (object = object.getDisplayName()) == null) {
            String string = VcsBundle.message((String)"local.changes.tab", (Object[])new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        iOptProperty.set(object);
    }

    private final void rebuildTree() {
        ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendLocalChangesWindowHandler.rebuildTree$lambda$0(this));
    }

    private static final Unit _init_$lambda$0(BackendLocalChangesWindowHandler this$0, int nodeId) {
        ChangesBrowserNode<?> changesBrowserNode = this$0.idToDataMap.get(nodeId);
        if (changesBrowserNode == null) {
            return Unit.INSTANCE;
        }
        ChangesBrowserNode<?> node = changesBrowserNode;
        Object object = node.getUserObject();
        Change change = object instanceof Change ? (Change)object : null;
        if (change == null) {
            return Unit.INSTANCE;
        }
        Change change2 = change;
        ShowDiffAction.showDiffForChange((Project)this$0.session.getProject(), (Iterable)CollectionsKt.listOf((Object)change2));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(BackendLocalChangesWindowHandler this$0, PropertyChangeEvent it) {
        this$0.rebuildTree();
    }

    private static final void scheduleUpdate$lambda$0(BackendLocalChangesWindowHandler this$0) {
        this$0.rebuildTree();
        this$0.updateTitle();
    }

    private static final boolean rebuildTree$lambda$0$0() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit rebuildTree$lambda$0(BackendLocalChangesWindowHandler this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Node $this$mapTo$iv$iv2;
        void destination$iv;
        void $this$mapTo$iv;
        Object oldNode;
        Iterable it;
        Object nodePresentation;
        ChangeListManagerImpl changeListManagerImpl = ChangeListManagerImpl.getInstanceImpl((Project)this$0.session.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)changeListManagerImpl, (String)"getInstanceImpl(...)");
        ChangeListManagerImpl changeListManager = changeListManagerImpl;
        Project project = this$0.session.getProject();
        ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this$0.groupingSupport.getGrouping();
        List list = changeListManager.getChangeLists();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
        List list2 = changeListManager.getUnversionedFilesPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getUnversionedFilesPaths(...)");
        List list3 = changeListManager.getIgnoredFilePaths();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getIgnoredFilePaths(...)");
        DefaultTreeModel treeModel = ChangesViewUtil.INSTANCE.createTreeModel(project, changesGroupingPolicyFactory, list, list2, list3, BackendLocalChangesWindowHandler::rebuildTree$lambda$0$0);
        List newRoots = new ArrayList();
        Map nodeMap = new LinkedHashMap();
        Map idToNodeMap = new LinkedHashMap();
        NodeModelRenderer nodeModelRenderer = new NodeModelRenderer(this$0.session.getProject());
        Object object = treeModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        JBIterable jBIterable = TreeUtil.treeNodeTraverser((TreeNode)((DefaultMutableTreeNode)object)).preOrderDfsTraversal();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"preOrderDfsTraversal(...)");
        Object $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            TreeNode node = (TreeNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode<*>");
            ChangesBrowserNode cfr_ignored_0 = (ChangesBrowserNode)node;
            if (Intrinsics.areEqual((Object)node, (Object)treeModel.getRoot())) continue;
            int nodeId = ++this$0.lastNodeId;
            nodePresentation = BackendLocalChangesHostKt.access$toPresentationModel(node, nodeModelRenderer);
            Node newNode = new Node(nodeId, (NodePresentationModel)nodePresentation);
            nodeMap.put(node, newNode);
            idToNodeMap.put(nodeId, newNode);
            Node parent = (Node)nodeMap.get(((ChangesBrowserNode)node).getParent());
            if (parent == null) {
                ((Collection)newRoots).add(newNode);
                continue;
            }
            ((Collection)parent.getChildren()).add(newNode);
        }
        BackendLocalChangesHostKt.access$tryReuseOldIds(this$0.roots, newRoots);
        BackendLocalChangesHostKt.access$tryReuseOldLeafNodes(this$0.roots, newRoots);
        this$0.roots = newRoots;
        Object $i$f$forEach22 = $this$forEach$iv = (Map)new LinkedHashMap();
        BackendLocalChangesWindowHandler backendLocalChangesWindowHandler = this$0;
        boolean $i$a$-also-BackendLocalChangesWindowHandler$rebuildTree$1$32 = false;
        Map $this$forEach$iv2 = nodeMap;
        boolean $i$f$forEach32 = false;
        for (Map.Entry element$iv : $this$forEach$iv2.entrySet()) {
            boolean bl;
            nodePresentation = element$iv;
            boolean bl2 = false;
            ChangesBrowserNode vcsNode = (ChangesBrowserNode)nodePresentation.getKey();
            Node node = (Node)nodePresentation.getValue();
            if (node.getPresentation().isHelperNode()) continue;
            oldNode = it.put(node.getNodeId(), vcsNode);
            boolean bl3 = bl = oldNode == null;
            if (!_Assertions.ENABLED || bl) continue;
            boolean $i$a$-assert-BackendLocalChangesWindowHandler$rebuildTree$1$2$1$22 = false;
            String $i$a$-assert-BackendLocalChangesWindowHandler$rebuildTree$1$2$1$22 = "Duplicated ids in tree: " + node + " - " + oldNode;
            throw new AssertionError((Object)$i$a$-assert-BackendLocalChangesWindowHandler$rebuildTree$1$2$1$22);
        }
        backendLocalChangesWindowHandler.idToDataMap = $this$forEach$iv;
        it = nodeMap.values();
        Collection $i$a$-also-BackendLocalChangesWindowHandler$rebuildTree$1$32 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void node;
            Node element$iv = (Node)item$iv;
            backendLocalChangesWindowHandler = destination$iv;
            boolean bl = false;
            backendLocalChangesWindowHandler.add(node.getNodeId());
        }
        Set allNodesIds = (Set)destination$iv;
        Set oldNodesIds = this$0.model.getTree().getNodes().keySet();
        Set newNodes = SetsKt.minus((Set)allNodesIds, (Iterable)oldNodesIds);
        Set removedNodes = SetsKt.minus((Set)oldNodesIds, (Iterable)allNodesIds);
        Object $i$f$forEach32 = removedNodes.iterator();
        while ($i$f$forEach32.hasNext()) {
            int nodeId = ((Number)$i$f$forEach32.next()).intValue();
            this$0.model.getTree().getNodes().remove((Object)nodeId);
        }
        $i$f$forEach32 = newNodes.iterator();
        while ($i$f$forEach32.hasNext()) {
            int nodeId = ((Number)$i$f$forEach32.next()).intValue();
            Object v = idToNodeMap.get(nodeId);
            Intrinsics.checkNotNull(v);
            Node node = (Node)v;
            Map bl = (Map)this$0.model.getTree().getNodes();
            Integer bl2 = node.getNodeId();
            Iterable $this$map$iv2 = node.getChildren();
            boolean $i$f$map = false;
            oldNode = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it2;
                Object item$iv$iv = iterator2.next();
                Node node2 = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it2.getNodeId());
            }
            Integer n = node.getPresentation().getBackgroundColor();
            boolean bl5 = node.getPresentation().isHelperNode();
            IconModel iconModel = node.getPresentation().getIcon();
            List<RdTextChunk> list4 = node.getPresentation().getText();
            List list5 = (List)destination$iv$iv;
            RdLocalChangesItem rdLocalChangesItem = new RdLocalChangesItem(list5, list4, iconModel, bl5, n);
            bl.put(bl2, rdLocalChangesItem);
        }
        $i$f$forEach32 = newRoots;
        backendLocalChangesWindowHandler = this$0.model.getTree().getRoots();
        boolean $i$f$map = false;
        void node = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            $this$mapTo$iv$iv2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it3.getNodeId());
        }
        backendLocalChangesWindowHandler.set((List)destination$iv$iv);
        return Unit.INSTANCE;
    }
}

