/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.vcs.backend.split.BlockModel;
import com.intellij.platform.vcs.backend.split.InnerModel;
import com.intellij.platform.vcs.backend.split.LineModel;
import com.intellij.platform.vcs.backend.split.RemoteDiffViewer;
import com.intellij.platform.vcs.backend.split.RemoteDiffViewerKt;
import com.intellij.platform.vcs.backend.split.UtilKt;
import com.intellij.platform.vcs.common.split.TextDiffSettingsExKt;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.model.DiffMarkerType;
import com.jetbrains.rd.ide.model.DiffPaintMode;
import com.jetbrains.rd.ide.model.diffViewer.DiffHighlightPolicy;
import com.jetbrains.rd.ide.model.diffViewer.DiffIgnorePolicy;
import com.jetbrains.rd.ide.model.diffViewer.DiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.TextDiffSettings;
import com.jetbrains.rd.ide.model.diffViewer.TwoSideDiffViewerModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdserver.daemon.BackendMarkupHost;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006234567B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\u0016\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0010H\u0002J\u001e\u0010$\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00102\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00102\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010(\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00102\u0006\u0010)\u001a\u00020&H\u0002J6\u0010*\u001a\u00020\u001f\"\u0004\b\u0000\u0010+2\u0018\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H+0.0-2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H+01H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer;", "Lcom/intellij/platform/vcs/backend/split/RemoteDiffViewer;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rd/ide/model/diffViewer/TwoSideDiffViewerModel;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/diffViewer/TwoSideDiffViewerModel;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/diffViewer/TwoSideDiffViewerModel;", "editor1", "Lcom/intellij/openapi/editor/ex/EditorEx;", "editor2", "editors", "", "disposable", "Lcom/intellij/openapi/Disposable;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "highlighters", "", "", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "lastChangeId", "", "documentStateWasChanged", "", "scheduleRediff", "", "rediff", "updateChangeBlocks", "fragments", "Lcom/intellij/diff/fragments/LineFragment;", "updateLineHighlighters", "side", "Lcom/intellij/diff/util/Side;", "updateInnerHighlighters", "updateGutterOperationActions", "source", "updateHighlighters", "T", "iterable", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "type", "Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$DiffHighlighterType;", "BlockType", "LineType", "InnerType", "GutterOperationType", "DiffHighlighterType", "MyApplyGutterAction", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nRemoteDiffViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDiffViewer.kt\ncom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,520:1\n39#2,5:521\n*S KotlinDebug\n*F\n+ 1 RemoteDiffViewer.kt\ncom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer\n*L\n132#1:521,5\n*E\n"})
public final class TwoSideRemoteDiffViewer
extends RemoteDiffViewer {
    @NotNull
    private final TwoSideDiffViewerModel model;
    @NotNull
    private final EditorEx editor1;
    @NotNull
    private final EditorEx editor2;
    @NotNull
    private final List<EditorEx> editors;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final Map<Object, List<RangeHighlighter>> highlighters;
    private long lastChangeId;
    private boolean documentStateWasChanged;

    public TwoSideRemoteDiffViewer(@NotNull ClientProjectSession session, @NotNull Lifetime lifetime, @NotNull TwoSideDiffViewerModel model) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(session, lifetime, (DiffViewerModel)model);
        this.model = model;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        this.queue = new MergingUpdateQueue("TwoSideRemoteDiffViewer", 300, true, null, this.disposable, null, false, 96, null);
        this.highlighters = new LinkedHashMap();
        BackendEditorHost editorHost = BackendEditorHost.Companion.getInstance(session.getAppSession());
        Editor editor = editorHost.tryGetOwnRemoteEditor(this.getModel().getContent1().getEditorId());
        EditorEx editor1 = editor instanceof EditorEx ? (EditorEx)editor : null;
        Object[] objectArray = editorHost.tryGetOwnRemoteEditor(this.getModel().getContent2().getEditorId());
        EditorEx editor2 = objectArray instanceof EditorEx ? (EditorEx)objectArray : null;
        lifetime.onTermination(() -> TwoSideRemoteDiffViewer._init_$lambda$0(editor1, editor2));
        EditorEx editorEx = editor1;
        if (editorEx == null) {
            throw new IllegalStateException(("Editor not found: " + this.getModel().getContent1().getEditorId()).toString());
        }
        this.editor1 = editorEx;
        EditorEx editorEx2 = editor2;
        if (editorEx2 == null) {
            throw new IllegalStateException(("Editor not found: " + this.getModel().getContent2().getEditorId()).toString());
        }
        this.editor2 = editorEx2;
        objectArray = new EditorEx[]{editor1, editor2};
        this.editors = CollectionsKt.listOf((Object[])objectArray);
        DocumentListener documentListener2 = new DocumentListener(this){
            final /* synthetic */ TwoSideRemoteDiffViewer this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TwoSideRemoteDiffViewer.access$setDocumentStateWasChanged$p(this.this$0, true);
                TwoSideRemoteDiffViewer.access$scheduleRediff(this.this$0);
            }
        };
        editor1.getDocument().addDocumentListener(documentListener2, this.disposable);
        editor2.getDocument().addDocumentListener(documentListener2, this.disposable);
        this.getModel().getSettings().advise(lifetime, arg_0 -> TwoSideRemoteDiffViewer._init_$lambda$1(this, arg_0));
        this.scheduleRediff();
    }

    @NotNull
    public TwoSideDiffViewerModel getModel() {
        return this.model;
    }

    private final void scheduleRediff() {
        this.queue.queue(Update.Companion.create((Object)"rediff", () -> TwoSideRemoteDiffViewer.scheduleRediff$lambda$0(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rediff() {
        TextDiffSettings textDiffSettings;
        TextDiffSettings highlightPolicy;
        this.documentStateWasChanged = false;
        CharSequence charSequence = this.editor1.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence text1 = charSequence;
        CharSequence charSequence2 = this.editor2.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
        CharSequence text2 = charSequence2;
        LineOffsets lineOffsets = LineOffsetsUtil.create((Document)((Document)this.editor1.getDocument()));
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets lineOffsets1 = lineOffsets;
        LineOffsets lineOffsets2 = LineOffsetsUtil.create((Document)((Document)this.editor2.getDocument()));
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(...)");
        LineOffsets lineOffsets22 = lineOffsets2;
        TextDiffSettings textDiffSettings2 = (TextDiffSettings)this.getModel().getSettings().getValueOrNull();
        if (textDiffSettings2 == null || (textDiffSettings2 = textDiffSettings2.getHighlightPolicy()) == null || (textDiffSettings2 = TextDiffSettingsExKt.toPolicy((DiffHighlightPolicy)textDiffSettings2)) == null) {
            textDiffSettings2 = highlightPolicy = HighlightPolicy.BY_WORD;
        }
        if ((textDiffSettings = (TextDiffSettings)this.getModel().getSettings().getValueOrNull()) == null || (textDiffSettings = textDiffSettings.getIgnorePolicy()) == null || (textDiffSettings = TextDiffSettingsExKt.toPolicy((DiffIgnorePolicy)textDiffSettings)) == null) {
            textDiffSettings = IgnorePolicy.DEFAULT;
        }
        TextDiffSettings ignorePolicy = textDiffSettings;
        List list = SimpleTextDiffProvider.compareRange(null, (CharSequence)text1, (CharSequence)text2, (LineOffsets)lineOffsets1, (LineOffsets)lineOffsets22, null, (IgnorePolicy)ignorePolicy, (HighlightPolicy)highlightPolicy, (ProgressIndicator)((ProgressIndicator)DumbProgressIndicator.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareRange(...)");
        List rawFragments = (List)CollectionsKt.single((List)list);
        List list2 = ComparisonManager.getInstance().processBlocks(rawFragments, text1, text2, ignorePolicy.getComparisonPolicy(), highlightPolicy.isShouldSquash(), ignorePolicy.isShouldTrimChunks());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"processBlocks(...)");
        List fragments = list2;
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lifetime = def$iv.getLifetime();
            boolean bl = false;
            BackendMarkupHost markupHost = BackendMarkupHost.Companion.getInstance(this.getSession().getAppSession());
            markupHost.suppressRangeMarkers(lifetime, (Editor)this.editor1, "diff highlighting");
            markupHost.suppressRangeMarkers(lifetime, (Editor)this.editor2, "diff highlighting");
            this.updateChangeBlocks(fragments);
            this.updateLineHighlighters(fragments, Side.LEFT);
            this.updateLineHighlighters(fragments, Side.RIGHT);
            this.updateInnerHighlighters(fragments, Side.LEFT);
            this.updateInnerHighlighters(fragments, Side.RIGHT);
            this.updateGutterOperationActions(fragments, Side.LEFT);
            this.updateGutterOperationActions(fragments, Side.RIGHT);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    private final void updateChangeBlocks(List<? extends LineFragment> fragments) {
        List list = this.highlighters.computeIfAbsent(new BlockType(Side.LEFT), arg_0 -> TwoSideRemoteDiffViewer.updateChangeBlocks$lambda$1(TwoSideRemoteDiffViewer::updateChangeBlocks$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        List highlighters1 = list;
        List list2 = this.highlighters.computeIfAbsent(new BlockType(Side.RIGHT), arg_0 -> TwoSideRemoteDiffViewer.updateChangeBlocks$lambda$3(TwoSideRemoteDiffViewer::updateChangeBlocks$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"computeIfAbsent(...)");
        List highlighters2 = list2;
        MarkupModelEx markupModelEx = this.editor1.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel1 = markupModelEx;
        MarkupModelEx markupModelEx2 = this.editor2.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx2, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel2 = markupModelEx2;
        PeekableIterator highlighterIt1 = (PeekableIterator)new PeekableIteratorWrapper(highlighters1.iterator());
        List newHighlighters1 = new ArrayList();
        List oldHighlighters1 = new ArrayList();
        PeekableIterator highlighterIt2 = (PeekableIterator)new PeekableIteratorWrapper(highlighters2.iterator());
        List newHighlighters2 = new ArrayList();
        List oldHighlighters2 = new ArrayList();
        for (LineFragment lineFragment : fragments) {
            Object object;
            BlockModel model2;
            DiffMarkerType type = RemoteDiffViewerKt.access$getLineFragmentType(lineFragment);
            boolean isExcluded = false;
            boolean isSkipped = false;
            boolean isEmptyRange1 = lineFragment.getStartLine1() == lineFragment.getEndLine1();
            boolean isEmptyRange2 = lineFragment.getStartLine2() == lineFragment.getEndLine2();
            boolean isEOF1 = lineFragment.getEndLine1() == DiffUtil.getLineCount((Document)((Document)this.editor1.getDocument()));
            boolean isEOF2 = lineFragment.getEndLine2() == DiffUtil.getLineCount((Document)((Document)this.editor2.getDocument()));
            TextRange textRange1 = new TextRange(lineFragment.getStartOffset1(), lineFragment.getEndOffset1());
            TextRange textRange2 = new TextRange(lineFragment.getStartOffset2(), lineFragment.getEndOffset2());
            while (highlighterIt1.hasNext() && ((RangeHighlighter)highlighterIt1.peek()).getStartOffset() < textRange1.getStartOffset()) {
                oldHighlighters1.add(highlighterIt1.next());
            }
            while (highlighterIt2.hasNext() && ((RangeHighlighter)highlighterIt2.peek()).getStartOffset() < textRange2.getStartOffset()) {
                oldHighlighters2.add(highlighterIt2.next());
            }
            RangeHighlighter oldHighlighter1 = highlighterIt1.hasNext() ? (RangeHighlighter)highlighterIt1.peek() : null;
            RangeHighlighter oldHighlighter2 = highlighterIt2.hasNext() ? (RangeHighlighter)highlighterIt2.peek() : null;
            RangeHighlighter rangeHighlighter = oldHighlighter1;
            BlockModel model1 = rangeHighlighter != null ? RemoteDiffViewerKt.access$getBlockModel(rangeHighlighter) : null;
            RangeHighlighter rangeHighlighter2 = oldHighlighter2;
            BlockModel blockModel = model2 = rangeHighlighter2 != null ? RemoteDiffViewerKt.access$getBlockModel(rangeHighlighter2) : null;
            if (!(model1 == null || model2 == null || model1.getChangeId() != model2.getChangeId() || oldHighlighter1.getStartOffset() != textRange1.getStartOffset() || oldHighlighter1.getEndOffset() != textRange1.getEndOffset() || oldHighlighter2.getStartOffset() != textRange2.getStartOffset() || oldHighlighter2.getEndOffset() != textRange2.getEndOffset() || model1.getType() != type || model1.isExcluded() || model1.isSkipped() || model1.isEmptyRange() != isEmptyRange1 || model1.isEOF() != isEOF1 || model2.getType() != type || model2.isExcluded() || model2.isSkipped() || model2.isEmptyRange() != isEmptyRange2 || model2.isEOF() != isEOF2)) {
                newHighlighters1.add(oldHighlighter1);
                newHighlighters2.add(oldHighlighter2);
                highlighterIt1.next();
                object = highlighterIt2.next();
                continue;
            }
            long l = this.lastChangeId;
            this.lastChangeId = l + 1L;
            long changeId = l;
            RangeHighlighterEx rangeHighlighterEx = markupModel1.addRangeHighlighterAndChangeAttributes(null, textRange1.getStartOffset(), textRange1.getEndOffset(), 6000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> TwoSideRemoteDiffViewer.updateChangeBlocks$lambda$5(arg_0 -> TwoSideRemoteDiffViewer.updateChangeBlocks$lambda$4(type, changeId, isExcluded, isSkipped, isEmptyRange1, isEOF1, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
            newHighlighters1.add(rangeHighlighterEx);
            rangeHighlighterEx = markupModel2.addRangeHighlighterAndChangeAttributes(null, textRange2.getStartOffset(), textRange2.getEndOffset(), 6000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> TwoSideRemoteDiffViewer.updateChangeBlocks$lambda$7(arg_0 -> TwoSideRemoteDiffViewer.updateChangeBlocks$lambda$6(type, changeId, isExcluded, isSkipped, isEmptyRange2, isEOF2, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
            object = newHighlighters2.add(rangeHighlighterEx);
        }
        while (highlighterIt1.hasNext()) {
            oldHighlighters1.add(highlighterIt1.next());
        }
        while (highlighterIt2.hasNext()) {
            oldHighlighters2.add(highlighterIt2.next());
        }
        for (RangeHighlighter rangeHighlighter : oldHighlighters1) {
            rangeHighlighter.dispose();
        }
        for (RangeHighlighter rangeHighlighter : oldHighlighters2) {
            rangeHighlighter.dispose();
        }
        highlighters1.clear();
        highlighters1.addAll(newHighlighters1);
        highlighters2.clear();
        highlighters2.addAll(newHighlighters2);
    }

    private final void updateLineHighlighters(List<? extends LineFragment> fragments, Side side) {
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)fragments), arg_0 -> TwoSideRemoteDiffViewer.updateLineHighlighters$lambda$0(side, arg_0));
        this.updateHighlighters(sequence, new LineType(side));
    }

    private final void updateInnerHighlighters(List<? extends LineFragment> fragments, Side side) {
        Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)fragments), arg_0 -> TwoSideRemoteDiffViewer.updateInnerHighlighters$lambda$0(side, arg_0));
        this.updateHighlighters(sequence, new InnerType(side));
    }

    private final void updateGutterOperationActions(List<? extends LineFragment> fragments, Side source) {
        EditorEx targetEditor = (EditorEx)source.other().selectNotNull(this.editors);
        if (targetEditor.isViewer() || !targetEditor.getDocument().isWritable()) {
            return;
        }
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)fragments), arg_0 -> TwoSideRemoteDiffViewer.updateGutterOperationActions$lambda$0(source, arg_0));
        this.updateHighlighters(sequence, new GutterOperationType(source));
    }

    private final <T> void updateHighlighters(Sequence<? extends Pair<? extends TextRange, ? extends T>> iterable, DiffHighlighterType<T> type) {
        MarkupModelEx markupModelEx = ((EditorEx)type.getSide().select(this.editors)).getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        List list = this.highlighters.computeIfAbsent(type, arg_0 -> TwoSideRemoteDiffViewer.updateHighlighters$lambda$1(TwoSideRemoteDiffViewer::updateHighlighters$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        List highlighters = list;
        PeekableIterator highlighterIt = (PeekableIterator)new PeekableIteratorWrapper(highlighters.iterator());
        List newHighlighters = new ArrayList();
        List oldHighlighters = new ArrayList();
        for (Pair pair : iterable) {
            Object object;
            RangeHighlighter oldHighlighter;
            TextRange textRange = (TextRange)pair.component1();
            Object fragment = pair.component2();
            while (highlighterIt.hasNext() && ((RangeHighlighter)highlighterIt.peek()).getStartOffset() < textRange.getStartOffset()) {
                oldHighlighters.add(highlighterIt.next());
            }
            RangeHighlighter rangeHighlighter = oldHighlighter = highlighterIt.hasNext() ? (RangeHighlighter)highlighterIt.peek() : null;
            if (oldHighlighter != null && oldHighlighter.getStartOffset() == textRange.getStartOffset() && oldHighlighter.getEndOffset() == textRange.getEndOffset() && type.isSameHighlighter(oldHighlighter, fragment)) {
                newHighlighters.add(oldHighlighter);
                object = highlighterIt.next();
                continue;
            }
            object = newHighlighters.add(type.createHighlighter(markupModel, textRange, fragment));
        }
        while (highlighterIt.hasNext()) {
            oldHighlighters.add(highlighterIt.next());
        }
        for (RangeHighlighter highlighter : oldHighlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
        highlighters.addAll(newHighlighters);
    }

    private static final Unit _init_$lambda$0(EditorEx $editor1, EditorEx $editor2) {
        if ($editor1 != null && !$editor1.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)$editor1);
        }
        if ($editor2 != null && !$editor2.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)$editor2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TwoSideRemoteDiffViewer this$0, TextDiffSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleRediff();
        return Unit.INSTANCE;
    }

    private static final void scheduleRediff$lambda$0(TwoSideRemoteDiffViewer this$0) {
        this$0.rediff();
    }

    private static final List updateChangeBlocks$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List updateChangeBlocks$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List updateChangeBlocks$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List updateChangeBlocks$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit updateChangeBlocks$lambda$4(DiffMarkerType $type, long $changeId, boolean $isExcluded, boolean $isSkipped, boolean $isEmptyRange1, boolean $isEOF1, RangeHighlighterEx ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        RemoteDiffViewerKt.access$setBlockModel((RangeHighlighter)ex, new BlockModel($type, $changeId, $isExcluded, $isSkipped, $isEmptyRange1, $isEOF1));
        return Unit.INSTANCE;
    }

    private static final void updateChangeBlocks$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit updateChangeBlocks$lambda$6(DiffMarkerType $type, long $changeId, boolean $isExcluded, boolean $isSkipped, boolean $isEmptyRange2, boolean $isEOF2, RangeHighlighterEx ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        RemoteDiffViewerKt.access$setBlockModel((RangeHighlighter)ex, new BlockModel($type, $changeId, $isExcluded, $isSkipped, $isEmptyRange2, $isEOF2));
        return Unit.INSTANCE;
    }

    private static final void updateChangeBlocks$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Pair updateLineHighlighters$lambda$0(Side $side, LineFragment lineFragment) {
        Intrinsics.checkNotNullParameter((Object)lineFragment, (String)"lineFragment");
        TextRange textRange = new TextRange($side.getStartOffset((DiffFragment)lineFragment), $side.getEndOffset((DiffFragment)lineFragment));
        return new Pair((Object)textRange, (Object)lineFragment);
    }

    private static final Pair updateInnerHighlighters$lambda$0$0(Side $side, LineFragment $lineFragment, DiffFragment innerFragment) {
        Intrinsics.checkNotNullParameter((Object)innerFragment, (String)"innerFragment");
        TextRange textRange = new TextRange($side.getStartOffset((DiffFragment)$lineFragment) + $side.getStartOffset(innerFragment), $side.getStartOffset((DiffFragment)$lineFragment) + $side.getEndOffset(innerFragment));
        return new Pair((Object)textRange, (Object)innerFragment);
    }

    private static final Sequence updateInnerHighlighters$lambda$0(Side $side, LineFragment lineFragment) {
        Intrinsics.checkNotNullParameter((Object)lineFragment, (String)"lineFragment");
        List list = lineFragment.getInnerFragments();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Sequence innerFragments = CollectionsKt.asSequence((Iterable)list);
        return SequencesKt.map((Sequence)innerFragments, arg_0 -> TwoSideRemoteDiffViewer.updateInnerHighlighters$lambda$0$0($side, lineFragment, arg_0));
    }

    private static final Pair updateGutterOperationActions$lambda$0(Side $source, LineFragment lineFragment) {
        Intrinsics.checkNotNullParameter((Object)lineFragment, (String)"lineFragment");
        TextRange textRange = new TextRange($source.getStartOffset((DiffFragment)lineFragment), $source.getEndOffset((DiffFragment)lineFragment));
        return new Pair((Object)textRange, (Object)lineFragment);
    }

    private static final List updateHighlighters$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List updateHighlighters$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setDocumentStateWasChanged$p(TwoSideRemoteDiffViewer $this, boolean bl) {
        $this.documentStateWasChanged = bl;
    }

    public static final /* synthetic */ void access$scheduleRediff(TwoSideRemoteDiffViewer $this) {
        $this.scheduleRediff();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$BlockType;", "", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/diff/util/Side;)V", "getSide", "()Lcom/intellij/diff/util/Side;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.backend.split"})
    public static final class BlockType {
        @NotNull
        private final Side side;

        public BlockType(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.side = side;
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        @NotNull
        public final Side component1() {
            return this.side;
        }

        @NotNull
        public final BlockType copy(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return new BlockType(side);
        }

        public static /* synthetic */ BlockType copy$default(BlockType blockType, Side side, int n, Object object) {
            if ((n & 1) != 0) {
                side = blockType.side;
            }
            return blockType.copy(side);
        }

        @NotNull
        public String toString() {
            return "BlockType(side=" + this.side + ")";
        }

        public int hashCode() {
            return this.side.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockType)) {
                return false;
            }
            BlockType blockType = (BlockType)other;
            return this.side == blockType.side;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0080\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$DiffHighlighterType;", "T", "", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/diff/util/Side;)V", "getSide", "()Lcom/intellij/diff/util/Side;", "isSameHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "fragment", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Ljava/lang/Object;)Z", "createHighlighter", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lcom/intellij/openapi/util/TextRange;Ljava/lang/Object;)Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "equals", "other", "hashCode", "", "intellij.platform.vcs.backend.split"})
    private static abstract class DiffHighlighterType<T> {
        @NotNull
        private final Side side;

        public DiffHighlighterType(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.side = side;
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        public abstract boolean isSameHighlighter(@NotNull RangeHighlighter var1, T var2);

        @NotNull
        public abstract RangeHighlighter createHighlighter(@NotNull MarkupModelEx var1, @NotNull TextRange var2, T var3);

        public boolean equals(@Nullable Object other) {
            return other != null && Intrinsics.areEqual(other.getClass(), this.getClass()) && ((DiffHighlighterType)other).side == this.side;
        }

        public int hashCode() {
            return this.getClass().hashCode() * this.side.hashCode();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$GutterOperationType;", "Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$DiffHighlighterType;", "Lcom/intellij/diff/fragments/LineFragment;", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer;Lcom/intellij/diff/util/Side;)V", "isSameHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "fragment", "createHighlighter", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.platform.vcs.backend.split"})
    private final class GutterOperationType
    extends DiffHighlighterType<LineFragment> {
        public GutterOperationType(Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            super(side);
        }

        @Override
        public boolean isSameHighlighter(@NotNull RangeHighlighter highlighter, @NotNull LineFragment fragment) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            GutterIconRenderer gutterIconRenderer = highlighter.getGutterIconRenderer();
            MyApplyGutterAction renderer = gutterIconRenderer instanceof MyApplyGutterAction ? (MyApplyGutterAction)gutterIconRenderer : null;
            return renderer != null && renderer.getFragment().getStartLine1() == fragment.getStartLine1() && renderer.getFragment().getEndLine1() == fragment.getEndLine1() && renderer.getFragment().getStartLine2() == fragment.getStartLine2() && renderer.getFragment().getEndLine2() == fragment.getEndLine2();
        }

        @Override
        @NotNull
        public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markupModel, @NotNull TextRange textRange, @NotNull LineFragment fragment) {
            Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 6000, null, HighlighterTargetArea.EXACT_RANGE);
            TwoSideRemoteDiffViewer twoSideRemoteDiffViewer = TwoSideRemoteDiffViewer.this;
            RangeHighlighter $this$createHighlighter_u24lambda_u240 = rangeHighlighter;
            boolean bl = false;
            $this$createHighlighter_u24lambda_u240.setGutterIconRenderer((GutterIconRenderer)twoSideRemoteDiffViewer.new MyApplyGutterAction((LineFragment)new LineFragmentImpl(fragment, null), this.getSide()));
            RangeHighlighter rangeHighlighter2 = rangeHighlighter;
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"apply(...)");
            return rangeHighlighter2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$InnerType;", "Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$DiffHighlighterType;", "Lcom/intellij/diff/fragments/DiffFragment;", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/diff/util/Side;)V", "isSameHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "fragment", "createHighlighter", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.platform.vcs.backend.split"})
    private static final class InnerType
    extends DiffHighlighterType<DiffFragment> {
        public InnerType(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            super(side);
        }

        @Override
        public boolean isSameHighlighter(@NotNull RangeHighlighter highlighter, @NotNull DiffFragment fragment) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            InnerModel model = RemoteDiffViewerKt.access$getInnerModel(highlighter);
            return model != null && model.getType() == RemoteDiffViewerKt.access$getInnerFragmentType(fragment);
        }

        @Override
        @NotNull
        public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markupModel, @NotNull TextRange textRange, @NotNull DiffFragment fragment) {
            Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            RangeHighlighterEx rangeHighlighterEx = markupModel.addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 6000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> InnerType.createHighlighter$lambda$1(arg_0 -> InnerType.createHighlighter$lambda$0(fragment, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
            return (RangeHighlighter)rangeHighlighterEx;
        }

        private static final Unit createHighlighter$lambda$0(DiffFragment $fragment, RangeHighlighterEx ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            RemoteDiffViewerKt.access$setInnerModel((RangeHighlighter)ex, new InnerModel(RemoteDiffViewerKt.access$getInnerFragmentType($fragment)));
            return Unit.INSTANCE;
        }

        private static final void createHighlighter$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$LineType;", "Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$DiffHighlighterType;", "Lcom/intellij/diff/fragments/LineFragment;", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer;Lcom/intellij/diff/util/Side;)V", "isSameHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "fragment", "createHighlighter", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "createLineModel", "Lcom/intellij/platform/vcs/backend/split/LineModel;", "intellij.platform.vcs.backend.split"})
    private final class LineType
    extends DiffHighlighterType<LineFragment> {
        public LineType(Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            super(side);
        }

        @Override
        public boolean isSameHighlighter(@NotNull RangeHighlighter highlighter, @NotNull LineFragment fragment) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            LineModel model = RemoteDiffViewerKt.access$getLineModel(highlighter);
            return model != null && Intrinsics.areEqual((Object)model, (Object)this.createLineModel(fragment));
        }

        @Override
        @NotNull
        public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markupModel, @NotNull TextRange textRange, @NotNull LineFragment fragment) {
            Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            RangeHighlighterEx rangeHighlighterEx = markupModel.addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 6000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> LineType.createHighlighter$lambda$1(arg_0 -> LineType.createHighlighter$lambda$0(this, fragment, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
            return (RangeHighlighter)rangeHighlighterEx;
        }

        private final LineModel createLineModel(LineFragment fragment) {
            DiffDrawUtil.PaintMode editorMode = fragment.getInnerFragments() != null ? DiffDrawUtil.PaintMode.IGNORED : DiffDrawUtil.PaintMode.DEFAULT;
            DiffDrawUtil.PaintMode gutterMode = DiffDrawUtil.PaintMode.DEFAULT;
            DiffMarkerType diffMarkerType = RemoteDiffViewerKt.access$getLineFragmentType(fragment);
            Intrinsics.checkNotNull((Object)editorMode);
            DiffPaintMode diffPaintMode = UtilKt.toPaintMode(editorMode);
            Intrinsics.checkNotNull((Object)gutterMode);
            return new LineModel(diffMarkerType, diffPaintMode, UtilKt.toPaintMode(gutterMode), this.getSide().getStartLine(fragment) == this.getSide().getEndLine(fragment), this.getSide().getEndLine(fragment) == ((EditorEx)this.getSide().selectNotNull(TwoSideRemoteDiffViewer.this.editors)).getDocument().getLineCount());
        }

        private static final Unit createHighlighter$lambda$0(LineType this$0, LineFragment $fragment, RangeHighlighterEx ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            RemoteDiffViewerKt.access$setLineModel((RangeHighlighter)ex, this$0.createLineModel($fragment));
            return Unit.INSTANCE;
        }

        private static final void createHighlighter$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0082\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u0096\u0080\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer$MyApplyGutterAction;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "fragment", "Lcom/intellij/diff/fragments/LineFragment;", "source", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/TwoSideRemoteDiffViewer;Lcom/intellij/diff/fragments/LineFragment;Lcom/intellij/diff/util/Side;)V", "getFragment", "()Lcom/intellij/diff/fragments/LineFragment;", "getSource", "()Lcom/intellij/diff/util/Side;", "getIcon", "Ljavax/swing/Icon;", "equals", "", "other", "", "hashCode", "", "getTooltipText", "", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.vcs.backend.split"})
    private final class MyApplyGutterAction
    extends GutterIconRenderer {
        @NotNull
        private final LineFragment fragment;
        @NotNull
        private final Side source;

        public MyApplyGutterAction(@NotNull LineFragment fragment, Side source) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.fragment = fragment;
            this.source = source;
        }

        @NotNull
        public final LineFragment getFragment() {
            return this.fragment;
        }

        @NotNull
        public final Side getSource() {
            return this.source;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = DiffUtil.getArrowIcon((Side)this.source);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getArrowIcon(...)");
            return icon;
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public String getTooltipText() {
            String string = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public AnAction getClickAction() {
            DumbAwareAction dumbAwareAction = DumbAwareAction.create(arg_0 -> MyApplyGutterAction.getClickAction$lambda$1(arg_0 -> MyApplyGutterAction.getClickAction$lambda$0(TwoSideRemoteDiffViewer.this, this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
            return (AnAction)dumbAwareAction;
        }

        private static final void getClickAction$lambda$0$0(DocumentEx $targetDocument, Side $target, MyApplyGutterAction this$0, DocumentEx $sourceDocument) {
            DiffUtil.applyModification((Document)((Document)$targetDocument), (int)$target.getStartLine(this$0.fragment), (int)$target.getEndLine(this$0.fragment), (Document)((Document)$sourceDocument), (int)this$0.source.getStartLine(this$0.fragment), (int)this$0.source.getEndLine(this$0.fragment));
        }

        private static final Unit getClickAction$lambda$0(TwoSideRemoteDiffViewer this$0, MyApplyGutterAction this$1, AnActionEvent it) {
            if (this$0.documentStateWasChanged) {
                return Unit.INSTANCE;
            }
            Side target = this$1.source.other();
            DocumentEx documentEx = ((EditorEx)this$1.source.selectNotNull(this$0.editors)).getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx sourceDocument = documentEx;
            DocumentEx documentEx2 = ((EditorEx)target.selectNotNull(this$0.editors)).getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
            DocumentEx targetDocument = documentEx2;
            DiffUtil.executeWriteCommand((Document)((Document)targetDocument), (Project)this$0.getSession().getProject(), (String)DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), () -> MyApplyGutterAction.getClickAction$lambda$0$0(targetDocument, target, this$1, sourceDocument));
            return Unit.INSTANCE;
        }

        private static final void getClickAction$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

