/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettingsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ParameterNameHintsSettings", storages={@Storage(value="parameter.hints.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0007\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002,-B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0016J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0015\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\u0007\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\bH\u0002J\u001e\u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\bH\u0002J\u0012\u0010+\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000ej\b\u0012\u0004\u0012\u00020\u0007`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "removedPatterns", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "addedPatterns", "options", "", "disabledLanguages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addIgnorePattern", "", "language", "Lcom/intellij/lang/Language;", "pattern", "getExcludeListDiff", "Lcom/intellij/codeInsight/hints/settings/Diff;", "setExcludeListDiff", "diff", "getState", "setIsEnabledForLanguage", "enabled", "isEnabledForLanguage", "loadState", "state", "getOption", "optionId", "(Ljava/lang/String;)Ljava/lang/Boolean;", "setOption", "value", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "getAddedPatterns", "getRemovedPatterns", "setRemovedPatterns", "removed", "setAddedPatterns", "added", "fireExcludeListChanged", "Companion", "ExcludeListListener", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nParameterNameHintsSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParameterNameHintsSettings.kt\ncom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,233:1\n1915#2:234\n1586#2:235\n1661#2,3:236\n1586#2:239\n1661#2,3:240\n1916#2:243\n1586#2:246\n1661#2,3:247\n1915#2,2:250\n1915#2,2:252\n1915#2,2:254\n221#3,2:244\n*S KotlinDebug\n*F\n+ 1 ParameterNameHintsSettings.kt\ncom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings\n*L\n79#1:234\n85#1:235\n85#1:236,3\n86#1:239\n86#1:240,3\n79#1:243\n103#1:246\n103#1:247,3\n135#1:250,2\n145#1:252,2\n151#1:254,2\n94#1:244,2\n*E\n"})
public final class ParameterNameHintsSettings
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Set<String>> removedPatterns = new HashMap();
    @NotNull
    private final HashMap<String, Set<String>> addedPatterns = new HashMap();
    @NotNull
    private final HashMap<String, Boolean> options = new HashMap();
    @NotNull
    private final HashSet<String> disabledLanguages = new HashSet();

    public final void addIgnorePattern(@NotNull Language language, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Set<String> patternsBefore = this.getAddedPatterns(language);
        this.setAddedPatterns(language, SetsKt.plus(patternsBefore, (Object)pattern));
    }

    @NotNull
    public final Diff getExcludeListDiff(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Set<String> added = this.getAddedPatterns(language);
        Set<String> removed = this.getRemovedPatterns(language);
        return new Diff(added, removed);
    }

    public final void setExcludeListDiff(@NotNull Language language, @NotNull Diff diff) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.setAddedPatterns(language, diff.getAdded());
        this.setRemovedPatterns(language, diff.getRemoved());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Element getState() {
        Object element;
        Object object;
        Element root = new Element("settings");
        if (!((Map)this.removedPatterns).isEmpty() || !((Map)this.addedPatterns).isEmpty()) {
            Element blacklists = new Element("blacklists");
            root.addContent(blacklists);
            Set<String> set = this.removedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Set<String> set2 = this.addedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            Set allLanguages = SetsKt.plus(set, (Iterable)set2);
            Iterable $this$forEach$iv = allLanguages;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Element element2;
                Set set3;
                Set removed;
                Object element$iv = object.next();
                String it = (String)element$iv;
                boolean bl = false;
                Set set4 = this.removedPatterns.get(it);
                if (set4 == null) {
                    set4 = removed = SetsKt.emptySet();
                }
                if ((set3 = this.addedPatterns.get(it)) == null) {
                    set3 = SetsKt.emptySet();
                }
                Set added = set3;
                Element $this$getState_u24lambda_u240_u240 = element2 = new Element("blacklist");
                boolean bl2 = false;
                $this$getState_u24lambda_u240_u240.setAttribute("language", it);
                Iterable $this$map$iv = removed;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(ParameterNameHintsSettingsKt.access$toPatternElement((String)it2, "removed"));
                }
                List removedElements = (List)destination$iv$iv;
                Iterable $this$map$iv2 = added;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    String bl3 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(ParameterNameHintsSettingsKt.access$toPatternElement((String)it3, "added"));
                }
                List addedElements = (List)destination$iv$iv2;
                $this$getState_u24lambda_u240_u240.addContent((Collection)CollectionsKt.plus((Collection)addedElements, (Iterable)removedElements));
                Element languageBlacklist = element2;
                blacklists.addContent(languageBlacklist);
            }
        }
        Map $this$forEach$iv = this.options;
        boolean $i$f$forEach2 = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String id = (String)object.getKey();
            boolean value = (Boolean)object.getValue();
            element = new Element("option");
            element.setAttribute("id", id);
            element.setAttribute("value", String.valueOf(value));
            root.addContent(element);
        }
        if (!((Collection)this.disabledLanguages).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Element disabledLanguagesElement = new Element("disabledLanguages");
            Iterable $i$f$forEach2 = this.disabledLanguages;
            Element element3 = disabledLanguagesElement;
            boolean $i$f$map = false;
            void element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Element element4 = new Element("language");
                element4.setAttribute("id", (String)it);
                collection.add(element4);
            }
            element3.addContent((Collection)((List)destination$iv$iv));
            root.addContent(disabledLanguagesElement);
        }
        return root;
    }

    public final void setIsEnabledForLanguage(boolean enabled, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        boolean bl = !enabled ? this.disabledLanguages.add(language.getID()) : this.disabledLanguages.remove(language.getID());
    }

    public final boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return !this.disabledLanguages.contains(language.getID());
    }

    public void loadState(@NotNull Element state) {
        List list;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.addedPatterns.clear();
        this.removedPatterns.clear();
        this.options.clear();
        this.disabledLanguages.clear();
        Element element = state.getChild("blacklists");
        List allBlacklistElements = element != null && (list = element.getChildren("blacklist")) != null ? list : CollectionsKt.emptyList();
        Iterable $this$forEach$iv = allBlacklistElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String language;
            Element blacklistElement = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)blacklistElement);
            if (ParameterNameHintsSettingsKt.access$attributeValue(blacklistElement, "language") == null) continue;
            Set added = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "added");
            Map map = this.addedPatterns;
            Set set = this.addedPatterns.get(language);
            if (set == null || (set = SetsKt.plus((Set)set, (Iterable)added)) == null) {
                set = added;
            }
            Object object = set;
            map.put(language, object);
            Set removed = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "removed");
            object = this.removedPatterns;
            Set set2 = this.removedPatterns.get(language);
            if (set2 == null || (set2 = SetsKt.plus((Set)set2, (Iterable)removed)) == null) {
                set2 = removed;
            }
            Set set3 = set2;
            object.put(language, set3);
        }
        List list2 = state.getChildren("option");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String id = it.getAttributeValue("id");
            ((Map)this.options).put(id, it.getAttributeBooleanValue("value"));
        }
        Element element2 = state.getChild("disabledLanguages");
        if (element2 != null) {
            Element element3;
            Element $this$loadState_u24lambda_u242 = element3 = element2;
            boolean bl = false;
            List list3 = $this$loadState_u24lambda_u242.getChildren("language");
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getChildren(...)");
            Iterable $this$forEach$iv2 = list3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String languageId;
                Element it = (Element)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (ParameterNameHintsSettingsKt.access$attributeValue(it, "id") == null) continue;
                this.disabledLanguages.add(languageId);
            }
        }
        this.fireExcludeListChanged(null);
    }

    @Nullable
    public final Boolean getOption(@NotNull String optionId) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        return this.options.get(optionId);
    }

    public final void setOption(@NotNull String optionId, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        if (value == null) {
            this.options.remove(optionId);
        } else {
            ((Map)this.options).put(optionId, value);
        }
    }

    private final Set<String> getAddedPatterns(Language language) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String key = string;
        Set set = this.addedPatterns.get(key);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Set<String> getRemovedPatterns(Language language) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String key = string;
        Set set = this.removedPatterns.get(key);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void setRemovedPatterns(Language language, Set<String> removed) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String key = string;
        ((Map)this.removedPatterns).put(key, removed);
        this.fireExcludeListChanged(language);
    }

    private final void setAddedPatterns(Language language, Set<String> added) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String key = string;
        ((Map)this.addedPatterns).put(key, added);
        this.fireExcludeListChanged(language);
    }

    private final void fireExcludeListChanged(Language language) {
        ((ExcludeListListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ExcludeListListener.TOPIC)).excludeListChanged(language);
    }

    @JvmStatic
    @NotNull
    public static final ParameterNameHintsSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ParameterNameHintsSettings getInstance() {
            Object object = ApplicationManager.getApplication().getService(ParameterNameHintsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ParameterNameHintsSettings)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$ExcludeListListener;", "", "excludeListChanged", "", "language", "Lcom/intellij/lang/Language;", "Companion", "intellij.platform.lang"})
    @ApiStatus.Experimental
    public static interface ExcludeListListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @Topic.AppLevel
        @NotNull
        public static final Topic<ExcludeListListener> TOPIC = new Topic(ExcludeListListener.class);

        public void excludeListChanged(@Nullable Language var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$ExcludeListListener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$ExcludeListListener;", "intellij.platform.lang"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

