/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.InvalidExpressionException;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexpFilter
implements Filter,
DumbAware {
    private static final Logger LOG = Logger.getInstance(RegexpFilter.class);
    @NonNls
    public static final String FILE_PATH_MACROS = "$FILE_PATH$";
    @NonNls
    public static final String LINE_MACROS = "$LINE$";
    @NonNls
    public static final String COLUMN_MACROS = "$COLUMN$";
    @NonNls
    private static final String FILE_PATH_REGEXP = "(^|[\\W])(?<file>(?:\\p{Alpha}\\:|/)[0-9 a-z_A-Z\\-\\\\./]+)";
    @NonNls
    private static final String LINE_REGEXP = "(?<line>[0-9]+)";
    @NonNls
    private static final String COLUMN_REGEXP = "(?<column>[0-9]+)";
    @NonNls
    private static final String FILE_STR = "file";
    @NonNls
    private static final String LINE_STR = "line";
    @NonNls
    private static final String COLUMN_STR = "column";
    private final boolean myHasLine;
    private final boolean myHasColumn;
    private final Pattern myPattern;
    private final Project myProject;

    public RegexpFilter(Project project, @NonNls String expression) {
        this.myProject = project;
        RegexpFilter.validate(expression);
        if (expression.trim().isEmpty()) {
            throw new InvalidExpressionException("expression == null or empty");
        }
        int filePathIndex = expression.indexOf(FILE_PATH_MACROS);
        int lineIndex = expression.indexOf(LINE_MACROS);
        int columnIndex = expression.indexOf(COLUMN_MACROS);
        if (filePathIndex == -1) {
            throw new InvalidExpressionException("Expression must contain $FILE_PATH$ macros.");
        }
        expression = StringUtil.replace((String)expression, (String)FILE_PATH_MACROS, (String)FILE_PATH_REGEXP);
        if (lineIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)LINE_MACROS, (String)LINE_REGEXP);
            this.myHasLine = true;
        } else {
            this.myHasLine = false;
        }
        if (columnIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)COLUMN_MACROS, (String)COLUMN_REGEXP);
            this.myHasColumn = true;
        } else {
            this.myHasColumn = false;
        }
        this.myPattern = Pattern.compile(expression, 8);
    }

    public static void validate(String expression) {
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            throw new InvalidExpressionException("expression == null or empty");
        }
        expression = RegexpFilter.substituteMacrosWithRegexps(expression);
        Pattern.compile(expression, 8);
    }

    public Pattern getPattern() {
        return this.myPattern;
    }

    private static String substituteMacrosWithRegexps(String expression) {
        int filePathIndex = expression.indexOf(FILE_PATH_MACROS);
        int lineIndex = expression.indexOf(LINE_MACROS);
        int columnIndex = expression.indexOf(COLUMN_MACROS);
        if (filePathIndex == -1) {
            throw new InvalidExpressionException("Expression must contain $FILE_PATH$ macros.");
        }
        expression = StringUtil.replace((String)expression, (String)FILE_PATH_MACROS, (String)FILE_PATH_REGEXP);
        if (lineIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)LINE_MACROS, (String)LINE_REGEXP);
        }
        if (columnIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)COLUMN_MACROS, (String)COLUMN_REGEXP);
        }
        return expression;
    }

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            RegexpFilter.$$$reportNull$$$0(0);
        }
        Matcher matcher = this.myPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
        try {
            if (!matcher.find()) {
                return null;
            }
        }
        catch (ProcessCanceledException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Too long matching '" + line + "' by '" + String.valueOf(this.myPattern) + "' in " + this.getClass().getName());
            }
            return null;
        }
        String filePath = matcher.group(FILE_STR);
        if (filePath == null) {
            return null;
        }
        String lineNumber = "0";
        if (this.myHasLine) {
            lineNumber = matcher.group(LINE_STR);
        }
        String columnNumber = "0";
        if (this.myHasColumn) {
            columnNumber = matcher.group(COLUMN_STR);
        }
        int line1 = 0;
        int column = 0;
        try {
            line1 = Integer.parseInt(lineNumber);
            column = Integer.parseInt(columnNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (line1 > 0) {
            --line1;
        }
        if (column > 0) {
            --column;
        }
        int highlightStartOffset = entireLength - line.length() + matcher.start(FILE_STR);
        int highlightEndOffset = highlightStartOffset + filePath.length();
        HyperlinkInfo info = this.createOpenFileHyperlink(filePath, line1, column);
        return new Filter.Result(highlightStartOffset, highlightEndOffset, info);
    }

    @Nullable
    protected HyperlinkInfo createOpenFileHyperlink(String fileName, int line, int column) {
        fileName = fileName.replace(File.separatorChar, '/');
        VirtualFile file = LocalFileSystem.getInstance().findFileByPathIfCached(fileName);
        return file != null ? new OpenFileHyperlinkInfo(this.myProject, file, line, column) : null;
    }

    public static String[] getMacrosName() {
        return new String[]{FILE_PATH_MACROS, LINE_MACROS, COLUMN_MACROS};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LINE_STR, "com/intellij/execution/filters/RegexpFilter", "applyFilter"));
    }
}

